/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.dao;

import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.dao.HibernateUtil;
import com.openkm.dao.bean.Report;
import com.openkm.util.SecureStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportDAO {
    private static Logger log = LoggerFactory.getLogger(ReportDAO.class);

    private ReportDAO() {
    }

    public static int create(Report rp) throws DatabaseException {
        log.debug("create({})", (Object)rp);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Integer id = (Integer)session.save((Object)rp);
            HibernateUtil.commit(tx);
            log.debug("create: {}", (Object)id);
            int n = id;
            return n;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int createFromFile(File repFile, String name, boolean active) throws DatabaseException, IOException {
        int n;
        log.debug("createFromFile({}, {}, {})", new Object[]{repFile, name, active});
        Session session = null;
        Transaction tx = null;
        FileInputStream fis = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            fis = new FileInputStream(repFile);
            Report rp = new Report();
            rp.setName(name);
            rp.setFileName(repFile.getName());
            rp.setFileMime(Config.mimeTypes.getContentType(repFile.getName()));
            rp.setFileContent(SecureStore.b64Encode(IOUtils.toByteArray((InputStream)fis)));
            rp.setActive(active);
            Integer id = (Integer)session.save((Object)rp);
            HibernateUtil.commit(tx);
            log.debug("createFromFile: {}", (Object)id);
            n = id;
        }
        catch (HibernateException e) {
            try {
                HibernateUtil.rollback(tx);
                throw new DatabaseException(e.getMessage(), e);
                catch (IOException e2) {
                    HibernateUtil.rollback(tx);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                HibernateUtil.close((org.hibernate.Session)session);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
        HibernateUtil.close((org.hibernate.Session)session);
        return n;
    }

    public static void update(Report rp) throws DatabaseException {
        log.debug("update({})", (Object)rp);
        String qs = "select rp.fileContent, rp.fileName from Report rp where rp.id=:id";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            if (rp.getFileContent() == null || rp.getFileContent().length() == 0) {
                Query q = session.createQuery(qs);
                q.setParameter("id", (Object)rp.getId());
                Object[] data = (Object[])q.setMaxResults(1).uniqueResult();
                rp.setFileContent((String)data[0]);
                rp.setFileName((String)data[1]);
            }
            session.update((Object)rp);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("update: void");
    }

    public static void delete(int rpId) throws DatabaseException {
        log.debug("delete({})", (Object)rpId);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Report rp = (Report)session.load(Report.class, (Serializable)Integer.valueOf(rpId));
            session.delete((Object)rp);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("delete: void");
    }

    public static Report findByPk(int rpId) throws DatabaseException {
        log.debug("findByPk({})", (Object)rpId);
        String qs = "from Report rp where rp.id=:id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setInteger("id", rpId);
            Report ret = (Report)q.setMaxResults(1).uniqueResult();
            log.debug("findByPk: {}", (Object)ret);
            Report report = ret;
            return report;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<Report> findAll() throws DatabaseException {
        log.debug("findAll()");
        String qs = "from Report rp order by rp.name";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            List ret = q.list();
            log.debug("findAll: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }
}

