/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.dao;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.Settings;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaUpdate {
    private static Logger log = LoggerFactory.getLogger(SchemaUpdate.class);
    private ConnectionProvider connectionProvider;
    private Configuration configuration;
    private Dialect dialect;
    private List<Exception> exceptions;
    private String outputFile;

    public SchemaUpdate(Configuration cfg) throws HibernateException {
        this(cfg, cfg.getProperties());
    }

    public SchemaUpdate(Configuration cfg, Properties connectionProperties) throws HibernateException {
        this.configuration = cfg;
        this.dialect = Dialect.getDialect((Properties)connectionProperties);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.dialect.getDefaultProperties());
        props.putAll((Map<?, ?>)connectionProperties);
        this.connectionProvider = ConnectionProviderFactory.newConnectionProvider((Properties)props);
        this.exceptions = new ArrayList<Exception>();
    }

    public SchemaUpdate(Configuration cfg, Settings settings) throws HibernateException {
        this.configuration = cfg;
        this.dialect = settings.getDialect();
        this.connectionProvider = settings.getConnectionProvider();
        this.exceptions = new ArrayList<Exception>();
    }

    public static void main(String[] args) {
        try {
            Configuration cfg = new Configuration();
            String outFile = null;
            boolean script = true;
            boolean doUpdate = true;
            String propFile = null;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("--")) {
                    if (args[i].equals("--quiet")) {
                        script = false;
                        continue;
                    }
                    if (args[i].startsWith("--properties=")) {
                        propFile = args[i].substring(13);
                        continue;
                    }
                    if (args[i].startsWith("--config=")) {
                        cfg.configure(args[i].substring(9));
                        continue;
                    }
                    if (args[i].startsWith("--text")) {
                        doUpdate = false;
                        continue;
                    }
                    if (args[i].startsWith("--naming=")) {
                        cfg.setNamingStrategy((NamingStrategy)ReflectHelper.classForName((String)args[i].substring(9)).newInstance());
                        continue;
                    }
                    if (!args[i].startsWith("--output=")) continue;
                    outFile = args[i].substring(9);
                    continue;
                }
                cfg.addFile(args[i]);
            }
            if (propFile != null) {
                Properties props = new Properties();
                props.putAll((Map<?, ?>)cfg.getProperties());
                props.load(new FileInputStream(propFile));
                cfg.setProperties(props);
            }
            new SchemaUpdate(cfg).setOutputFile(outFile).execute(script, doUpdate);
        }
        catch (Exception e) {
            log.error("Error running schema update", (Throwable)e);
            e.printStackTrace();
        }
    }

    public SchemaUpdate setOutputFile(String filename) {
        this.outputFile = filename;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(boolean script, boolean doUpdate) {
        log.info("Running hbm2ddl schema update");
        Connection connection = null;
        Statement stmt = null;
        boolean autoCommitWasEnabled = true;
        Writer outputFileWriter = null;
        this.exceptions.clear();
        try {
            DatabaseMetadata meta;
            try {
                log.info("fetching database metadata");
                connection = this.connectionProvider.getConnection();
                if (!connection.getAutoCommit()) {
                    connection.commit();
                    connection.setAutoCommit(true);
                    autoCommitWasEnabled = false;
                }
                meta = new DatabaseMetadata(connection, this.dialect);
                stmt = connection.createStatement();
            }
            catch (SQLException sqle) {
                this.exceptions.add(sqle);
                log.error("could not get database metadata", (Throwable)sqle);
                throw sqle;
            }
            log.info("updating schema");
            if (this.outputFile != null) {
                log.info("writing generated schema to file: " + this.outputFile);
                outputFileWriter = new FileWriter(this.outputFile);
            }
            String[] createSQL = this.configuration.generateSchemaUpdateScript(this.dialect, meta);
            for (int j = 0; j < createSQL.length; ++j) {
                String sql = createSQL[j];
                try {
                    if (script) {
                        log.info("writing generated schema to console: ");
                        System.out.println(sql);
                    }
                    if (this.outputFile != null) {
                        outputFileWriter.write(sql + "\n");
                    }
                    if (!doUpdate) continue;
                    log.debug(sql);
                    stmt.executeUpdate(sql);
                    continue;
                }
                catch (SQLException e) {
                    this.exceptions.add(e);
                    log.error("Unsuccessful: " + sql);
                    log.error(e.getMessage());
                }
            }
            log.info("schema update complete");
        }
        catch (Exception e) {
            this.exceptions.add(e);
            log.error("could not complete schema update", (Throwable)e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (!autoCommitWasEnabled) {
                    connection.setAutoCommit(false);
                }
                if (connection != null) {
                    connection.close();
                }
                if (this.connectionProvider != null) {
                    this.connectionProvider.close();
                }
            }
            catch (Exception e) {
                this.exceptions.add(e);
                log.error("Error closing connection", (Throwable)e);
            }
            try {
                if (outputFileWriter != null) {
                    outputFileWriter.close();
                }
            }
            catch (Exception e) {
                this.exceptions.add(e);
                log.error("Error closing connection", (Throwable)e);
            }
        }
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }
}

