/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.dao;

import com.openkm.core.DatabaseException;
import com.openkm.dao.HibernateUtil;
import com.openkm.dao.bean.TwitterAccount;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitterAccountDAO {
    private static Logger log = LoggerFactory.getLogger(TwitterAccountDAO.class);

    private TwitterAccountDAO() {
    }

    public static void create(TwitterAccount ta) throws DatabaseException {
        log.debug("create({})", (Object)ta);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.save((Object)ta);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("create: void");
    }

    public static void update(TwitterAccount ta) throws DatabaseException {
        log.debug("update({})", (Object)ta);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.update((Object)ta);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("update: void");
    }

    public static void delete(int taId) throws DatabaseException {
        log.debug("delete({})", (Object)taId);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            TwitterAccount ta = (TwitterAccount)session.load(TwitterAccount.class, (Serializable)Integer.valueOf(taId));
            session.delete((Object)ta);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("deleteTwitterAccount: void");
    }

    public static List<TwitterAccount> findByUser(String user, boolean filterByActive) throws DatabaseException {
        log.debug("findByUser({})", (Object)user);
        String qs = "from TwitterAccount ta where ta.user=:user " + (filterByActive ? "and ta.active=:active" : "") + " order by ta.id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("user", user);
            if (filterByActive) {
                q.setBoolean("active", true);
            }
            List ret = q.list();
            log.debug("findByUser: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<TwitterAccount> findAll(boolean filterByActive) throws DatabaseException {
        log.debug("findAll()");
        String qs = "from TwitterAccount ta " + (filterByActive ? "where ta.active=:active" : "") + " order by ta.id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            if (filterByActive) {
                q.setBoolean("active", true);
            }
            List ret = q.list();
            log.debug("findAll: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static TwitterAccount findByPk(int taId) throws DatabaseException {
        log.debug("findByPk({})", (Object)taId);
        String qs = "from TwitterAccount ta where ta.id=:id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setInteger("id", taId);
            TwitterAccount ret = (TwitterAccount)q.setMaxResults(1).uniqueResult();
            log.debug("findByPk: {}", (Object)ret);
            TwitterAccount twitterAccount = ret;
            return twitterAccount;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }
}

