/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.dao;

import com.openkm.core.DatabaseException;
import com.openkm.dao.HibernateUtil;
import com.openkm.dao.ProfileDAO;
import com.openkm.dao.bean.UserConfig;
import com.openkm.jcr.JCRUtils;
import java.io.Serializable;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserConfigDAO {
    private static Logger log = LoggerFactory.getLogger(UserConfigDAO.class);

    private UserConfigDAO() {
    }

    public static void create(UserConfig uc) throws DatabaseException {
        log.debug("create({})", (Object)uc);
        org.hibernate.classic.Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.save((Object)uc);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("create: void");
    }

    public static void update(UserConfig uc) throws DatabaseException {
        log.debug("update({})", (Object)uc);
        org.hibernate.classic.Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.update((Object)uc);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("update: void");
    }

    public static void updateProfile(String ucUser, int upId) throws DatabaseException {
        log.debug("updateProfile({}, {})", (Object)ucUser, (Object)upId);
        String qs = "update UserConfig uc set uc.profile=:profile where uc.user=:user";
        org.hibernate.classic.Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(qs);
            q.setEntity("profile", (Object)ProfileDAO.findByPk(upId));
            q.setString("user", ucUser);
            q.executeUpdate();
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("updateProfile: void");
    }

    public static void delete(String user) throws DatabaseException {
        log.debug("delete({})", (Object)user);
        org.hibernate.classic.Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            UserConfig uc = (UserConfig)session.load(UserConfig.class, (Serializable)((Object)user));
            session.delete((Object)uc);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("delete: void");
    }

    public static void setHome(UserConfig uc) throws DatabaseException {
        log.info("setHome({})", (Object)uc);
        String qs = "update UserConfig uc set uc.homePath=:path, uc.homeUuid=:uuid, uc.homeType=:type where uc.user=:user";
        org.hibernate.classic.Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(qs);
            q.setString("path", uc.getHomePath());
            q.setString("uuid", uc.getHomeUuid());
            q.setString("type", uc.getHomeType());
            q.setString("user", uc.getUser());
            q.executeUpdate();
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("setHome: void");
    }

    public static UserConfig findByPk(Session jcrSession, String user) throws DatabaseException, RepositoryException {
        log.debug("findByPk({}, {})", (Object)jcrSession, (Object)user);
        org.hibernate.classic.Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            UserConfig ret = (UserConfig)session.get(UserConfig.class, (Serializable)((Object)user));
            if (ret == null) {
                Node okmRoot = jcrSession.getRootNode().getNode("okm:root");
                ret = new UserConfig();
                ret.setHomePath(okmRoot.getPath());
                ret.setHomeUuid(okmRoot.getUUID());
                ret.setHomeType("okm:folder");
                ret.setUser(user);
                ret.setProfile(ProfileDAO.findByPk(1));
                session.save((Object)ret);
            } else {
                try {
                    Node node = jcrSession.getNodeByUUID(ret.getHomeUuid());
                    if (!node.getPath().equals(ret.getHomePath())) {
                        ret.setHomePath(node.getPath());
                        ret.setHomeType(JCRUtils.getNodeType(node));
                        session.update((Object)ret);
                    }
                }
                catch (ItemNotFoundException e) {
                    Node okmRoot = jcrSession.getRootNode().getNode("okm:root");
                    ret.setHomePath(okmRoot.getPath());
                    ret.setHomeUuid(okmRoot.getUUID());
                    ret.setHomeType("okm:folder");
                    session.save((Object)ret);
                }
            }
            HibernateUtil.commit(tx);
            log.debug("findByPk: {}", (Object)ret);
            UserConfig userConfig = ret;
            return userConfig;
        }
        catch (RepositoryException e) {
            HibernateUtil.rollback(tx);
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }
}

