/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.dao;

import com.openkm.core.DatabaseException;
import com.openkm.dao.HibernateUtil;
import com.openkm.dao.bean.cache.UserDocumentKeywords;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDocumentKeywordsDAO {
    private static Logger log = LoggerFactory.getLogger(UserDocumentKeywordsDAO.class);

    private UserDocumentKeywordsDAO() {
    }

    public static void remove(int id) throws DatabaseException {
        log.debug("remove({})", (Object)id);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            UserDocumentKeywords udk = (UserDocumentKeywords)session.load(UserDocumentKeywords.class, (Serializable)Integer.valueOf(id));
            session.delete((Object)udk);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("remove: void");
    }

    public static void create(UserDocumentKeywords udk) throws DatabaseException {
        log.debug("update({})", (Object)udk);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.save((Object)udk);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("update: void");
    }

    public static List<UserDocumentKeywords> findByUser(String user) throws DatabaseException {
        log.debug("findByUser({})", (Object)user);
        String qs = "from UserDocumentKeywords udk where udk.user=:user";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("user", user);
            List ret = q.list();
            log.debug("findByUser: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<String> findUsers() throws DatabaseException {
        log.debug("findUsers()");
        String qs = "select distinct udk.user from UserDocumentKeywords udk";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            List ret = q.list();
            log.debug("findUsers: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<UserDocumentKeywords> findAll() throws DatabaseException {
        log.debug("findAll()");
        String qs = "from UserDocumentKeywords";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            List ret = q.list();
            log.debug("findByPk: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void clean() throws DatabaseException {
        log.debug("clean()");
        String qs = "from UserDocumentKeywords";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            List ret = session.createQuery(qs).list();
            for (UserDocumentKeywords udk : ret) {
                session.delete((Object)udk);
            }
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("clean: void");
    }
}

