/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.dao;

import com.openkm.core.DatabaseException;
import com.openkm.dao.HibernateUtil;
import com.openkm.dao.bean.cache.UserItems;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserItemsDAO {
    private static Logger log = LoggerFactory.getLogger(UserItemsDAO.class);

    private UserItemsDAO() {
    }

    public static void remove(String user) throws DatabaseException {
        log.debug("remove({})", (Object)user);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            UserItems ui = (UserItems)session.load(UserItems.class, (Serializable)((Object)user));
            session.delete((Object)ui);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("remove: void");
    }

    public static void update(UserItems ui) throws DatabaseException {
        log.debug("update({})", (Object)ui);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)ui);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("update: void");
    }

    public static UserItems findByPk(String user) throws DatabaseException {
        log.debug("findByPk({})", (Object)user);
        String qs = "from UserItems ui where ui.user=:user";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("user", user);
            UserItems ui = (UserItems)q.setMaxResults(1).uniqueResult();
            log.debug("findByPk: {}", (Object)ui);
            UserItems userItems = ui;
            return userItems;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<UserItems> findAll() throws DatabaseException {
        log.debug("findAll()");
        String qs = "from UserItems";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            List ret = q.list();
            log.debug("findByPk: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }
}

