/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.extension.core;

import com.openkm.core.Config;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.xeoh.plugins.base.Plugin;
import net.xeoh.plugins.base.PluginManager;
import net.xeoh.plugins.base.impl.PluginManagerFactory;
import net.xeoh.plugins.base.options.AddPluginsFromOption;
import net.xeoh.plugins.base.options.addpluginsfrom.OptionReportAfter;
import net.xeoh.plugins.base.util.PluginManagerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionManager {
    private static Logger log = LoggerFactory.getLogger(ExtensionManager.class);
    protected static URI base = new File(Config.HOME_DIR + File.separator + "plugins").toURI();
    private static ExtensionManager em = null;
    private static PluginManager pm = null;

    private ExtensionManager() {
        log.info("Initialize and load plugins...");
        pm = PluginManagerFactory.createPluginManager();
        if (Config.EXPERIMENTAL_PLUGIN_DEBUG) {
            pm.addPluginsFrom(base, new AddPluginsFromOption[]{new OptionReportAfter()});
        } else {
            pm.addPluginsFrom(base, new AddPluginsFromOption[0]);
        }
    }

    public static synchronized ExtensionManager getInstance() {
        if (em == null) {
            em = new ExtensionManager();
        }
        return em;
    }

    public <P extends Plugin> List<P> getPlugins(Class<P> plugin) {
        PluginManagerUtil pmu = new PluginManagerUtil(pm);
        return new ArrayList(pmu.getPlugins(plugin));
    }

    public synchronized void reset() {
        log.info("Resetting extensions...");
        pm.shutdown();
        pm = PluginManagerFactory.createPluginManager();
        if (Config.EXPERIMENTAL_PLUGIN_DEBUG) {
            pm.addPluginsFrom(base, new AddPluginsFromOption[]{new OptionReportAfter()});
        } else {
            pm.addPluginsFrom(base, new AddPluginsFromOption[0]);
        }
    }

    public synchronized void shutdown() {
        pm.shutdown();
    }
}

