/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.extension.core;

import com.openkm.bean.Folder;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.ItemExistsException;
import com.openkm.core.LockException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.Ref;
import com.openkm.core.RepositoryException;
import com.openkm.core.UserQuotaExceededException;
import com.openkm.extension.core.ExtensionException;
import com.openkm.extension.core.ExtensionManager;
import com.openkm.extension.core.FolderExtension;
import com.openkm.extension.core.OrderComparator;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.ServiceConfigurationError;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.jackrabbit.api.XASession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderExtensionManager {
    private static Logger log = LoggerFactory.getLogger(FolderExtensionManager.class);
    private static FolderExtensionManager service = null;

    private FolderExtensionManager() {
    }

    public static synchronized FolderExtensionManager getInstance() {
        if (service == null) {
            service = new FolderExtensionManager();
        }
        return service;
    }

    public void preCreate(Session session, Ref<Node> parentNode, Ref<Folder> fld) throws AccessDeniedException, RepositoryException, PathNotFoundException, ItemExistsException, DatabaseException, ExtensionException {
        log.debug("preCreate({}, {}, {})", new Object[]{session, parentNode, fld});
        try {
            ExtensionManager em = ExtensionManager.getInstance();
            List<FolderExtension> col = em.getPlugins(FolderExtension.class);
            Collections.sort(col, new OrderComparator());
            for (FolderExtension ext : col) {
                log.debug("Extension class: {}", (Object)ext.getClass().getCanonicalName());
                ext.preCreate(session, parentNode, fld);
            }
        }
        catch (ServiceConfigurationError e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void postCreate(Session session, Ref<Node> parentNode, Ref<Node> fldNode) throws AccessDeniedException, RepositoryException, PathNotFoundException, ItemExistsException, DatabaseException, ExtensionException {
        log.debug("postCreate({}, {}, {})", new Object[]{session, parentNode, fldNode});
        try {
            ExtensionManager em = ExtensionManager.getInstance();
            List<FolderExtension> col = em.getPlugins(FolderExtension.class);
            Collections.sort(col, new OrderComparator());
            for (FolderExtension ext : col) {
                log.debug("Extension class: {}", (Object)ext.getClass().getCanonicalName());
                ext.postCreate(session, parentNode, fldNode);
            }
        }
        catch (ServiceConfigurationError e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void preDelete(Session session, String fldPath, Ref<Node> refFolderNode) throws AccessDeniedException, RepositoryException, PathNotFoundException, LockException, DatabaseException {
        log.debug("preDelete({}, {}, {})", new Object[]{session, fldPath, refFolderNode});
        try {
            ExtensionManager em = ExtensionManager.getInstance();
            List<FolderExtension> col = em.getPlugins(FolderExtension.class);
            Collections.sort(col, new OrderComparator());
            for (FolderExtension ext : col) {
                log.debug("Extension class: {}", (Object)ext.getClass().getCanonicalName());
                ext.preDelete(session, fldPath, refFolderNode);
            }
        }
        catch (ServiceConfigurationError e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void postDelete(Session session, String fldPath, Ref<Node> refFolderNode) throws AccessDeniedException, RepositoryException, PathNotFoundException, LockException, DatabaseException {
        log.debug("postDelete({}, {}, {})", new Object[]{session, fldPath, refFolderNode});
        try {
            ExtensionManager em = ExtensionManager.getInstance();
            List<FolderExtension> col = em.getPlugins(FolderExtension.class);
            Collections.sort(col, new OrderComparator());
            for (FolderExtension ext : col) {
                log.debug("Extension class: {}", (Object)ext.getClass().getCanonicalName());
                ext.postDelete(session, fldPath, refFolderNode);
            }
        }
        catch (ServiceConfigurationError e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void prePurge(Session session, String fldPath, Ref<Node> refFolderNode) throws AccessDeniedException, RepositoryException, PathNotFoundException, DatabaseException {
        log.debug("prePurge({}, {}, {})", new Object[]{session, fldPath, refFolderNode});
        try {
            ExtensionManager em = ExtensionManager.getInstance();
            List<FolderExtension> col = em.getPlugins(FolderExtension.class);
            Collections.sort(col, new OrderComparator());
            for (FolderExtension ext : col) {
                log.debug("Extension class: {}", (Object)ext.getClass().getCanonicalName());
                ext.prePurge(session, fldPath, refFolderNode);
            }
        }
        catch (ServiceConfigurationError e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void postPurge(Session session, String fldPath) throws AccessDeniedException, RepositoryException, PathNotFoundException, DatabaseException {
        log.debug("postPurge({}, {})", new Object[]{session, fldPath});
        try {
            ExtensionManager em = ExtensionManager.getInstance();
            List<FolderExtension> col = em.getPlugins(FolderExtension.class);
            Collections.sort(col, new OrderComparator());
            for (FolderExtension ext : col) {
                log.debug("Extension class: {}", (Object)ext.getClass().getCanonicalName());
                ext.postPurge(session, fldPath);
            }
        }
        catch (ServiceConfigurationError e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void preRename(Session session, String fldPath, String newPath, Ref<Node> refFolderNode) throws AccessDeniedException, RepositoryException, PathNotFoundException, ItemExistsException, DatabaseException {
        log.debug("preRename({}, {}, {}, {})", new Object[]{session, fldPath, newPath, refFolderNode});
        try {
            ExtensionManager em = ExtensionManager.getInstance();
            List<FolderExtension> col = em.getPlugins(FolderExtension.class);
            Collections.sort(col, new OrderComparator());
            for (FolderExtension ext : col) {
                log.debug("Extension class: {}", (Object)ext.getClass().getCanonicalName());
                ext.preRename(session, fldPath, newPath, refFolderNode);
            }
        }
        catch (ServiceConfigurationError e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void postRename(Session session, String fldPath, String newPath, Ref<Node> refFolderNode) throws AccessDeniedException, RepositoryException, PathNotFoundException, ItemExistsException, DatabaseException {
        log.debug("postRename({}, {}, {}, {})", new Object[]{session, fldPath, newPath, refFolderNode});
        try {
            ExtensionManager em = ExtensionManager.getInstance();
            List<FolderExtension> col = em.getPlugins(FolderExtension.class);
            Collections.sort(col, new OrderComparator());
            for (FolderExtension ext : col) {
                log.debug("Extension class: {}", (Object)ext.getClass().getCanonicalName());
                ext.postRename(session, fldPath, newPath, refFolderNode);
            }
        }
        catch (ServiceConfigurationError e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void preMove(Session session, String fldPath, String dstNodePath) throws AccessDeniedException, RepositoryException, PathNotFoundException, ItemExistsException, DatabaseException {
        log.debug("preMove({}, {}, {})", new Object[]{session, fldPath, dstNodePath});
        try {
            ExtensionManager em = ExtensionManager.getInstance();
            List<FolderExtension> col = em.getPlugins(FolderExtension.class);
            Collections.sort(col, new OrderComparator());
            for (FolderExtension ext : col) {
                log.debug("Extension class: {}", (Object)ext.getClass().getCanonicalName());
                ext.preMove(session, fldPath, dstNodePath);
            }
        }
        catch (ServiceConfigurationError e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void postMove(Session session, String fldPath, String dstNodePath, Ref<Node> refDstFldNode) throws AccessDeniedException, RepositoryException, PathNotFoundException, ItemExistsException, DatabaseException {
        log.debug("postMove({}, {}, {}, {})", new Object[]{session, fldPath, dstNodePath, refDstFldNode});
        try {
            ExtensionManager em = ExtensionManager.getInstance();
            List<FolderExtension> col = em.getPlugins(FolderExtension.class);
            Collections.sort(col, new OrderComparator());
            for (FolderExtension ext : col) {
                log.debug("Extension class: {}", (Object)ext.getClass().getCanonicalName());
                ext.postMove(session, fldPath, dstNodePath, refDstFldNode);
            }
        }
        catch (ServiceConfigurationError e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void preCopy(XASession session, Ref<Node> refSrcFolderNode, Ref<Node> refDstFolderNode) throws AccessDeniedException, RepositoryException, PathNotFoundException, ItemExistsException, IOException, DatabaseException, UserQuotaExceededException {
        log.debug("preCopy({}, {}, {})", new Object[]{session, refSrcFolderNode, refDstFolderNode});
        try {
            ExtensionManager em = ExtensionManager.getInstance();
            List<FolderExtension> col = em.getPlugins(FolderExtension.class);
            Collections.sort(col, new OrderComparator());
            for (FolderExtension ext : col) {
                log.debug("Extension class: {}", (Object)ext.getClass().getCanonicalName());
                ext.preCopy(session, refSrcFolderNode, refDstFolderNode);
            }
        }
        catch (ServiceConfigurationError e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void postCopy(XASession session, Ref<Node> refSrcFolderNode, Ref<Node> refNewFolderNode) throws AccessDeniedException, RepositoryException, PathNotFoundException, ItemExistsException, IOException, DatabaseException, UserQuotaExceededException {
        log.debug("postCopy({}, {}, {})", new Object[]{session, refSrcFolderNode, refNewFolderNode});
        try {
            ExtensionManager em = ExtensionManager.getInstance();
            List<FolderExtension> col = em.getPlugins(FolderExtension.class);
            Collections.sort(col, new OrderComparator());
            for (FolderExtension ext : col) {
                log.debug("Extension class: {}", (Object)ext.getClass().getCanonicalName());
                ext.postCopy(session, refSrcFolderNode, refNewFolderNode);
            }
        }
        catch (ServiceConfigurationError e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

