/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.extension.core;

import com.openkm.bean.form.FormElement;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.LockException;
import com.openkm.core.NoSuchGroupException;
import com.openkm.core.NoSuchPropertyException;
import com.openkm.core.ParseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.Ref;
import com.openkm.core.RepositoryException;
import com.openkm.extension.core.ExtensionException;
import com.openkm.extension.core.ExtensionManager;
import com.openkm.extension.core.OrderComparator;
import com.openkm.extension.core.PropertyGroupExtension;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.ServiceConfigurationError;
import javax.jcr.Node;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyGroupExtensionManager {
    private static Logger log = LoggerFactory.getLogger(PropertyGroupExtensionManager.class);
    private static PropertyGroupExtensionManager service = null;

    private PropertyGroupExtensionManager() {
    }

    public static synchronized PropertyGroupExtensionManager getInstance() {
        if (service == null) {
            service = new PropertyGroupExtensionManager();
        }
        return service;
    }

    public void preAddGroup(Session session, Ref<Node> node, String grpName) throws NoSuchGroupException, LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException, ExtensionException {
        log.debug("preAddGroup({}, {}, {})", new Object[]{session, node, grpName});
        try {
            ExtensionManager em = ExtensionManager.getInstance();
            List<PropertyGroupExtension> col = em.getPlugins(PropertyGroupExtension.class);
            Collections.sort(col, new OrderComparator());
            for (PropertyGroupExtension ext : col) {
                log.debug("Extension class: {}", (Object)ext.getClass().getCanonicalName());
                ext.preAddGroup(session, node, grpName);
            }
        }
        catch (ServiceConfigurationError e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void postAddGroup(Session session, Ref<Node> node, String grpName) throws NoSuchGroupException, LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException, ExtensionException {
        log.debug("postAddGroup({}, {}, {})", new Object[]{session, node, grpName});
        try {
            ExtensionManager em = ExtensionManager.getInstance();
            List<PropertyGroupExtension> col = em.getPlugins(PropertyGroupExtension.class);
            Collections.sort(col, new OrderComparator());
            for (PropertyGroupExtension ext : col) {
                log.debug("Extension class: {}", (Object)ext.getClass().getCanonicalName());
                ext.postAddGroup(session, node, grpName);
            }
        }
        catch (ServiceConfigurationError e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void preRemoveGroup(Session session, Ref<Node> node, String grpName) throws NoSuchGroupException, LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException, ExtensionException {
        log.debug("preRemoveGroup({}, {}, {})", new Object[]{session, node, grpName});
        try {
            ExtensionManager em = ExtensionManager.getInstance();
            List<PropertyGroupExtension> col = em.getPlugins(PropertyGroupExtension.class);
            Collections.sort(col, new OrderComparator());
            for (PropertyGroupExtension ext : col) {
                log.debug("Extension class: {}", (Object)ext.getClass().getCanonicalName());
                ext.preRemoveGroup(session, node, grpName);
            }
        }
        catch (ServiceConfigurationError e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void postRemoveGroup(Session session, Ref<Node> node, String grpName) throws NoSuchGroupException, LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException, ExtensionException {
        log.debug("postRemoveGroup({}, {}, {})", new Object[]{session, node, grpName});
        try {
            ExtensionManager em = ExtensionManager.getInstance();
            List<PropertyGroupExtension> col = em.getPlugins(PropertyGroupExtension.class);
            Collections.sort(col, new OrderComparator());
            for (PropertyGroupExtension ext : col) {
                log.debug("Extension class: {}", (Object)ext.getClass().getCanonicalName());
                ext.postRemoveGroup(session, node, grpName);
            }
        }
        catch (ServiceConfigurationError e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void preSetProperties(Session session, Ref<Node> node, String grpName, List<FormElement> properties) throws IOException, ParseException, NoSuchPropertyException, NoSuchGroupException, LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException, ExtensionException {
        log.debug("preSetProperties({}, {}, {}, {})", new Object[]{session, node, grpName, properties});
        try {
            ExtensionManager em = ExtensionManager.getInstance();
            List<PropertyGroupExtension> col = em.getPlugins(PropertyGroupExtension.class);
            Collections.sort(col, new OrderComparator());
            for (PropertyGroupExtension ext : col) {
                log.debug("Extension class: {}", (Object)ext.getClass().getCanonicalName());
                ext.preSetProperties(session, node, grpName, properties);
            }
        }
        catch (ServiceConfigurationError e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void postSetProperties(Session session, Ref<Node> node, String grpName, List<FormElement> properties) throws IOException, ParseException, NoSuchPropertyException, NoSuchGroupException, LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException, ExtensionException {
        log.debug("postSetProperties({}, {}, {}, {})", new Object[]{session, node, grpName, properties});
        try {
            ExtensionManager em = ExtensionManager.getInstance();
            List<PropertyGroupExtension> col = em.getPlugins(PropertyGroupExtension.class);
            Collections.sort(col, new OrderComparator());
            for (PropertyGroupExtension ext : col) {
                log.debug("Extension class: {}", (Object)ext.getClass().getCanonicalName());
                ext.postSetProperties(session, node, grpName, properties);
            }
        }
        catch (ServiceConfigurationError e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

