/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.extension.dao;

import com.openkm.core.DatabaseException;
import com.openkm.dao.HibernateUtil;
import com.openkm.extension.dao.MessageDAO;
import com.openkm.extension.dao.bean.Contact;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactDAO {
    private static Logger log = LoggerFactory.getLogger(MessageDAO.class);

    private ContactDAO() {
    }

    public static int create(Contact contact) throws DatabaseException {
        log.debug("create()");
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Integer id = (Integer)session.save((Object)contact);
            HibernateUtil.commit(tx);
            log.debug("create: {}" + id);
            int n = id;
            return n;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void delete(int id) throws DatabaseException {
        log.debug("delete({})", (Object)id);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Contact contact = (Contact)session.load(Contact.class, (Serializable)Integer.valueOf(id));
            session.delete((Object)contact);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("delete: void");
    }

    public static List<Contact> findByUuid(String uuid) throws DatabaseException {
        log.debug("findByUuid({})", (Object)uuid);
        String qs = "select con from Contact con where :uuid in elements(con.uuids) order by con.name";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("uuid", uuid);
            List ret = q.list();
            log.debug("findByUuid: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<Contact> findAll() throws DatabaseException {
        log.debug("findAll({})");
        String qs = "from Contact con order by con.name";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            List ret = q.list();
            log.debug("findAll: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<Contact> findAllFiltered(String uuid) throws DatabaseException {
        log.debug("findAll({})");
        String qs = "from Contact con where :uuid not in elements(con.uuids) order by con.name";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("uuid", uuid);
            List ret = q.list();
            log.debug("findAll: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void update(Contact contact) throws DatabaseException {
        log.debug("update({})", (Object)contact);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.update((Object)contact);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("update: void");
    }

    public static Contact findByPk(int id) throws DatabaseException {
        log.debug("findByPk({})", (Object)id);
        String qs = "from Contact con where con.id=:id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setInteger("id", id);
            Contact ret = (Contact)q.setMaxResults(1).uniqueResult();
            log.debug("findByPk: {}", (Object)ret);
            Contact contact = ret;
            return contact;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static Contact findByOrigin(String externalId, String origin) throws DatabaseException {
        log.debug("findByOrigin({},{})", (Object)externalId, (Object)origin);
        String qs = "from Contact con where con.externalId=:externalId and con.origin=:origin";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("externalId", externalId);
            q.setString("origin", origin);
            Contact ret = (Contact)q.setMaxResults(1).uniqueResult();
            log.debug("findByOrigin: {}", (Object)ret);
            Contact contact = ret;
            return contact;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }
}

