/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.extension.dao;

import com.openkm.core.DatabaseException;
import com.openkm.dao.HibernateUtil;
import com.openkm.extension.dao.bean.Forum;
import com.openkm.extension.dao.bean.ForumPost;
import com.openkm.extension.dao.bean.ForumTopic;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForumDAO {
    private static Logger log = LoggerFactory.getLogger(ForumDAO.class);

    private ForumDAO() {
    }

    public static int create(Forum frm) throws DatabaseException {
        log.debug("create({})", (Object)frm);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Integer id = (Integer)session.save((Object)frm);
            HibernateUtil.commit(tx);
            log.debug("create: {}" + id);
            int n = id;
            return n;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void update(Forum frm) throws DatabaseException {
        log.debug("update({})", (Object)frm);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.update((Object)frm);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("update: void");
    }

    public static void update(ForumTopic topic) throws DatabaseException {
        log.debug("update({})", (Object)topic);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.update((Object)topic);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("update: void");
    }

    public static void update(ForumPost post) throws DatabaseException {
        log.debug("update({})", (Object)post);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.update((Object)post);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("update: void");
    }

    public static void delete(int frmId) throws DatabaseException {
        log.debug("delete({})", (Object)frmId);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Forum frm = (Forum)session.load(Forum.class, (Serializable)Integer.valueOf(frmId));
            session.delete((Object)frm);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("deleteSent: void");
    }

    public static Forum findByPk(int id) throws DatabaseException {
        log.debug("findByPk({})");
        String qs = "from Forum frm where frm.id=:id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setInteger("id", id);
            Forum ret = (Forum)q.setMaxResults(1).uniqueResult();
            log.debug("findByPk: {}", (Object)ret);
            Forum forum = ret;
            return forum;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static ForumTopic findTopicByPk(int id) throws DatabaseException {
        log.debug("findTopicByPk({})");
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            ForumTopic ret = (ForumTopic)session.get(ForumTopic.class, (Serializable)Integer.valueOf(id));
            log.debug("findTopicByPk: {}", (Object)ret);
            ForumTopic forumTopic = ret;
            return forumTopic;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static ForumPost findPostByPk(int id) throws DatabaseException {
        log.debug("findPostByPk({})");
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            ForumPost ret = (ForumPost)session.get(ForumPost.class, (Serializable)Integer.valueOf(id));
            log.debug("findPostByPk: {}", (Object)ret);
            ForumPost forumPost = ret;
            return forumPost;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<Forum> findAll() throws DatabaseException {
        log.debug("findAll({})");
        String qs = "from Forum frm order by frm.date asc";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            List ret = q.list();
            log.debug("findAll: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<ForumTopic> findAllTopicByUuid(String uuid) throws DatabaseException {
        log.debug("findAllTopicByUuid({})");
        String qs = "from ForumTopic ft where ft.uuid=:uuid order by ft.lastPostDate desc";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("uuid", uuid);
            List ret = q.list();
            log.debug("findAllTopicByUuid: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }
}

