/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.extension.dao;

import com.openkm.core.DatabaseException;
import com.openkm.dao.HibernateUtil;
import com.openkm.extension.dao.bean.MessageReceived;
import com.openkm.extension.dao.bean.MessageSent;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDAO {
    private static Logger log = LoggerFactory.getLogger(MessageDAO.class);

    private MessageDAO() {
    }

    public static void send(String from, String to, String user, String subject, String content) throws DatabaseException {
        log.debug("send({}, {}, {}, {}, {})", new Object[]{from, to, user, subject, content});
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            MessageSent msgSent = new MessageSent();
            msgSent.setFrom(from);
            msgSent.setTo(to);
            msgSent.setUser(user);
            msgSent.setSubject(subject);
            msgSent.setContent(content);
            msgSent.setSentDate(Calendar.getInstance());
            session.save((Object)msgSent);
            MessageReceived msgReceived = new MessageReceived();
            msgReceived.setFrom(from);
            msgReceived.setTo(to);
            msgReceived.setUser(user);
            msgReceived.setSubject(subject);
            msgReceived.setContent(content);
            msgReceived.setSentDate(Calendar.getInstance());
            session.save((Object)msgReceived);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("send: void");
    }

    public static void deleteSent(int msgId) throws DatabaseException {
        log.debug("deleteSent({})", (Object)msgId);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            MessageSent msg = (MessageSent)session.load(MessageSent.class, (Serializable)Integer.valueOf(msgId));
            session.delete((Object)msg);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("deleteSent: void");
    }

    public static void deleteReceived(int msgId) throws DatabaseException {
        log.debug("deleteReceived({})", (Object)msgId);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            MessageReceived msg = (MessageReceived)session.load(MessageReceived.class, (Serializable)Integer.valueOf(msgId));
            session.delete((Object)msg);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("delete: void");
    }

    public static List<String> findSentUsersTo(String me) throws DatabaseException {
        log.debug("findSentUsersTo({})", (Object)me);
        String qs = "select distinct(msg.user) from MessageSent msg where msg.from=:me order by msg.user";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("me", me);
            List ret = q.list();
            log.debug("findSentUsersTo: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<MessageSent> findSentFromMeToUser(String me, String user) throws DatabaseException {
        log.debug("findSentFromMeToUser({}, {})", (Object)me, (Object)user);
        String qs = "from MessageSent msg where msg.from=:me and msg.user=:user order by msg.id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("me", me);
            q.setString("user", user);
            List ret = q.list();
            log.debug("findSentFromMeToUser: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<String> findReceivedUsersFrom(String me) throws DatabaseException {
        log.debug("findReceivedUsersFrom({})", (Object)me);
        String qs = "select distinct(msg.from) from MessageReceived msg where msg.user=:me order by msg.from";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("me", me);
            List ret = q.list();
            log.debug("findReceivedUsersFrom: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static Map<String, Long> findReceivedUsersFromUnread(String me) throws DatabaseException {
        log.debug("findReceivedUsersFromUnread({})", (Object)me);
        String qs = "select msg.from, count(msg.from) from MessageReceived msg group by msg.from,msg.user,msg.seenDate having msg.seenDate is null and msg.user=:me";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("me", me);
            List list = q.list();
            HashMap<String, Long> ret = new HashMap<String, Long>();
            for (Object[] item : list) {
                ret.put((String)item[0], (Long)item[1]);
            }
            log.debug("findReceivedUsersFromUnread: {}", ret);
            HashMap<String, Long> hashMap = ret;
            return hashMap;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<MessageReceived> findReceivedByMeFromUser(String me, String user) throws DatabaseException {
        log.debug("findReceivedByMeFromUser({})", (Object)user);
        String qs = "from MessageReceived msg where msg.from=:user and msg.user=:me order by msg.id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("me", me);
            q.setString("user", user);
            List ret = q.list();
            log.debug("findReceivedByMeFromUser: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void markSeen(int msgId) throws DatabaseException {
        log.debug("markSeen({})", (Object)msgId);
        String qs = "update MessageReceived msg set msg.seenDate=:seenDate where msg.id=:id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setInteger("id", msgId);
            q.setCalendar("seenDate", Calendar.getInstance());
            q.executeUpdate();
            log.debug("markSeen: void");
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }
}

