/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.extension.dao;

import com.openkm.core.DatabaseException;
import com.openkm.dao.HibernateUtil;
import com.openkm.dao.bean.QueryParams;
import com.openkm.extension.dao.bean.ProposedQueryReceived;
import com.openkm.extension.dao.bean.ProposedQuerySent;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProposedQueryDAO {
    private static Logger log = LoggerFactory.getLogger(ProposedQueryDAO.class);

    private ProposedQueryDAO() {
    }

    public static void send(int qpId, String from, String to, String user, String comment) throws DatabaseException {
        log.debug("send({}, {}, {}, {}, {}, {}, {})", new Object[]{qpId, from, to, user, comment});
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            QueryParams qp = (QueryParams)session.get(QueryParams.class, (Serializable)Integer.valueOf(qpId));
            ProposedQuerySent pqSent = new ProposedQuerySent();
            pqSent.setFrom(from);
            pqSent.setTo(to);
            pqSent.setUser(user);
            pqSent.setComment(comment);
            pqSent.setSentDate(Calendar.getInstance());
            qp.getProposedSent().add(pqSent);
            ProposedQueryReceived pqReceived = new ProposedQueryReceived();
            pqReceived.setFrom(from);
            pqReceived.setTo(to);
            pqReceived.setUser(user);
            pqReceived.setComment(comment);
            pqReceived.setSentDate(Calendar.getInstance());
            qp.getProposedReceived().add(pqReceived);
            session.save((Object)qp);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("send: void");
    }

    public static void deleteSent(int pqId) throws DatabaseException {
        log.debug("deleteSent({})", (Object)pqId);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            ProposedQuerySent pq = (ProposedQuerySent)session.load(ProposedQuerySent.class, (Serializable)Integer.valueOf(pqId));
            session.delete((Object)pq);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("deleteSent: void");
    }

    public static void deleteReceived(int pqId) throws DatabaseException {
        log.debug("deleteReceived({})", (Object)pqId);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            ProposedQueryReceived pq = (ProposedQueryReceived)session.load(ProposedQueryReceived.class, (Serializable)Integer.valueOf(pqId));
            session.delete((Object)pq);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("deleteReceived: void");
    }

    public static List<String> findProposedQueriesUsersFrom(String me) throws DatabaseException {
        log.debug("findProposedQueriesUsersFrom({})", (Object)me);
        String qs = "select distinct(pq.from) from ProposedQueryReceived pq where pq.user=:me order by pq.from";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("me", me);
            List ret = q.list();
            log.debug("findProposedQueriesUsersFrom: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static Map<String, Long> findProposedQueriesUsersFromUnread(String me) throws DatabaseException {
        log.debug("findProposedQueriesUsersFromUnread({})", (Object)me);
        String qs = "select pq.from, count(pq.from) from ProposedQueryReceived pq group by pq.from, pq.user, pq.seenDate having pq.seenDate is null and pq.user=:me";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("me", me);
            List list = q.list();
            HashMap<String, Long> ret = new HashMap<String, Long>();
            for (Object[] item : list) {
                ret.put((String)item[0], (Long)item[1]);
            }
            log.debug("findProposedQueriesUsersFromUnread: {}", ret);
            HashMap<String, Long> hashMap = ret;
            return hashMap;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<ProposedQueryReceived> findProposedQueryByMeFromUser(String me, String user) throws DatabaseException {
        log.debug("findProposedQueryByMeFromUser({})", (Object)user);
        String qs = "from ProposedQueryReceived pq where pq.from=:user and pq.user=:me order by pq.id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("me", me);
            q.setString("user", user);
            List ret = q.list();
            log.debug("findProposedQueryByMeFromUser: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<String> findProposedQuerySentUsersTo(String me) throws DatabaseException {
        log.debug("findSentUsersTo({})", (Object)me);
        String qs = "select distinct(pq.user) from ProposedQuerySent pq where pq.from=:me order by pq.user";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("me", me);
            List ret = q.list();
            log.debug("findProposedQuerySentUsersTo: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void markSeen(int pqId) throws DatabaseException {
        log.debug("markSeen({})", (Object)pqId);
        String qs = "update ProposedQueryReceived pq set pq.seenDate=:seenDate where pq.id=:id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setInteger("id", pqId);
            q.setCalendar("seenDate", Calendar.getInstance());
            q.executeUpdate();
            log.debug("markSeen: void");
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void markAccepted(int pqId) throws DatabaseException {
        log.debug("markAccepted({})", (Object)pqId);
        String qs = "update ProposedQueryReceived ps set ps.accepted=:accepted where ps.id=:id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setInteger("id", pqId);
            q.setBoolean("accepted", true);
            q.executeUpdate();
            log.debug("markAccepted: void");
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }
}

