/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.extension.dao;

import com.openkm.core.DatabaseException;
import com.openkm.core.RepositoryException;
import com.openkm.dao.HibernateUtil;
import com.openkm.extension.dao.bean.ProposedSubscriptionReceived;
import com.openkm.extension.dao.bean.ProposedSubscriptionSent;
import com.openkm.jcr.JCRUtils;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Session;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProposedSubscriptionDAO {
    private static Logger log = LoggerFactory.getLogger(ProposedSubscriptionDAO.class);

    private ProposedSubscriptionDAO() {
    }

    public static void send(String from, String to, String user, String uuid, String comment) throws DatabaseException {
        log.debug("send({}, {}, {}, {}, {})", new Object[]{from, to, user, uuid, comment});
        org.hibernate.classic.Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            ProposedSubscriptionSent psSent = new ProposedSubscriptionSent();
            psSent.setFrom(from);
            psSent.setTo(to);
            psSent.setUser(user);
            psSent.setUuid(uuid);
            psSent.setComment(comment);
            psSent.setSentDate(Calendar.getInstance());
            session.save((Object)psSent);
            ProposedSubscriptionReceived psReceived = new ProposedSubscriptionReceived();
            psReceived.setFrom(from);
            psReceived.setTo(to);
            psReceived.setUser(user);
            psReceived.setUuid(uuid);
            psReceived.setComment(comment);
            psReceived.setSentDate(Calendar.getInstance());
            session.save((Object)psReceived);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("send: void");
    }

    public static void deleteSent(int psId) throws DatabaseException {
        log.debug("deleteSent({})", (Object)psId);
        org.hibernate.classic.Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            ProposedSubscriptionSent ps = (ProposedSubscriptionSent)session.load(ProposedSubscriptionSent.class, (Serializable)Integer.valueOf(psId));
            session.delete((Object)ps);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("deleteSent: void");
    }

    public static void deleteReceived(int psId) throws DatabaseException {
        log.debug("deleteReceived({})", (Object)psId);
        org.hibernate.classic.Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            ProposedSubscriptionReceived ps = (ProposedSubscriptionReceived)session.load(ProposedSubscriptionReceived.class, (Serializable)Integer.valueOf(psId));
            session.delete((Object)ps);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("delete: void");
    }

    public static List<ProposedSubscriptionSent> findSentProposedSubscriptionFromMeToUser(Session jcrSession, String me, String user) throws DatabaseException, RepositoryException {
        log.debug("findSentProposedSubscriptionFromMeToUser({}, {})", (Object)me, (Object)user);
        String qs = "from ProposedSubscriptionSent ps where ps.from=:me and ps.user=:user order by ps.id";
        org.hibernate.classic.Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(qs);
            q.setString("me", me);
            q.setString("user", user);
            List ret = q.list();
            for (ProposedSubscriptionSent ps : ret) {
                try {
                    Node node = jcrSession.getNodeByUUID(ps.getUuid());
                    String nType = JCRUtils.getNodeType(node);
                    ps.setPath(node.getPath());
                    if (nType.equals(ps.getType())) continue;
                    ps.setType(JCRUtils.getNodeType(node));
                    session.update((Object)ps);
                }
                catch (ItemNotFoundException e) {
                    Node okmRoot = jcrSession.getRootNode().getNode("okm:root");
                    ps.setPath(okmRoot.getPath());
                    ps.setUuid(okmRoot.getUUID());
                    ps.setType("okm:folder");
                    session.save((Object)ps);
                }
            }
            log.debug("findSentProposedSubscriptionFromMeToUser: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (javax.jcr.RepositoryException e) {
            HibernateUtil.rollback(tx);
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<String> findProposedSubscriptionsUsersFrom(String me) throws DatabaseException {
        log.debug("findProposedSubscriptionsUsersFrom({})", (Object)me);
        String qs = "select distinct(ps.from) from ProposedSubscriptionReceived ps where ps.user=:me order by ps.from";
        org.hibernate.classic.Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("me", me);
            List ret = q.list();
            log.debug("findProposedSubscriptionsUsersFrom: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static Map<String, Long> findProposedSubscriptionsUsersFromUnread(String me) throws DatabaseException {
        log.debug("findProposedSubscriptionsUsersFromUnread({})", (Object)me);
        String qs = "select ps.from, count(ps.from) from ProposedSubscriptionReceived ps group by ps.from, ps.user, ps.seenDate having ps.seenDate is null and ps.user=:me";
        org.hibernate.classic.Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("me", me);
            List list = q.list();
            HashMap<String, Long> ret = new HashMap<String, Long>();
            for (Object[] item : list) {
                ret.put((String)item[0], (Long)item[1]);
            }
            log.debug("findProposedSubscriptionsUsersFromUnread: {}", ret);
            HashMap<String, Long> hashMap = ret;
            return hashMap;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<ProposedSubscriptionReceived> findProposedSubscriptionByMeFromUser(Session jcrSession, String me, String user) throws DatabaseException, RepositoryException {
        log.debug("findProposedSubscriptionByMeFromUser({}, {})", (Object)jcrSession, (Object)user);
        String qs = "from ProposedSubscriptionReceived ps where ps.from=:user and ps.user=:me order by ps.id";
        org.hibernate.classic.Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(qs);
            q.setString("me", me);
            q.setString("user", user);
            List ret = q.list();
            for (ProposedSubscriptionReceived ps : ret) {
                try {
                    Node node = jcrSession.getNodeByUUID(ps.getUuid());
                    String nType = JCRUtils.getNodeType(node);
                    ps.setPath(node.getPath());
                    if (nType.equals(ps.getType())) continue;
                    ps.setType(JCRUtils.getNodeType(node));
                    session.update((Object)ps);
                }
                catch (ItemNotFoundException e) {
                    Node okmRoot = jcrSession.getRootNode().getNode("okm:root");
                    ps.setPath(okmRoot.getPath());
                    ps.setUuid(okmRoot.getUUID());
                    ps.setType("okm:folder");
                    session.save((Object)ps);
                }
            }
            HibernateUtil.commit(tx);
            log.debug("findProposedSubscriptionByMeFromUser: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (javax.jcr.RepositoryException e) {
            HibernateUtil.rollback(tx);
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<String> findProposedSubscriptionSentUsersTo(String me) throws DatabaseException {
        log.debug("findProposedSubscriptionSentUsersTo({})", (Object)me);
        String qs = "select distinct(ps.user) from ProposedSubscriptionSent ps where ps.from=:me order by ps.user";
        org.hibernate.classic.Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("me", me);
            List ret = q.list();
            log.debug("findProposedSubscriptionSentUsersTo: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void markSeen(int psId) throws DatabaseException {
        log.debug("markSeen({})", (Object)psId);
        String qs = "update ProposedSubscriptionReceived ps set ps.seenDate=:seenDate where ps.id=:id";
        org.hibernate.classic.Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setInteger("id", psId);
            q.setCalendar("seenDate", Calendar.getInstance());
            q.executeUpdate();
            log.debug("markSeen: void");
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void markAccepted(int psId) throws DatabaseException {
        log.debug("markAccepted({})", (Object)psId);
        String qs = "update ProposedSubscriptionReceived ps set ps.accepted=:accepted where ps.id=:id";
        org.hibernate.classic.Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setInteger("id", psId);
            q.setBoolean("accepted", true);
            q.executeUpdate();
            log.debug("markAccepted: void");
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }
}

