/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.extension.dao;

import com.openkm.core.DatabaseException;
import com.openkm.dao.HibernateUtil;
import com.openkm.extension.dao.bean.StampImage;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StampImageDAO {
    private static Logger log = LoggerFactory.getLogger(StampImageDAO.class);

    private StampImageDAO() {
    }

    public static int create(StampImage si) throws DatabaseException {
        log.debug("create({})", (Object)si);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Integer id = (Integer)session.save((Object)si);
            HibernateUtil.commit(tx);
            log.debug("create: {}", (Object)id);
            int n = id;
            return n;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void update(StampImage si) throws DatabaseException {
        log.debug("update({})", (Object)si);
        String qs = "select si.imageContent, si.imageMime from StampImage si where si.id=:id";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            if (si.getImageContent() == null || si.getImageContent().length() == 0) {
                Query q = session.createQuery(qs);
                q.setParameter("id", (Object)si.getId());
                Object[] data = (Object[])q.setMaxResults(1).uniqueResult();
                si.setImageContent((String)data[0]);
                si.setImageMime((String)data[1]);
            }
            session.update((Object)si);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("update: void");
    }

    public static void active(int siId, boolean active) throws DatabaseException {
        log.debug("active({}, {})", (Object)siId, (Object)active);
        String qs = "update StampImage si set si.active=:active where si.id=:id";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(qs);
            q.setBoolean("active", active);
            q.setInteger("id", siId);
            q.executeUpdate();
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("active: void");
    }

    public static void delete(int siId) throws DatabaseException {
        log.debug("delete({})", (Object)siId);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            StampImage si = (StampImage)session.load(StampImage.class, (Serializable)Integer.valueOf(siId));
            session.delete((Object)si);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("delete: void");
    }

    public static StampImage findByPk(int siId) throws DatabaseException {
        log.debug("findByPk({})", (Object)siId);
        String qs = "from StampImage si where si.id=:id";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(qs);
            q.setInteger("id", siId);
            StampImage ret = (StampImage)q.setMaxResults(1).uniqueResult();
            HibernateUtil.commit(tx);
            log.debug("findByPk: {}", (Object)ret);
            StampImage stampImage = ret;
            return stampImage;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<StampImage> findAll() throws DatabaseException {
        log.debug("findAll()");
        String qs = "from StampImage si order by si.id";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(qs);
            List ret = q.list();
            HibernateUtil.commit(tx);
            log.debug("findAll: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<StampImage> findByUser(String usrId) throws DatabaseException {
        log.debug("findByUser({})", (Object)usrId);
        String qs = "from StampImage si where :user in elements(si.users)and si.active=:active order by si.id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("user", usrId);
            q.setBoolean("active", true);
            List ret = q.list();
            log.debug("findByUser: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }
}

