/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.extension.dao;

import com.openkm.core.DatabaseException;
import com.openkm.core.RepositoryException;
import com.openkm.dao.HibernateUtil;
import com.openkm.extension.dao.bean.Staple;
import com.openkm.extension.dao.bean.StapleGroup;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StapleGroupDAO {
    private static Logger log = LoggerFactory.getLogger(StapleGroupDAO.class);

    private StapleGroupDAO() {
    }

    public static int create(StapleGroup sg) throws DatabaseException {
        log.debug("create({})", (Object)sg);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Integer id = (Integer)session.save((Object)sg);
            HibernateUtil.commit(tx);
            log.debug("create: {}" + id);
            int n = id;
            return n;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void delete(int sgId) throws DatabaseException {
        log.debug("delete({})", (Object)sgId);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            StapleGroup sg = (StapleGroup)session.load(StapleGroup.class, (Serializable)Integer.valueOf(sgId));
            session.delete((Object)sg);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("delete: void");
    }

    public static void deleteStaple(int stId) throws DatabaseException {
        log.debug("delete({})", (Object)stId);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Staple st = (Staple)session.load(Staple.class, (Serializable)Integer.valueOf(stId));
            session.delete((Object)st);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("delete: void");
    }

    public static List<StapleGroup> findAll(String uuid) throws DatabaseException, RepositoryException {
        log.debug("findAll({}, {})", (Object)uuid);
        String qs = "select sg from StapleGroup sg, Staple st where st.uuid=:uuid and st in elements(sg.staples)";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("uuid", uuid);
            List ret = q.list();
            log.debug("findAll: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static StapleGroup findByPk(int sgId) throws DatabaseException {
        log.debug("findByPk({})", (Object)sgId);
        String qs = "from StapleGroup sg where sg.id=:id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setInteger("id", sgId);
            StapleGroup ret = (StapleGroup)q.setMaxResults(1).uniqueResult();
            log.debug("findByPk: {}", (Object)ret);
            StapleGroup stapleGroup = ret;
            return stapleGroup;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void update(StapleGroup sg) throws DatabaseException {
        log.debug("update({})", (Object)sg);
        String qs = "select sg.user from StapleGroup sg where sg.id=:id";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(qs);
            q.setParameter("id", (Object)sg.getId());
            String user = (String)q.setMaxResults(1).uniqueResult();
            sg.setUser(user);
            session.update((Object)sg);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("update: void");
    }
}

