/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.extension.servlet;

import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.extension.dao.ForumDAO;
import com.openkm.extension.dao.bean.Forum;
import com.openkm.extension.dao.bean.ForumPost;
import com.openkm.extension.dao.bean.ForumTopic;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.bean.extension.GWTForum;
import com.openkm.frontend.client.bean.extension.GWTForumPost;
import com.openkm.frontend.client.bean.extension.GWTForumTopic;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.frontend.client.service.extension.OKMForumService;
import com.openkm.servlet.frontend.OKMRemoteServiceServlet;
import com.openkm.util.GWTUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForumServlet
extends OKMRemoteServiceServlet
implements OKMForumService {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(ForumServlet.class);

    @Override
    public List<GWTForumTopic> getTopicsByForum(int id) throws OKMException {
        log.debug("getTopicsByForum({})", (Object)id);
        this.updateSessionManager();
        ArrayList<GWTForumTopic> topicList = new ArrayList<GWTForumTopic>();
        try {
            for (ForumTopic topic : ForumDAO.findByPk(id).getTopics()) {
                topicList.add(GWTUtil.copy(topic));
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("031", "024"), e.getMessage());
        }
        log.debug("getTopicsByUuid: {}", topicList);
        return topicList;
    }

    @Override
    public List<GWTForumTopic> getTopicsByUuid(String uuid) throws OKMException {
        log.debug("getTopicsByUuid({})", (Object)uuid);
        this.updateSessionManager();
        ArrayList<GWTForumTopic> topicList = new ArrayList<GWTForumTopic>();
        try {
            for (ForumTopic topic : ForumDAO.findAllTopicByUuid(uuid)) {
                topicList.add(GWTUtil.copy(topic));
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("031", "024"), e.getMessage());
        }
        log.debug("getTopicsByUuid: {}", topicList);
        return topicList;
    }

    @Override
    public GWTForumTopic createTopic(int id, String uuid, GWTForumTopic topic) throws OKMException {
        log.debug("createTopic({}, {}, {})", new Object[]{id, uuid, topic});
        this.updateSessionManager();
        try {
            Forum forum = ForumDAO.findByPk(id);
            topic.setDate(new Date());
            topic.setLastPostDate(topic.getDate());
            topic.setUuid(uuid);
            topic.setUser(this.getThreadLocalRequest().getRemoteUser());
            topic.setLastPostUser(topic.getUser());
            topic.setReplies(0);
            topic.setViews(0);
            GWTForumPost post = topic.getPosts().iterator().next();
            post.setDate(topic.getDate());
            post.setUser(topic.getUser());
            forum.getTopics().add(GWTUtil.copy(topic));
            forum.setNumTopics(forum.getNumTopics() + 1);
            forum.setNumPosts(forum.getNumPosts() + 1);
            ForumDAO.update(forum);
            ForumTopic ft2 = new ForumTopic();
            for (ForumTopic ft2 : forum.getTopics()) {
            }
            log.debug("getTopicsByUuid: {}", (Object)ft2);
            return GWTUtil.copy(ft2);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("031", "024"), e.getMessage());
        }
    }

    @Override
    public GWTForumTopic findTopicByPK(int id) throws OKMException {
        log.debug("findTopicByPK({})", (Object)id);
        this.updateSessionManager();
        try {
            return GWTUtil.copy(ForumDAO.findTopicByPk(id));
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("031", "024"), e.getMessage());
        }
    }

    @Override
    public void createPost(int forumId, int topicId, GWTForumPost post) throws OKMException {
        log.debug("createPost({}, {}, {})", new Object[]{forumId, topicId, post.getSubject()});
        this.updateSessionManager();
        try {
            post.setDate(new Date());
            post.setUser(this.getThreadLocalRequest().getRemoteUser());
            ForumTopic topic = ForumDAO.findTopicByPk(topicId);
            topic.getPosts().add(GWTUtil.copy(post));
            topic.setReplies(topic.getReplies() + 1);
            Calendar cal = Calendar.getInstance();
            cal.setTime(post.getDate());
            topic.setLastPostDate(cal);
            topic.setLastPostUser(post.getUser());
            ForumDAO.update(topic);
            Forum forum = ForumDAO.findByPk(forumId);
            forum.setNumPosts(forum.getNumPosts() + 1);
            forum.setLastPostDate(cal);
            forum.setLastPostUser(post.getUser());
            ForumDAO.update(forum);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("031", "024"), e.getMessage());
        }
    }

    @Override
    public void increaseTopicView(int id) throws OKMException {
        log.debug("increaseTopicView({})", (Object)id);
        this.updateSessionManager();
        try {
            ForumTopic topic = ForumDAO.findTopicByPk(id);
            topic.setViews(topic.getViews() + 1);
            ForumDAO.update(topic);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("031", "024"), e.getMessage());
        }
    }

    @Override
    public Boolean deletePost(int forumId, int topicId, int postId) throws OKMException {
        log.debug("deletePost({}, {})", (Object)topicId, (Object)postId);
        this.updateSessionManager();
        try {
            Forum forum;
            ForumTopic topic = ForumDAO.findTopicByPk(topicId);
            for (ForumPost post : topic.getPosts()) {
                if (post.getId() != postId) continue;
                topic.setReplies(topic.getReplies() - 1);
                topic.getPosts().remove(post);
                break;
            }
            if (topic.getPosts().size() > 0) {
                ForumDAO.update(topic);
                forum = ForumDAO.findByPk(forumId);
                forum.setNumPosts(forum.getNumPosts() - 1);
                ForumDAO.update(forum);
                return new Boolean(true);
            }
            forum = ForumDAO.findByPk(forumId);
            forum.setNumPosts(forum.getNumPosts() - 1);
            forum.setNumTopics(forum.getNumTopics() - 1);
            for (ForumTopic fp : forum.getTopics()) {
                if (fp.getId() != topicId) continue;
                forum.getTopics().remove(fp);
                break;
            }
            ForumDAO.update(forum);
            return new Boolean(false);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("031", "024"), e.getMessage());
        }
    }

    @Override
    public void updatePost(GWTForumPost post) throws OKMException {
        log.debug("updatePost({})", (Object)post.getId());
        this.updateSessionManager();
        try {
            ForumPost fp = ForumDAO.findPostByPk(post.getId());
            fp.setSubject(post.getSubject());
            fp.setMessage(post.getMessage());
            ForumDAO.update(fp);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("031", "024"), e.getMessage());
        }
    }

    @Override
    public List<GWTForum> getAllForum() throws OKMException {
        log.debug("getAllForum()");
        ArrayList<GWTForum> forumList = new ArrayList<GWTForum>();
        this.updateSessionManager();
        try {
            for (Forum forum : ForumDAO.findAll()) {
                if (!this.getThreadLocalRequest().isUserInRole(Config.DEFAULT_ADMIN_ROLE)) {
                    if (forum.getId() == 1) continue;
                    forumList.add(GWTUtil.copy(forum));
                    continue;
                }
                forumList.add(GWTUtil.copy(forum));
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("031", "024"), e.getMessage());
        }
        return forumList;
    }

    @Override
    public GWTForum createForum(GWTForum forum) throws OKMException {
        log.debug("createForum()");
        this.updateSessionManager();
        try {
            forum.setDate(new Date());
            forum.setLastPostDate(new Date());
            forum.setLastPostUser(this.getThreadLocalRequest().getRemoteUser());
            forum.setNumPosts(0);
            forum.setNumTopics(0);
            Forum f = GWTUtil.copy(forum);
            ForumDAO.create(f);
            return GWTUtil.copy(f);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("031", "024"), e.getMessage());
        }
    }

    @Override
    public void deleteForum(int id) throws OKMException {
        log.debug("deleteForum()");
        this.updateSessionManager();
        try {
            ForumDAO.delete(id);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("031", "024"), e.getMessage());
        }
    }

    @Override
    public void updateForum(GWTForum forum) throws OKMException {
        log.debug("updateForum()");
        this.updateSessionManager();
        try {
            Forum f = ForumDAO.findByPk(forum.getId());
            f.setName(forum.getName());
            f.setDescription(forum.getDescription());
            ForumDAO.update(f);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("031", "024"), e.getMessage());
        }
    }

    @Override
    public void updateTopic(int id, GWTForumPost post) throws OKMException {
        log.debug("updateTopic({}, {})", (Object)id, (Object)post.getId());
        this.updateSessionManager();
        try {
            ForumPost fp = ForumDAO.findPostByPk(post.getId());
            fp.setSubject(post.getSubject());
            fp.setMessage(post.getMessage());
            ForumDAO.update(fp);
            ForumTopic ft = ForumDAO.findTopicByPk(id);
            ft.setTitle(post.getSubject());
            ForumDAO.update(ft);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("031", "024"), e.getMessage());
        }
    }
}

