/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.extension.servlet;

import com.openkm.api.OKMAuth;
import com.openkm.core.DatabaseException;
import com.openkm.core.ParseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.dao.QueryParamsDAO;
import com.openkm.dao.bean.QueryParams;
import com.openkm.extension.dao.MessageDAO;
import com.openkm.extension.dao.ProposedQueryDAO;
import com.openkm.extension.dao.ProposedSubscriptionDAO;
import com.openkm.extension.dao.bean.MessageReceived;
import com.openkm.extension.dao.bean.MessageSent;
import com.openkm.extension.dao.bean.ProposedQuerySent;
import com.openkm.extension.dao.bean.ProposedSubscriptionSent;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.bean.extension.GWTMessageReceived;
import com.openkm.frontend.client.bean.extension.GWTMessageSent;
import com.openkm.frontend.client.bean.extension.GWTProposedQuerySent;
import com.openkm.frontend.client.bean.extension.GWTProposedSubscriptionSent;
import com.openkm.frontend.client.bean.extension.GWTTextMessageSent;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.frontend.client.service.extension.OKMMessageService;
import com.openkm.frontend.client.util.MessageSentComparator;
import com.openkm.jcr.JCRUtils;
import com.openkm.principal.PrincipalAdapterException;
import com.openkm.servlet.frontend.OKMRemoteServiceServlet;
import com.openkm.util.GWTUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.LoginException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageServlet
extends OKMRemoteServiceServlet
implements OKMMessageService {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(MessageServlet.class);

    @Override
    public void send(String users, String roles, String subject, String content) throws OKMException {
        Object[] obj = new Object[]{users, roles, subject, content};
        log.debug("send({}, {}, {}, {})", obj);
        this.updateSessionManager();
        try {
            String remoteUser = this.getThreadLocalRequest().getRemoteUser();
            String to = "";
            to = !users.equals("") && !roles.equals("") ? users + "," + roles : users + roles;
            ArrayList<String> userNames = new ArrayList<String>(Arrays.asList(users.split(",")));
            List<String> roleNames = Arrays.asList(roles.split(","));
            for (String role : roleNames) {
                List<String> usersInRole = OKMAuth.getInstance().getUsersByRole(null, role);
                for (String user : usersInRole) {
                    if (userNames.contains(user)) continue;
                    userNames.add(user);
                }
            }
            for (String user : userNames) {
                MessageDAO.send(remoteUser, to, user, subject, content);
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("025", "024"), e.getMessage());
        }
        catch (PrincipalAdapterException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("025", "025"), e.getMessage());
        }
    }

    @Override
    public List<String> findSentUsersTo() throws OKMException {
        log.debug("findSentUsersTo()");
        this.updateSessionManager();
        try {
            String me = this.getThreadLocalRequest().getRemoteUser();
            ArrayList<String> usersList = new ArrayList<String>(ProposedQueryDAO.findProposedQuerySentUsersTo(me));
            for (String user : MessageDAO.findSentUsersTo(me)) {
                if (usersList.contains(user)) continue;
                usersList.add(user);
            }
            for (String user : ProposedQueryDAO.findProposedQuerySentUsersTo(me)) {
                if (usersList.contains(user)) continue;
                usersList.add(user);
            }
            for (String user : ProposedSubscriptionDAO.findProposedSubscriptionSentUsersTo(me)) {
                if (usersList.contains(user)) continue;
                usersList.add(user);
            }
            return usersList;
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("025", "024"), e.getMessage());
        }
    }

    @Override
    public Map<String, Long> findReceivedUsersFrom() throws OKMException {
        log.debug("findReceivedUsersFrom()");
        HashMap<String, Long> received = new HashMap<String, Long>();
        this.updateSessionManager();
        try {
            String user = this.getThreadLocalRequest().getRemoteUser();
            Map<String, Long> unreadMap = MessageDAO.findReceivedUsersFromUnread(user);
            for (String sender : MessageDAO.findReceivedUsersFrom(this.getThreadLocalRequest().getRemoteUser())) {
                if (unreadMap.containsKey(sender)) {
                    received.put(sender, unreadMap.get(sender));
                    continue;
                }
                received.put(sender, new Long(0L));
            }
            return received;
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("025", "024"), e.getMessage());
        }
    }

    @Override
    public List<GWTMessageSent> findSentFromMeToUser(String user) throws OKMException {
        log.debug("findSentFromMeToUser({})", (Object)user);
        ArrayList<GWTMessageSent> messageSentList = new ArrayList<GWTMessageSent>();
        Session session = null;
        this.updateSessionManager();
        try {
            GWTMessageSent message;
            session = JCRUtils.getSession();
            String me = this.getThreadLocalRequest().getRemoteUser();
            for (MessageSent messageSent : MessageDAO.findSentFromMeToUser(me, user)) {
                GWTTextMessageSent textMessageSent = new GWTTextMessageSent();
                textMessageSent = GWTUtil.copy(messageSent);
                message = new GWTMessageSent();
                message.setTextMessageSent(textMessageSent);
                message.setSentDate(textMessageSent.getSentDate());
                messageSentList.add(message);
            }
            for (QueryParams queryParams : QueryParamsDAO.findProposedQueryFromMeToUser(me, user)) {
                for (ProposedQuerySent proposedQuerySent : queryParams.getProposedSent()) {
                    if (!proposedQuerySent.getUser().equals(user)) continue;
                    GWTProposedQuerySent gWTproposedQuerySent = GWTUtil.copy(proposedQuerySent, queryParams);
                    GWTMessageSent message2 = new GWTMessageSent();
                    message2.setProposedQuerySent(gWTproposedQuerySent);
                    message2.setSentDate(gWTproposedQuerySent.getSentDate());
                    messageSentList.add(message2);
                }
            }
            for (ProposedSubscriptionSent proposedSubscriptionSent : ProposedSubscriptionDAO.findSentProposedSubscriptionFromMeToUser(session, me, user)) {
                GWTProposedSubscriptionSent gWTproposedSubscriptionSent = GWTUtil.copy(proposedSubscriptionSent);
                message = new GWTMessageSent();
                message.setProposedSubscriptionSent(gWTproposedSubscriptionSent);
                message.setSentDate(gWTproposedSubscriptionSent.getSentDate());
                messageSentList.add(message);
            }
            Collections.sort(messageSentList, MessageSentComparator.getInstance());
            ArrayList<GWTMessageSent> arrayList = messageSentList;
            return arrayList;
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("025", "024"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("025", "001"), e.getMessage());
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("025", "013"), e.getMessage());
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("025", "015"), e.getMessage());
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("025", "019"), e.getMessage());
        }
        catch (LoginException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("025", "029"), e.getMessage());
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("025", "001"), e.getMessage());
        }
        finally {
            JCRUtils.logout(session);
        }
    }

    @Override
    public List<GWTMessageReceived> findReceivedByMeFromUser(String user) throws OKMException {
        log.debug("findSentFromMeToUser({})", (Object)user);
        ArrayList<GWTMessageReceived> messageReceivedList = new ArrayList<GWTMessageReceived>();
        this.updateSessionManager();
        try {
            for (MessageReceived messageReceived : MessageDAO.findReceivedByMeFromUser(this.getThreadLocalRequest().getRemoteUser(), user)) {
                messageReceivedList.add(GWTUtil.copy(messageReceived));
            }
            return messageReceivedList;
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("025", "024"), e.getMessage());
        }
    }

    @Override
    public void deleteReceived(int msgId) throws OKMException {
        log.debug("deleteReceived({})", (Object)msgId);
        this.updateSessionManager();
        try {
            MessageDAO.deleteReceived(msgId);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("025", "024"), e.getMessage());
        }
    }

    @Override
    public void deleteSent(int msgId) throws OKMException {
        log.debug("deleteSent({})", (Object)msgId);
        this.updateSessionManager();
        try {
            MessageDAO.deleteSent(msgId);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("025", "024"), e.getMessage());
        }
    }

    @Override
    public void markSeen(int msgId) throws OKMException {
        log.debug("markSeen({})", (Object)msgId);
        this.updateSessionManager();
        try {
            MessageDAO.markSeen(msgId);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("025", "024"), e.getMessage());
        }
    }

    @Override
    public void deleteSentFromMeToUser(String user) throws OKMException {
        log.debug("deleteSentFromMeToUser({})", (Object)user);
        ArrayList<String> msgId = new ArrayList<String>();
        ArrayList<String> pqId = new ArrayList<String>();
        ArrayList<String> psId = new ArrayList<String>();
        Session session = null;
        this.updateSessionManager();
        try {
            session = JCRUtils.getSession();
            String me = this.getThreadLocalRequest().getRemoteUser();
            for (MessageSent messageSent : MessageDAO.findSentFromMeToUser(me, user)) {
                msgId.add(String.valueOf(messageSent.getId()));
            }
            for (QueryParams queryParams : QueryParamsDAO.findProposedQueryFromMeToUser(me, user)) {
                for (ProposedQuerySent proposedQuerySent : queryParams.getProposedSent()) {
                    if (!proposedQuerySent.getUser().equals(user)) continue;
                    pqId.add(String.valueOf(proposedQuerySent.getId()));
                }
            }
            for (ProposedSubscriptionSent proposedSubscriptionSent : ProposedSubscriptionDAO.findSentProposedSubscriptionFromMeToUser(session, me, user)) {
                psId.add(String.valueOf(proposedSubscriptionSent.getId()));
            }
            for (String id : msgId) {
                MessageDAO.deleteSent(Integer.valueOf(id));
            }
            for (String id : pqId) {
                ProposedQueryDAO.deleteSent(Integer.valueOf(id));
            }
            for (String id : psId) {
                ProposedSubscriptionDAO.deleteSent(Integer.valueOf(id));
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("025", "024"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("025", "001"), e.getMessage());
        }
        catch (LoginException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("025", "029"), e.getMessage());
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("025", "001"), e.getMessage());
        }
        finally {
            JCRUtils.logout(session);
        }
    }

    @Override
    public void deleteReceivedByMeFromUser(String user) throws OKMException {
        log.debug("deleteReceivedByMeFromUser({})", (Object)user);
        ArrayList<String> msgId = new ArrayList<String>();
        this.updateSessionManager();
        try {
            for (MessageReceived messageReceived : MessageDAO.findReceivedByMeFromUser(this.getThreadLocalRequest().getRemoteUser(), user)) {
                msgId.add(String.valueOf(messageReceived.getId()));
            }
            for (String id : msgId) {
                MessageDAO.deleteReceived(Integer.valueOf(id));
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("025", "024"), e.getMessage());
        }
    }
}

