/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.extension.servlet;

import com.openkm.api.OKMAuth;
import com.openkm.core.DatabaseException;
import com.openkm.core.ParseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.dao.QueryParamsDAO;
import com.openkm.dao.bean.QueryParams;
import com.openkm.extension.dao.ProposedQueryDAO;
import com.openkm.extension.dao.bean.ProposedQueryReceived;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.bean.extension.GWTProposedQueryReceived;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.frontend.client.service.extension.OKMProposedQueryService;
import com.openkm.principal.PrincipalAdapterException;
import com.openkm.servlet.frontend.OKMRemoteServiceServlet;
import com.openkm.util.GWTUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProposedQueryServlet
extends OKMRemoteServiceServlet
implements OKMProposedQueryService {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(ProposedQueryServlet.class);

    @Override
    public void create(int qpId, String users, String roles, String comment) throws OKMException {
        Object[] obj = new Object[]{qpId, users, roles, comment};
        log.debug("create({}, {}, {}, {})", obj);
        try {
            String remoteUser = this.getThreadLocalRequest().getRemoteUser();
            String to = "";
            to = !users.equals("") && !roles.equals("") ? users + "," + roles : users + roles;
            ArrayList<String> userNames = new ArrayList<String>(Arrays.asList(users.split(",")));
            List<String> roleNames = Arrays.asList(roles.split(","));
            for (String role : roleNames) {
                List<String> usersInRole = OKMAuth.getInstance().getUsersByRole(null, role);
                for (String user : usersInRole) {
                    if (userNames.contains(user)) continue;
                    userNames.add(user);
                }
            }
            if (userNames.contains(remoteUser)) {
                userNames.remove(remoteUser);
            }
            for (String user : userNames) {
                ProposedQueryDAO.send(qpId, remoteUser, to, user, comment);
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("024", "024"), e.getMessage());
        }
        catch (PrincipalAdapterException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("024", "025"), e.getMessage());
        }
    }

    @Override
    public Map<String, Long> findProposedQueriesUsersFrom() throws OKMException {
        log.debug("findProposedQueriesUsersFrom()");
        HashMap<String, Long> received = new HashMap<String, Long>();
        this.updateSessionManager();
        try {
            String user = this.getThreadLocalRequest().getRemoteUser();
            Map<String, Long> unreadMap = ProposedQueryDAO.findProposedQueriesUsersFromUnread(user);
            for (String sender : ProposedQueryDAO.findProposedQueriesUsersFrom(user)) {
                if (unreadMap.containsKey(sender)) {
                    received.put(sender, unreadMap.get(sender));
                    continue;
                }
                received.put(sender, new Long(0L));
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("024", "024"), e.getMessage());
        }
        log.debug("findProposedQueriesUsersFromUnread: Map" + received);
        return received;
    }

    @Override
    public void deleteReceived(int pqId) throws OKMException {
        log.debug("deleteReceived({})", (Object)pqId);
        this.updateSessionManager();
        try {
            ProposedQueryDAO.deleteReceived(pqId);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("024", "024"), e.getMessage());
        }
        log.debug("deleteReceived() : void");
    }

    @Override
    public void deleteSent(int pqId) throws OKMException {
        log.debug("deleteSent({})", (Object)pqId);
        this.updateSessionManager();
        try {
            ProposedQueryDAO.deleteSent(pqId);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("024", "024"), e.getMessage());
        }
        log.debug("deleteSent() : void");
    }

    @Override
    public List<GWTProposedQueryReceived> findProposedQueryByMeFromUser(String user) throws OKMException {
        log.debug("findProposedQueryByMeFromUser()");
        this.updateSessionManager();
        ArrayList<GWTProposedQueryReceived> proposedQueryReceivedList = new ArrayList<GWTProposedQueryReceived>();
        try {
            String me = this.getThreadLocalRequest().getRemoteUser();
            for (QueryParams queryParams : QueryParamsDAO.findProposedQueryByMeFromUser(me, user)) {
                for (ProposedQueryReceived proposedQueryReceived : queryParams.getProposedReceived()) {
                    if (!proposedQueryReceived.getUser().equals(me)) continue;
                    proposedQueryReceivedList.add(GWTUtil.copy(proposedQueryReceived, queryParams));
                }
            }
            return proposedQueryReceivedList;
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("024", "024"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("024", "001"), e.getMessage());
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("024", "013"), e.getMessage());
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("024", "015"), e.getMessage());
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("024", "019"), e.getMessage());
        }
    }

    @Override
    public void markAccepted(int msgId) throws OKMException {
        log.debug("markAccepted({})", (Object)msgId);
        this.updateSessionManager();
        try {
            ProposedQueryDAO.markAccepted(msgId);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("024", "024"), e.getMessage());
        }
        log.debug("markAccepted() : void");
    }

    @Override
    public void markSeen(int msgId) throws OKMException {
        log.debug("markSeen({})", (Object)msgId);
        this.updateSessionManager();
        try {
            ProposedQueryDAO.markSeen(msgId);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("024", "024"), e.getMessage());
        }
        log.debug("markSeen() : void");
    }

    @Override
    public void deleteProposedQueryByMeFromUser(String user) throws OKMException {
        log.debug("deleteProposedQueryByMeFromUser({})", (Object)user);
        ArrayList<String> pqId = new ArrayList<String>();
        this.updateSessionManager();
        try {
            for (ProposedQueryReceived proposedQueryReceived : ProposedQueryDAO.findProposedQueryByMeFromUser(this.getThreadLocalRequest().getRemoteUser(), user)) {
                pqId.add(String.valueOf(proposedQueryReceived.getId()));
            }
            for (String id : pqId) {
                ProposedQueryDAO.deleteReceived(Integer.valueOf(id));
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("024", "024"), e.getMessage());
        }
    }
}

