/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.extension.servlet;

import com.openkm.api.OKMAuth;
import com.openkm.core.DatabaseException;
import com.openkm.core.RepositoryException;
import com.openkm.extension.dao.ProposedSubscriptionDAO;
import com.openkm.extension.dao.bean.ProposedSubscriptionReceived;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.bean.extension.GWTProposedSubscriptionReceived;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.frontend.client.service.extension.OKMProposedSubscriptionService;
import com.openkm.jcr.JCRUtils;
import com.openkm.principal.PrincipalAdapterException;
import com.openkm.servlet.frontend.OKMRemoteServiceServlet;
import com.openkm.util.GWTUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.LoginException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProposedSubscriptionServlet
extends OKMRemoteServiceServlet
implements OKMProposedSubscriptionService {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(ProposedSubscriptionServlet.class);

    @Override
    public void send(String uuid, String users, String roles, String comment) throws OKMException {
        Object[] obj = new Object[]{uuid, users, roles, comment};
        log.debug("create({}, {}, {}, {})", obj);
        try {
            String remoteUser = this.getThreadLocalRequest().getRemoteUser();
            String to = "";
            to = !users.equals("") && !roles.equals("") ? users + "," + roles : users + roles;
            ArrayList<String> userNames = new ArrayList<String>(Arrays.asList(users.split(",")));
            List<String> roleNames = Arrays.asList(roles.split(","));
            for (String role : roleNames) {
                List<String> usersInRole = OKMAuth.getInstance().getUsersByRole(null, role);
                for (String user : usersInRole) {
                    if (userNames.contains(user)) continue;
                    userNames.add(user);
                }
            }
            if (userNames.contains(remoteUser)) {
                userNames.remove(remoteUser);
            }
            for (String user : userNames) {
                ProposedSubscriptionDAO.send(remoteUser, to, user, uuid, comment);
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("023", "024"), e.getMessage());
        }
        catch (PrincipalAdapterException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("023", "025"), e.getMessage());
        }
    }

    @Override
    public Map<String, Long> findProposedSubscriptionsUsersFrom() throws OKMException {
        log.debug("findProposedSubscriptionsUsersFrom()");
        HashMap<String, Long> received = new HashMap<String, Long>();
        this.updateSessionManager();
        try {
            String user = this.getThreadLocalRequest().getRemoteUser();
            Map<String, Long> unreadMap = ProposedSubscriptionDAO.findProposedSubscriptionsUsersFromUnread(user);
            for (String sender : ProposedSubscriptionDAO.findProposedSubscriptionsUsersFrom(user)) {
                if (unreadMap.containsKey(sender)) {
                    received.put(sender, unreadMap.get(sender));
                    continue;
                }
                received.put(sender, new Long(0L));
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("023", "024"), e.getMessage());
        }
        log.debug("findProposedSubscriptionsUsersFrom: Map" + received);
        return received;
    }

    @Override
    public List<GWTProposedSubscriptionReceived> findProposedSubscriptionByMeFromUser(String user) throws OKMException {
        log.debug("findProposedSubscriptionByMeFromUser()");
        this.updateSessionManager();
        ArrayList<GWTProposedSubscriptionReceived> proposedQuerySubscriptionList = new ArrayList<GWTProposedSubscriptionReceived>();
        Session session = null;
        try {
            session = JCRUtils.getSession();
            for (ProposedSubscriptionReceived proposedSubscriptionReceived : ProposedSubscriptionDAO.findProposedSubscriptionByMeFromUser(session, this.getThreadLocalRequest().getRemoteUser(), user)) {
                proposedQuerySubscriptionList.add(GWTUtil.copy(proposedSubscriptionReceived));
            }
            ArrayList<GWTProposedSubscriptionReceived> i$ = proposedQuerySubscriptionList;
            return i$;
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("024", "024"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("024", "001"), e.getMessage());
        }
        catch (LoginException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("023", "029"), e.getMessage());
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("023", "001"), e.getMessage());
        }
        finally {
            JCRUtils.logout(session);
        }
    }

    @Override
    public void markSeen(int msgId) throws OKMException {
        log.debug("markSeen({})", (Object)msgId);
        this.updateSessionManager();
        try {
            ProposedSubscriptionDAO.markSeen(msgId);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("023", "024"), e.getMessage());
        }
        log.debug("markSeen() : void");
    }

    @Override
    public void markAccepted(int msgId) throws OKMException {
        log.debug("markAccepted({})", (Object)msgId);
        this.updateSessionManager();
        try {
            ProposedSubscriptionDAO.markAccepted(msgId);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("023", "024"), e.getMessage());
        }
        log.debug("markAccepted() : void");
    }

    @Override
    public void deleteReceived(int msgId) throws OKMException {
        log.debug("deleteReceived({})", (Object)msgId);
        this.updateSessionManager();
        try {
            ProposedSubscriptionDAO.deleteReceived(msgId);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("023", "024"), e.getMessage());
        }
        log.debug("deleteReceived() : void");
    }

    @Override
    public void deleteSent(int msgId) throws OKMException {
        log.debug("deleteSent({})", (Object)msgId);
        this.updateSessionManager();
        try {
            ProposedSubscriptionDAO.deleteSent(msgId);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("023", "024"), e.getMessage());
        }
        log.debug("deleteSent() : void");
    }

    @Override
    public void deleteProposedSubscriptionByMeFromUser(String sender) throws OKMException {
        log.debug("deleteProposedSubscriptionByMeFromUser()");
        this.updateSessionManager();
        ArrayList<String> IdToDelete = new ArrayList<String>();
        Session session = null;
        try {
            session = JCRUtils.getSession();
            for (ProposedSubscriptionReceived ps : ProposedSubscriptionDAO.findProposedSubscriptionByMeFromUser(session, this.getThreadLocalRequest().getRemoteUser(), sender)) {
                if (!ps.getFrom().equals(sender)) continue;
                IdToDelete.add(String.valueOf(ps.getId()));
            }
            for (String id : IdToDelete) {
                ProposedSubscriptionDAO.deleteReceived(Integer.valueOf(id));
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("023", "024"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("023", "001"), e.getMessage());
        }
        catch (LoginException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("023", "029"), e.getMessage());
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("023", "001"), e.getMessage());
        }
        finally {
            JCRUtils.logout(session);
        }
        log.debug("deleteProposedSubscriptionByMeFromUser: void");
    }
}

