/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.extension.servlet;

import bsh.EvalError;
import com.lowagie.text.DocumentException;
import com.openkm.api.OKMDocument;
import com.openkm.bean.Document;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.ConversionException;
import com.openkm.core.DatabaseException;
import com.openkm.core.FileSizeExceededException;
import com.openkm.core.ItemExistsException;
import com.openkm.core.LockException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.core.UnsupportedMimeTypeException;
import com.openkm.core.UserQuotaExceededException;
import com.openkm.core.VersionException;
import com.openkm.core.VirusDetectedException;
import com.openkm.extension.core.ExtensionException;
import com.openkm.extension.dao.StampImageDAO;
import com.openkm.extension.dao.StampTextDAO;
import com.openkm.extension.dao.bean.StampImage;
import com.openkm.extension.dao.bean.StampText;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.bean.extension.GWTStamp;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.frontend.client.service.extension.OKMStampService;
import com.openkm.jcr.JCRUtils;
import com.openkm.servlet.frontend.OKMRemoteServiceServlet;
import com.openkm.util.DocConverter;
import com.openkm.util.GWTUtil;
import com.openkm.util.PDFUtils;
import com.openkm.util.SecureStore;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StampServlet
extends OKMRemoteServiceServlet
implements OKMStampService {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(StampServlet.class);

    @Override
    public List<GWTStamp> findAll() throws OKMException {
        log.debug("findAll()");
        ArrayList<GWTStamp> stampList = new ArrayList<GWTStamp>();
        String remoteUser = this.getThreadLocalRequest().getRemoteUser();
        try {
            for (StampText stampText : StampTextDAO.findByUser(remoteUser)) {
                stampList.add(GWTUtil.copy(stampText));
            }
            for (StampImage stampImage : StampImageDAO.findByUser(remoteUser)) {
                stampList.add(GWTUtil.copy(stampImage));
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("026", "024"), e.getMessage());
        }
        return stampList;
    }

    @Override
    public void Stamp(int id, int type, String path) throws OKMException {
        log.debug("Stamp({}, {})", new Object[]{id, type});
        this.updateSessionManager();
        File tmp = null;
        File tmpPdf = null;
        File tmpStampPdf = null;
        try {
            Document doc = OKMDocument.getInstance().getProperties(null, path);
            tmp = File.createTempFile("okm", ".tmp");
            tmpPdf = File.createTempFile("okm", ".pdf");
            tmpStampPdf = File.createTempFile("okm", ".pdf");
            FileOutputStream fos = null;
            fos = doc.getMimeType().equals("application/pdf") ? new FileOutputStream(tmpPdf) : new FileOutputStream(tmp);
            InputStream is = OKMDocument.getInstance().getContent(null, path, false);
            IOUtils.copy((InputStream)is, (OutputStream)fos);
            fos.flush();
            fos.close();
            is.close();
            if (!doc.getMimeType().equals("application/pdf")) {
                DocConverter converter = DocConverter.getInstance();
                if (doc.getMimeType().startsWith("image/")) {
                    converter.img2pdf(tmp, doc.getMimeType(), tmpPdf);
                } else {
                    converter.doc2pdf(tmp, doc.getMimeType(), tmpPdf);
                }
            }
            is = new FileInputStream(tmpPdf);
            fos = new FileOutputStream(tmpStampPdf);
            switch (type) {
                case 0: {
                    StampText st = StampTextDAO.findByPk(id);
                    PDFUtils.stampText(is, st.getText(), st.getLayer(), st.getOpacity(), st.getSize(), Color.decode(st.getColor()), st.getRotation(), st.getAlign(), st.getExprX(), st.getExprY(), fos);
                    break;
                }
                case 1: {
                    StampImage si = StampImageDAO.findByPk(id);
                    byte[] image = SecureStore.b64Decode(si.getImageContent());
                    PDFUtils.stampImage(is, image, si.getLayer(), si.getOpacity(), si.getExprX(), si.getExprY(), fos);
                }
            }
            fos.close();
            is.close();
            is = new FileInputStream(tmpStampPdf);
            if (!doc.getMimeType().equals("application/pdf")) {
                Document newDoc = new Document();
                String parentFld = JCRUtils.getParent(path);
                String docName = JCRUtils.getName(path);
                int idx = docName.lastIndexOf(46);
                if (idx > 0) {
                    docName = docName.substring(0, idx);
                }
                newDoc.setPath(parentFld + "/" + docName + ".pdf");
                OKMDocument.getInstance().create(null, newDoc, is);
            } else {
                OKMDocument.getInstance().checkout(null, path, new Boolean[0]);
                OKMDocument.getInstance().setContent(null, path, is, tmpStampPdf.length());
                OKMDocument.getInstance().checkin(null, path, "Stamped", new Boolean[0]);
            }
            is.close();
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("026", "024"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("026", "001"), e.getMessage());
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("026", "015"), e.getMessage());
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("026", "013"), e.getMessage());
        }
        catch (NumberFormatException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("026", "028"), e.getMessage());
        }
        catch (DocumentException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("026", "030"), e.getMessage());
        }
        catch (EvalError e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("026", "031"), e.getMessage());
        }
        catch (UnsupportedMimeTypeException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("026", "010"), e.getMessage());
        }
        catch (FileSizeExceededException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("026", "011"), e.getMessage());
        }
        catch (UserQuotaExceededException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("026", "023"), e.getMessage());
        }
        catch (VirusDetectedException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("026", "032"), e.getMessage());
        }
        catch (ItemExistsException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("026", "003"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("026", "009"), e.getMessage());
        }
        catch (LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("026", "004"), e.getMessage());
        }
        catch (VersionException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("026", "016"), e.getMessage());
        }
        catch (ConversionException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("026", "033"), e.getMessage());
        }
        catch (ExtensionException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("026", "041"), e.getMessage());
        }
        finally {
            tmp.delete();
            tmpPdf.delete();
            tmpStampPdf.delete();
        }
    }
}

