/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.extension.servlet;

import com.openkm.api.OKMDocument;
import com.openkm.api.OKMRepository;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.extension.dao.StapleGroupDAO;
import com.openkm.extension.dao.bean.Staple;
import com.openkm.extension.dao.bean.StapleGroup;
import com.openkm.extension.servlet.BaseServlet;
import com.openkm.util.ArchiveUtils;
import com.openkm.util.WebUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaplingDownloadServlet
extends BaseServlet {
    private static Logger log = LoggerFactory.getLogger(StaplingDownloadServlet.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setCharacterEncoding("UTF-8");
        int sgId = WebUtils.getInt(request, "sgId");
        File tmpZip = File.createTempFile("okm", ".zip");
        try {
            String archive = "stapling.zip";
            response.setHeader("Content-disposition", "attachment; filename=\"" + archive + "\"");
            response.setContentType("application/zip");
            ServletOutputStream out = response.getOutputStream();
            this.exportZip(sgId, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (RepositoryException e) {
            log.warn(e.getMessage(), (Throwable)e);
            response.sendError(500, "RepositoryException: " + e.getMessage());
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            response.sendError(500, e.getMessage());
        }
        finally {
            com.openkm.util.FileUtils.deleteQuietly(tmpZip);
        }
    }

    private void exportZip(int sgId, OutputStream os) throws RepositoryException, IOException, DatabaseException {
        log.debug("exportZip({}, {})", (Object)sgId, (Object)os);
        File tmpDir = null;
        BufferedWriter bw = null;
        OKMDocument okmDoc = OKMDocument.getInstance();
        OKMRepository okmRepo = OKMRepository.getInstance();
        try {
            tmpDir = com.openkm.util.FileUtils.createTempDir();
            bw = new BufferedWriter(new FileWriter(new File(tmpDir, "summary.txt")));
            StapleGroup sg = StapleGroupDAO.findByPk(sgId);
            for (Staple s : sg.getStaples()) {
                String uuid = s.getUuid();
                String path = null;
                try {
                    path = okmRepo.getNodePath(null, uuid);
                    int idx = path.indexOf(47, 1);
                    if (idx <= 0) continue;
                    String relPath = path.substring(idx);
                    File expFile = new File(tmpDir, relPath);
                    expFile.getParentFile().mkdirs();
                    FileOutputStream fos = new FileOutputStream(expFile);
                    if (okmDoc.isValid(null, path)) {
                        InputStream is = okmDoc.getContent(null, path, false);
                        IOUtils.copy((InputStream)is, (OutputStream)fos);
                        is.close();
                    }
                    bw.write(path + " - OK\n");
                    bw.flush();
                }
                catch (PathNotFoundException e) {
                    bw.write(path != null ? path : uuid + " - " + e.getMessage() + "\n");
                    bw.flush();
                }
                catch (AccessDeniedException e) {
                    bw.write(path != null ? path : uuid + " - " + e.getMessage() + "\n");
                    bw.flush();
                }
            }
            IOUtils.closeQuietly((Writer)bw);
            ArchiveUtils.createZip(tmpDir, "stapling", os);
        }
        catch (IOException e) {
            log.error("Error exporting zip", (Throwable)e);
            throw e;
        }
        finally {
            if (tmpDir != null) {
                try {
                    FileUtils.deleteDirectory((File)tmpDir);
                }
                catch (IOException e) {
                    log.error("Error deleting temporal directory", (Throwable)e);
                    throw e;
                }
            }
        }
        log.debug("exportZip: void");
    }
}

