/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.extension.servlet;

import com.openkm.core.DatabaseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.extension.dao.StapleGroupDAO;
import com.openkm.extension.dao.bean.Staple;
import com.openkm.extension.dao.bean.StapleGroup;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.bean.extension.GWTStapleGroup;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.frontend.client.service.extension.OKMStaplingService;
import com.openkm.servlet.frontend.OKMRemoteServiceServlet;
import com.openkm.util.GWTUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaplingServlet
extends OKMRemoteServiceServlet
implements OKMStaplingService {
    private static Logger log = LoggerFactory.getLogger(StaplingServlet.class);
    private static final long serialVersionUID = 395857404418870245L;

    @Override
    public String create(String user, String uuid, String type, String uuid2, String type2) throws OKMException {
        StapleGroup stapleGroup = new StapleGroup();
        stapleGroup.setUser(user);
        try {
            int id = StapleGroupDAO.create(stapleGroup);
            stapleGroup = StapleGroupDAO.findByPk(id);
            Staple staple = new Staple();
            staple.setUuid(uuid);
            staple.setType(type);
            stapleGroup.getStaples().add(staple);
            staple = new Staple();
            staple.setUuid(uuid2);
            staple.setType(type2);
            stapleGroup.getStaples().add(staple);
            StapleGroupDAO.update(stapleGroup);
            return String.valueOf(id);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("021", "024"), e.getMessage());
        }
    }

    @Override
    public void add(String id, String uuid, String type) throws OKMException {
        try {
            StapleGroup stapleGroup = StapleGroupDAO.findByPk(Integer.valueOf(id));
            boolean found = false;
            for (Staple st : stapleGroup.getStaples()) {
                if (!st.getUuid().equals(uuid)) continue;
                found = true;
                break;
            }
            if (!found) {
                Staple staple = new Staple();
                staple.setUuid(uuid);
                staple.setType(type);
                stapleGroup.getStaples().add(staple);
                StapleGroupDAO.update(stapleGroup);
            }
        }
        catch (NumberFormatException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("021", "028"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("021", "024"), e.getMessage());
        }
    }

    @Override
    public List<GWTStapleGroup> getAll(String uuid) throws OKMException {
        ArrayList<GWTStapleGroup> stapList = new ArrayList<GWTStapleGroup>();
        try {
            for (StapleGroup sg : StapleGroupDAO.findAll(uuid)) {
                stapList.add(GWTUtil.copy(sg));
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("021", "024"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("021", "001"), e.getMessage());
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("021", "015"), e.getMessage());
        }
        return stapList;
    }

    @Override
    public void removeAllStapleByUuid(String uuid) throws OKMException {
        try {
            ArrayList<String> idToDelete = new ArrayList<String>();
            for (StapleGroup sg : StapleGroupDAO.findAll(uuid)) {
                for (Staple staple : sg.getStaples()) {
                    if (!staple.getUuid().equals(uuid)) continue;
                    idToDelete.add(String.valueOf(staple.getId()));
                }
            }
            for (String id : idToDelete) {
                StapleGroupDAO.deleteStaple(Integer.parseInt(id));
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("021", "024"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("021", "001"), e.getMessage());
        }
    }

    @Override
    public void remove(String id) throws OKMException {
        try {
            StapleGroupDAO.delete(Integer.parseInt(id));
        }
        catch (NumberFormatException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("021", "028"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("021", "024"), e.getMessage());
        }
    }

    @Override
    public void removeStaple(String id) throws OKMException {
        try {
            StapleGroupDAO.deleteStaple(Integer.parseInt(id));
        }
        catch (NumberFormatException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("021", "028"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("021", "024"), e.getMessage());
        }
    }
}

