/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.extractor;

import entagged.audioformats.AudioFile;
import entagged.audioformats.AudioFileIO;
import entagged.audioformats.Tag;
import entagged.audioformats.exceptions.CannotReadException;
import entagged.audioformats.mp3.util.id3frames.TextId3Frame;
import entagged.audioformats.ogg.util.OggTagField;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.extractor.AbstractTextExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioTextExtractor
extends AbstractTextExtractor {
    private static final Logger log = LoggerFactory.getLogger(AudioTextExtractor.class);

    public AudioTextExtractor() {
        super(new String[]{"audio/mpeg", "audio/x-ogg"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader extractText(InputStream stream, String type, String encoding) throws IOException {
        File tmpFile = null;
        try {
            if (type.equals("audio/mpeg")) {
                tmpFile = File.createTempFile("okm", ".mp3");
            } else if (type.equals("audio/x-ogg")) {
                tmpFile = File.createTempFile("okm", ".ogg");
            }
            FileOutputStream fos = new FileOutputStream(tmpFile);
            IOUtils.copy((InputStream)stream, (OutputStream)fos);
            fos.close();
            StringBuffer sb = new StringBuffer();
            AudioFile af = AudioFileIO.read((File)tmpFile);
            Tag tag = af.getTag();
            Iterator it = tag.getFields();
            while (it.hasNext()) {
                TextId3Frame tf;
                Object o = it.next();
                if (o instanceof TextId3Frame) {
                    tf = (TextId3Frame)o;
                    sb.append("[ID3] ");
                    sb.append(tf.getId());
                    sb.append("=");
                    sb.append(tf.getContent());
                    sb.append("\n");
                    continue;
                }
                if (!(o instanceof OggTagField)) continue;
                tf = (OggTagField)o;
                sb.append("[OGG] ");
                sb.append(tf.getId());
                sb.append("=");
                sb.append(tf.getContent());
                sb.append("\n");
            }
            log.debug("TEXT: " + sb.toString());
            StringReader stringReader = new StringReader(sb.toString());
            return stringReader;
        }
        catch (CannotReadException e) {
            log.warn("Failed to extract tag information", (Throwable)e);
            StringReader stringReader = new StringReader("");
            return stringReader;
        }
        finally {
            stream.close();
            tmpFile.delete();
        }
    }
}

