/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.extractor;

import com.openkm.core.Config;
import com.openkm.util.DocumentUtils;
import com.openkm.util.ExecutionUtils;
import com.openkm.util.FileUtils;
import com.openkm.util.TemplateUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.extractor.AbstractTextExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuneiformTextExtractor
extends AbstractTextExtractor {
    private static final Logger log = LoggerFactory.getLogger(CuneiformTextExtractor.class);

    public CuneiformTextExtractor() {
        super(new String[]{"image/tiff", "image/gif", "image/jpg", "image/jpeg", "image/png"});
    }

    public CuneiformTextExtractor(String[] contentTypes) {
        super(contentTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader extractText(InputStream stream, String type, String encoding) throws IOException {
        File tmpFileIn = null;
        if (!Config.SYSTEM_OCR.equals("")) {
            try {
                tmpFileIn = FileUtils.createTempFileFromMime(type);
                FileOutputStream fos = new FileOutputStream(tmpFileIn);
                IOUtils.copy((InputStream)stream, (OutputStream)fos);
                fos.close();
                String text = this.doOcr(tmpFileIn);
                StringReader stringReader = new StringReader(text);
                return stringReader;
            }
            catch (Exception e) {
                log.warn("Failed to extract OCR text", (Throwable)e);
                StringReader stringReader = new StringReader("");
                return stringReader;
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
                FileUtils.deleteQuietly(tmpFileIn);
            }
        }
        log.warn("Undefined OCR application");
        return new StringReader("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doOcr(File tmpFileIn) throws Exception {
        Reader stdout = null;
        File tmpFileOut = null;
        String cmd = null;
        if (!Config.SYSTEM_OCR.equals("")) {
            String string;
            try {
                tmpFileOut = File.createTempFile("okm", ".txt");
                HashMap<String, Object> hm = new HashMap<String, Object>();
                hm.put("fileIn", tmpFileIn.getPath());
                hm.put("fileOut", tmpFileOut.getPath());
                cmd = TemplateUtils.replace("SYSTEM_OCR", Config.SYSTEM_OCR, hm);
                ExecutionUtils.runCmd(cmd);
                String text = IOUtils.toString((InputStream)new FileInputStream(tmpFileOut.getPath()));
                if (Config.SYSTEM_OPENOFFICE_DICTIONARY.equals("")) {
                    log.debug("TEXT: {}", (Object)text);
                    String string2 = text;
                    return string2;
                }
                text = DocumentUtils.spellChecker(text);
                log.debug("TEXT: {}", (Object)text);
                String string3 = text;
                return string3;
            }
            catch (SecurityException e) {
                log.warn("Security exception executing command: " + cmd, (Throwable)e);
                string = "";
                return string;
            }
            catch (IOException e) {
                log.warn("IO exception executing command: " + cmd, (Throwable)e);
                string = "";
                return string;
            }
            catch (InterruptedException e) {
                log.warn("Interrupted exception executing command: " + cmd, (Throwable)e);
                string = "";
                return string;
            }
            catch (Exception e) {
                log.warn("Failed to extract OCR text", (Throwable)e);
                string = "";
                return string;
            }
            finally {
                IOUtils.closeQuietly(stdout);
                FileUtils.deleteQuietly(tmpFileOut);
                FileUtils.deleteQuietly(new File(tmpFileOut.getPath()));
            }
        }
        log.warn("Undefined OCR application");
        return "";
    }
}

