/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.extractor;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.apache.jackrabbit.extractor.AbstractTextExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExifTextExtractor
extends AbstractTextExtractor {
    private static final Logger log = LoggerFactory.getLogger(ExifTextExtractor.class);

    public ExifTextExtractor() {
        super(new String[]{"image/jpeg"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader extractText(InputStream stream, String type, String encoding) throws IOException {
        try {
            Metadata metadata = ImageMetadataReader.readMetadata((BufferedInputStream)new BufferedInputStream(stream));
            Iterator directories = metadata.getDirectoryIterator();
            StringBuffer sb = new StringBuffer();
            while (directories.hasNext()) {
                Directory directory = (Directory)directories.next();
                Iterator tags = directory.getTagIterator();
                while (tags.hasNext()) {
                    Tag tag = (Tag)tags.next();
                    sb.append("[");
                    sb.append(tag.getDirectoryName());
                    sb.append("] ");
                    sb.append(tag.getTagName());
                    sb.append(" = ");
                    sb.append(tag.getDescription());
                    sb.append("\n");
                }
            }
            log.debug("TEXT: " + sb.toString());
            StringReader stringReader = new StringReader(sb.toString());
            return stringReader;
        }
        catch (ImageProcessingException e) {
            log.warn("Failed to extract EXIF information", (Throwable)e);
            StringReader stringReader = new StringReader("");
            return stringReader;
        }
        catch (MetadataException e) {
            log.warn("Failed to extract EXIF information", (Throwable)e);
            StringReader stringReader = new StringReader("");
            return stringReader;
        }
        finally {
            stream.close();
        }
    }
}

