/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.extractor;

import com.openkm.extractor.MsOffice2007ContentHandler;
import com.openkm.extractor.PresentationMLContentHandler;
import com.openkm.extractor.SpreadsheetMLContentHandler;
import com.openkm.extractor.WordprocessingMLContentHandler;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.jackrabbit.extractor.AbstractTextExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class MsOffice2007TextExtractor
extends AbstractTextExtractor {
    private static final Logger log = LoggerFactory.getLogger(MsOffice2007TextExtractor.class);

    public MsOffice2007TextExtractor() {
        super(new String[]{"application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.openxmlformats-officedocument.wordprocessingml.template", "application/vnd.openxmlformats-officedocument.presentationml.template", "application/vnd.openxmlformats-officedocument.presentationml.slideshow", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.openxmlformats-officedocument.spreadsheetml.template"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader extractText(InputStream stream, String type, String encoding) throws IOException {
        ZipInputStream zis = null;
        try {
            ZipEntry ze;
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(false);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setFeature("http://xml.org/sax/features/validation", false);
            xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            MsOffice2007ContentHandler contentHandler = null;
            if (type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document") || type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.template")) {
                contentHandler = new WordprocessingMLContentHandler();
            } else if (type.equals("application/vnd.openxmlformats-officedocument.presentationml.template") || type.equals("application/vnd.openxmlformats-officedocument.presentationml.slideshow") || type.equals("application/vnd.openxmlformats-officedocument.presentationml.presentation")) {
                contentHandler = new PresentationMLContentHandler();
            } else if (type.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet") || type.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.template")) {
                contentHandler = new SpreadsheetMLContentHandler();
            }
            xmlReader.setContentHandler(contentHandler);
            zis = new ZipInputStream(stream);
            StringBuffer sb = new StringBuffer();
            while ((ze = zis.getNextEntry()) != null) {
                if (ze.getName().startsWith(contentHandler.getFilePattern())) {
                    InputSource is = new InputSource(new FilterInputStream(zis){

                        @Override
                        public void close() {
                        }
                    });
                    log.debug("Parsing " + ze);
                    xmlReader.parse(is);
                    sb.append(contentHandler.getContent());
                    continue;
                }
                log.debug("- " + ze);
            }
            log.debug("TEXT: " + sb.toString());
            StringReader stringReader = new StringReader(sb.toString());
            return stringReader;
        }
        catch (ParserConfigurationException e) {
            log.warn("Failed to extract Microsoft Office 2007 text content", (Throwable)e);
            StringReader stringReader = new StringReader("");
            return stringReader;
        }
        catch (SAXException e) {
            log.warn("Failed to extract Microsoft Office 2007 text content", (Throwable)e);
            StringReader stringReader = new StringReader("");
            return stringReader;
        }
        finally {
            zis.close();
            stream.close();
        }
    }
}

