/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.extractor;

import com.openkm.core.ConversionException;
import com.openkm.util.DocConverter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.extractor.AbstractTextExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OOTextExtractor
extends AbstractTextExtractor {
    private static final Logger log = LoggerFactory.getLogger(OOTextExtractor.class);

    public OOTextExtractor() {
        super(new String[]{"application/vnd.ms-excel", "application/msexcel", "application/excel", "application/vnd.ms-powerpoint", "application/mspowerpoint", "application/powerpoint", "application/vnd.ms-word", "application/msword", "application/word", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.openxmlformats-officedocument.wordprocessingml.template", "application/vnd.openxmlformats-officedocument.presentationml.template", "application/vnd.openxmlformats-officedocument.presentationml.slideshow", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.openxmlformats-officedocument.spreadsheetml.template"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader extractText(InputStream stream, String type, String encoding) throws IOException {
        String ret = "";
        File fIn = File.createTempFile("okm", ".doc");
        File fOut = File.createTempFile("okm", ".txt");
        try {
            FileOutputStream fos = new FileOutputStream(fIn);
            IOUtils.copy((InputStream)stream, (OutputStream)fos);
            fos.flush();
            fos.close();
            DocConverter.getInstance().convert(fIn, type, fOut);
            ret = FileUtils.readFileToString((File)fOut);
            log.debug("TEXT: " + ret);
            StringReader stringReader = new StringReader(ret);
            return stringReader;
        }
        catch (ConversionException e) {
            log.warn("Failed to extract text", (Throwable)e);
            StringReader stringReader = new StringReader("");
            return stringReader;
        }
        finally {
            stream.close();
            fIn.delete();
            fOut.delete();
        }
    }
}

