/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.extractor;

import com.openkm.core.Config;
import com.openkm.module.direct.DirectRepositoryModule;
import com.openkm.util.ReaderInputStream;
import com.openkm.util.UserActivity;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.StringTokenizer;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.config.SearchConfig;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.query.lucene.JackrabbitTextExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredExtractors {
    private static Logger log = LoggerFactory.getLogger(RegisteredExtractors.class);
    private static JackrabbitTextExtractor jte = new JackrabbitTextExtractor("");
    private static final int MIN_EXTRACTION = 16;

    public static synchronized void init() {
        log.info("Initializing text extractors");
        jte = new JackrabbitTextExtractor(Config.REGISTERED_TEXT_EXTRACTORS);
    }

    public static String[] getContentTypes() {
        return jte.getContentTypes();
    }

    public static boolean isRegistered(String className) {
        String classes = "";
        if (Config.EXPERIMENTAL_TEXT_EXTRACTION) {
            classes = Config.REGISTERED_TEXT_EXTRACTORS;
        } else {
            try {
                RepositoryConfig rc = DirectRepositoryModule.getRepositoryConfig();
                WorkspaceConfig wc = rc.getWorkspaceConfig(rc.getDefaultWorkspaceName());
                SearchConfig sc = wc.getSearchConfig();
                if (sc != null) {
                    classes = (String)sc.getParameters().get("textFilterClasses");
                }
            }
            catch (ConfigurationException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        StringTokenizer tokenizer = new StringTokenizer(classes, ", \t\n\r\f");
        while (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken();
            if (!name.equals(className)) continue;
            return true;
        }
        return false;
    }

    public static InputStream getText(Node node, String mimeType, String encoding, InputStream is) throws ValueFormatException, PathNotFoundException, RepositoryException, IOException {
        log.info("getText({}, {}, {})", new Object[]{mimeType, encoding, is});
        ReaderInputStream ret = null;
        boolean failure = false;
        String failureMessage = "Unknown error";
        try {
            Reader rd = jte.extractText(is, mimeType, encoding);
            if (rd.markSupported()) {
                rd.mark(0);
                long sk = rd.skip(16L);
                if (sk < 16L) {
                    failure = true;
                }
                rd.reset();
            } else {
                log.warn("Mark not supported in {}", (Object)rd.getClass().getCanonicalName());
            }
            ret = new ReaderInputStream(rd);
        }
        catch (Exception e) {
            log.warn("Text extraction failure: {}", (Object)e.getMessage());
            failureMessage = e.getMessage();
            failure = true;
        }
        if ((failure || ret == null) && node != null) {
            log.warn("There was a problem extracting text from '{}'", (Object)node.getPath());
            UserActivity.log(node.getSession().getUserID(), "MISC_TEXT_EXTRACTION_FAILURE", node.getUUID(), node.getPath() + ", FailureMessage: " + failureMessage);
        }
        log.info("getText: {}", (Object)ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void index(Node docNode, Node contNode, String mimeType) throws ValueFormatException, PathNotFoundException, RepositoryException, IOException {
        InputStream in = null;
        InputStream out = null;
        try {
            in = contNode.getProperty("jcr:data").getStream();
            out = RegisteredExtractors.getText(docNode, mimeType, "UTF-8", in);
            try {
                contNode.setProperty("okm:text", out);
            }
            catch (Exception e) {
                log.warn("Text extraction failure - {}: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly((InputStream)in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)out);
        IOUtils.closeQuietly((InputStream)in);
    }
}

