/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.extractor;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.jackrabbit.extractor.AbstractTextExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceCodeTextExtractor
extends AbstractTextExtractor {
    private static final Logger log = LoggerFactory.getLogger(SourceCodeTextExtractor.class);

    public SourceCodeTextExtractor() {
        super(new String[]{"text/x-java", "text/css", "text/x-csrc", "text/x-sql", "application/x-php", "application/javascript"});
    }

    public Reader extractText(InputStream stream, String type, String encoding) throws IOException {
        try {
            if (encoding != null) {
                return new InputStreamReader(stream, encoding);
            }
        }
        catch (UnsupportedEncodingException e) {
            log.warn("Unsupported encoding '{}', using default ({}) instead.", (Object)encoding, (Object)System.getProperty("file.encoding"));
        }
        return new InputStreamReader(stream);
    }
}

