/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.extractor;

import com.openkm.core.Config;
import com.openkm.util.DocumentUtils;
import com.openkm.util.ExecutionUtils;
import com.openkm.util.FileUtils;
import com.openkm.util.TemplateUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.extractor.AbstractTextExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tesseract2TextExtractor
extends AbstractTextExtractor {
    private static final Logger log = LoggerFactory.getLogger(Tesseract2TextExtractor.class);

    public Tesseract2TextExtractor() {
        super(new String[]{"image/tiff"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader extractText(InputStream stream, String type, String encoding) throws IOException {
        File tmpFileIn = null;
        File tmpFilePre = null;
        File tmpFileOut = null;
        String cmd = null;
        if (!Config.SYSTEM_OCR.equals("")) {
            StringReader stringReader;
            try {
                tmpFileIn = File.createTempFile("okm", ".tif");
                tmpFilePre = File.createTempFile("okm", ".tif");
                tmpFileOut = File.createTempFile("okm", "");
                FileOutputStream fos = new FileOutputStream(tmpFileIn);
                IOUtils.copy((InputStream)stream, (OutputStream)fos);
                fos.close();
                HashMap<String, Object> hm = new HashMap<String, Object>();
                hm.put("fileIn", tmpFileIn.getPath());
                hm.put("fileOut", tmpFilePre.getPath());
                String tpl = Config.SYSTEM_IMAGEMAGICK_CONVERT + " -depth 8 -monochrome ${fileIn} ${fileOut}";
                cmd = TemplateUtils.replace("SYSTEM_IMG2PDF", tpl, hm);
                ExecutionUtils.runCmd(cmd);
                hm = new HashMap();
                hm.put("fileIn", tmpFilePre.getPath());
                hm.put("fileOut", tmpFileOut.getPath());
                cmd = TemplateUtils.replace("SYSTEM_OCR", Config.SYSTEM_OCR, hm);
                ExecutionUtils.runCmd(cmd);
                String text = IOUtils.toString((InputStream)new FileInputStream(tmpFileOut.getPath() + ".txt"));
                if (Config.SYSTEM_OPENOFFICE_DICTIONARY.equals("")) {
                    log.info("TEXT: {}", (Object)text);
                    StringReader stringReader2 = new StringReader(text);
                    return stringReader2;
                }
                text = DocumentUtils.spellChecker(text);
                log.info("TEXT: {}", (Object)text);
                StringReader stringReader3 = new StringReader(text);
                return stringReader3;
            }
            catch (SecurityException e) {
                log.warn("Security exception executing command: " + cmd, (Throwable)e);
                stringReader = new StringReader("");
                return stringReader;
            }
            catch (IOException e) {
                log.warn("IO exception executing command: " + cmd, (Throwable)e);
                stringReader = new StringReader("");
                return stringReader;
            }
            catch (InterruptedException e) {
                log.warn("Interrupted exception executing command: " + cmd, (Throwable)e);
                stringReader = new StringReader("");
                return stringReader;
            }
            catch (Exception e) {
                log.warn("Failed to extract OCR text", (Throwable)e);
                stringReader = new StringReader("");
                return stringReader;
            }
            finally {
                stream.close();
                FileUtils.deleteQuietly(tmpFileIn);
                FileUtils.deleteQuietly(tmpFilePre);
                FileUtils.deleteQuietly(tmpFileOut);
                FileUtils.deleteQuietly(new File(tmpFileOut.getPath() + ".txt"));
            }
        }
        log.warn("Undefined OCR application");
        return new StringReader("");
    }
}

