/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client;

import com.allen_sauer.gwt.log.client.DivLogger;
import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.InvocationException;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.rpc.StatusCodeException;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.bean.GWTFolder;
import com.openkm.frontend.client.bean.GWTUserConfig;
import com.openkm.frontend.client.bean.RepositoryContext;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.extension.event.HasLanguageEvent;
import com.openkm.frontend.client.extension.event.handler.LanguageHandlerExtension;
import com.openkm.frontend.client.extension.event.hashandler.HasLanguageHandlerExtension;
import com.openkm.frontend.client.panel.ExtendedDockPanel;
import com.openkm.frontend.client.service.OKMLanguageService;
import com.openkm.frontend.client.service.OKMLanguageServiceAsync;
import com.openkm.frontend.client.util.Location;
import com.openkm.frontend.client.util.Util;
import com.openkm.frontend.client.util.WindowUtils;
import com.openkm.frontend.client.util.WorkspaceUserProperties;
import com.openkm.frontend.client.widget.AboutPopup;
import com.openkm.frontend.client.widget.ConfirmPopup;
import com.openkm.frontend.client.widget.DebugConsolePopup;
import com.openkm.frontend.client.widget.Dragable;
import com.openkm.frontend.client.widget.ErrorPopup;
import com.openkm.frontend.client.widget.ExternalURLPopup;
import com.openkm.frontend.client.widget.LogoutPopup;
import com.openkm.frontend.client.widget.MsgPopup;
import com.openkm.frontend.client.widget.PropertyGroupPopup;
import com.openkm.frontend.client.widget.ReportPopup;
import com.openkm.frontend.client.widget.UserPopup;
import com.openkm.frontend.client.widget.WorkflowPopup;
import com.openkm.frontend.client.widget.chat.OnlineUsersPopup;
import com.openkm.frontend.client.widget.findfolder.FindFolderSelectPopup;
import com.openkm.frontend.client.widget.foldertree.FolderTree;
import com.openkm.frontend.client.widget.notify.NotifyPopup;
import com.openkm.frontend.client.widget.security.SecurityPopup;
import com.openkm.frontend.client.widget.startup.StartUp;
import com.openkm.frontend.client.widget.startup.StartUpPopup;
import com.openkm.frontend.client.widget.test.TestPopup;
import com.openkm.frontend.client.widget.upload.FileUploadPopup;
import com.openkm.frontend.client.widget.wizard.TemplateWizardPopup;
import com.openkm.frontend.client.widget.wizard.WizardPopup;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class Main
implements EntryPoint,
HasLanguageHandlerExtension,
HasLanguageEvent {
    public static String CONTEXT = "/OpenKM";
    private static Main singleton;
    private final OKMLanguageServiceAsync languageService = (OKMLanguageServiceAsync)GWT.create(OKMLanguageService.class);
    private List<String> extensionUuidList = new ArrayList<String>();
    public ExtendedDockPanel mainPanel;
    public StartUpPopup startUpPopup;
    public FileUploadPopup fileUpload;
    public ErrorPopup errorPopup;
    public ErrorPopup errorPopupLogout;
    public MsgPopup msgPopup;
    public ExternalURLPopup externalURLPopup;
    public LogoutPopup logoutPopup;
    public SecurityPopup securityPopup;
    public AboutPopup aboutPopup;
    public UserPopup userPopup;
    public ConfirmPopup confirmPopup;
    public Dragable dragable;
    public PropertyGroupPopup propertyGroupPopup;
    public WorkflowPopup workflowPopup;
    public NotifyPopup notifyPopup;
    public DebugConsolePopup debugConsolePopup;
    public FindFolderSelectPopup findFolderSelectPopup;
    public WizardPopup wizardPopup;
    public ReportPopup reportPopup;
    public TemplateWizardPopup templateWizardPopup;
    public OnlineUsersPopup onlineUsersPopup;
    public TestPopup testPopup;
    public WorkspaceUserProperties workspaceUserProperties;
    private String lang;
    private Map<String, String> hI18n;
    public Map<String, String> hPropertyGroupI18n;
    public String fldPath = "";
    public String docPath = "";
    public String taskInstanceId = "";
    public String refreshTasks = "";
    public GWTFolder taxonomyRootFolder;
    public GWTFolder categoriesRootFolder;
    public GWTFolder thesaurusRootFolder;
    public GWTFolder personalRootFolder;
    public GWTFolder templatesRootFolder;
    public GWTFolder mailRootFolder;
    public GWTFolder trashRootFolder;
    public GWTUserConfig userHome;
    public FolderTree activeFolderTree;
    public StartUp startUp;
    public Location loc;
    public RepositoryContext repositoryContext;
    public boolean windowClosing = false;
    List<LanguageHandlerExtension> langHandlerExtensionList;

    public static Main get() {
        return singleton;
    }

    public void onModuleLoad() {
        ((DivLogger)Log.getLogger(DivLogger.class)).getWidget().setVisible(false);
        Log.setUncaughtExceptionHandler();
        Log.setCurrentLogLevel((int)Integer.MAX_VALUE);
        singleton = this;
        this.langHandlerExtensionList = new ArrayList<LanguageHandlerExtension>();
        this.repositoryContext = new RepositoryContext();
        this.loc = WindowUtils.getLocation();
        CONTEXT = Cookies.getCookie((String)"ctx") != null && !Cookies.getCookie((String)"ctx").equals("") ? Cookies.getCookie((String)"ctx") : this.loc.getContext();
        if (this.loc.getParameter("docPath") != null && !this.loc.getParameter("docPath").equals("")) {
            this.docPath = this.loc.getParameter("docPath");
            this.fldPath = Util.getParent(this.docPath);
        } else if (this.loc.getParameter("fldPath") != null && !this.loc.getParameter("fldPath").equals("")) {
            this.fldPath = this.loc.getParameter("fldPath");
        } else if (this.loc.getParameter("taskInstanceId") != null && !this.loc.getParameter("taskInstanceId").equals("")) {
            this.taskInstanceId = this.loc.getParameter("taskInstanceId");
        } else if (this.loc.getParameter("refreshTasks") != null && !this.loc.getParameter("refreshTasks").equals("")) {
            this.refreshTasks = this.loc.getParameter("refreshTasks");
        }
        this.lang = this.loc.getParameter("lang") != null && !this.loc.getParameter("lang").equals("") ? this.loc.getParameter("lang") : (Cookies.getCookie((String)"lang") != null && !Cookies.getCookie((String)"lang").equals("") ? Cookies.getCookie((String)"lang") : Util.getBrowserLanguage());
        ServiceDefTarget endPoint = (ServiceDefTarget)this.languageService;
        endPoint.setServiceEntryPoint(RPCService.LanguageService);
        this.languageService.getFrontEndTranslations(Main.get().getLang(), new AsyncCallback<Map<String, String>>(){

            public void onSuccess(Map<String, String> result) {
                Main.this.hI18n = result;
                Main.this.onModuleLoad2();
            }

            public void onFailure(Throwable caught) {
                Window.alert((String)("Error getting translations: " + caught.getMessage()));
            }
        });
    }

    public void onModuleLoad2() {
        this.workspaceUserProperties = new WorkspaceUserProperties();
        this.userHome = new GWTUserConfig();
        this.mainPanel = new ExtendedDockPanel();
        this.startUpPopup = new StartUpPopup();
        this.startUpPopup.setWidth("300px");
        this.startUpPopup.setHeight("220px");
        this.startUpPopup.setStyleName("okm-Popup");
        this.startUpPopup.addStyleName("okm-DisableSelect");
        this.fileUpload = new FileUploadPopup();
        this.fileUpload.setStyleName("okm-Popup");
        this.errorPopup = new ErrorPopup(false);
        this.errorPopup.setStyleName("okm-Popup-Error");
        this.errorPopup.setWidth("380px");
        this.errorPopup.setHeight("205px");
        this.errorPopupLogout = new ErrorPopup(true);
        this.errorPopupLogout.setStyleName("okm-Popup-Error");
        this.errorPopupLogout.setWidth("300px");
        this.errorPopupLogout.setHeight("205px");
        this.msgPopup = new MsgPopup();
        this.msgPopup.setStyleName("okm-Popup");
        this.msgPopup.setWidth("300px");
        this.msgPopup.setHeight("205px");
        this.externalURLPopup = new ExternalURLPopup();
        this.externalURLPopup.setStyleName("okm-Popup");
        this.logoutPopup = new LogoutPopup();
        this.logoutPopup.setWidth("250");
        this.logoutPopup.setHeight("110");
        this.logoutPopup.setStyleName("okm-Popup");
        this.logoutPopup.addStyleName("okm-DisableSelect");
        this.securityPopup = new SecurityPopup();
        this.securityPopup.setWidth("600");
        this.securityPopup.setHeight("400");
        this.securityPopup.setStyleName("okm-Popup");
        this.securityPopup.addStyleName("okm-DisableSelect");
        this.aboutPopup = new AboutPopup();
        this.aboutPopup.setWidth("300px");
        this.aboutPopup.setHeight("220px");
        this.aboutPopup.setStyleName("okm-Popup");
        this.aboutPopup.addStyleName("okm-DisableSelect");
        this.userPopup = new UserPopup();
        this.userPopup.setWidth("400px");
        this.userPopup.setHeight("220px");
        this.userPopup.setStyleName("okm-Popup");
        this.confirmPopup = new ConfirmPopup();
        this.confirmPopup.setWidth("300px");
        this.confirmPopup.setHeight("125px");
        this.confirmPopup.setStyleName("okm-Popup");
        this.confirmPopup.addStyleName("okm-DisableSelect");
        this.dragable = new Dragable();
        this.propertyGroupPopup = new PropertyGroupPopup();
        this.propertyGroupPopup.setWidth("300px");
        this.propertyGroupPopup.setHeight("100px");
        this.propertyGroupPopup.setStyleName("okm-Popup");
        this.propertyGroupPopup.addStyleName("okm-DisableSelect");
        this.workflowPopup = new WorkflowPopup();
        this.workflowPopup.setWidth("300px");
        this.workflowPopup.setHeight("100px");
        this.workflowPopup.setStyleName("okm-Popup");
        this.workflowPopup.addStyleName("okm-DisableSelect");
        this.notifyPopup = new NotifyPopup();
        this.notifyPopup.setWidth("400px");
        this.notifyPopup.setHeight("100px");
        this.notifyPopup.setStyleName("okm-Popup");
        this.debugConsolePopup = new DebugConsolePopup();
        this.debugConsolePopup.setWidth("300px");
        this.debugConsolePopup.setHeight("100px");
        this.debugConsolePopup.setStyleName("okm-Popup");
        this.debugConsolePopup.addStyleName("okm-DisableSelect");
        this.findFolderSelectPopup = new FindFolderSelectPopup();
        this.findFolderSelectPopup.setWidth("400px");
        this.findFolderSelectPopup.setHeight("240px");
        this.findFolderSelectPopup.setStyleName("okm-Popup");
        this.findFolderSelectPopup.addStyleName("okm-DisableSelect");
        this.wizardPopup = new WizardPopup();
        this.wizardPopup.setWidth("400px");
        this.wizardPopup.setHeight("40px");
        this.wizardPopup.setStyleName("okm-Popup");
        this.wizardPopup.addStyleName("okm-DisableSelect");
        this.reportPopup = new ReportPopup();
        this.reportPopup.setWidth("250px");
        this.reportPopup.setHeight("40px");
        this.reportPopup.setStyleName("okm-Popup");
        this.reportPopup.addStyleName("okm-DisableSelect");
        this.templateWizardPopup = new TemplateWizardPopup();
        this.templateWizardPopup.setWidth("400px");
        this.templateWizardPopup.setHeight("40px");
        this.templateWizardPopup.setStyleName("okm-Popup");
        this.templateWizardPopup.addStyleName("okm-DisableSelect");
        this.onlineUsersPopup = new OnlineUsersPopup();
        this.onlineUsersPopup.setWidth("250px");
        this.onlineUsersPopup.setHeight("350px");
        this.onlineUsersPopup.setStyleName("okm-Popup");
        this.onlineUsersPopup.addStyleName("okm-DisableSelect");
        this.testPopup = new TestPopup();
        this.testPopup.setWidth("600px");
        this.testPopup.setHeight("500px");
        this.testPopup.setStyleName("okm-Popup");
        Window.enableScrolling((boolean)false);
        Window.setMargin((String)"0px");
        RootPanel.get().add((Widget)this.mainPanel);
        RootPanel.get().add((Widget)this.dragable);
        Window.addWindowClosingHandler((Window.ClosingHandler)new Window.ClosingHandler(){

            public void onWindowClosing(Window.ClosingEvent event) {
                Main.get().windowClosing = true;
                Main.this.startUp.keepAlive.cancel();
                Main.get().mainPanel.bottomPanel.userInfo.logoutChat();
            }
        });
        this.activeFolderTree = this.mainPanel.desktop.navigator.taxonomyTree;
        this.startUpPopup.show();
        this.startUp = new StartUp();
        this.startUp.init();
        this.initJavaScriptApi();
        this.mainPanel.topPanel.toolBar.initJavaScriptApi(this.mainPanel.topPanel.toolBar);
    }

    public void refreshLang(String lang) {
        this.lang = lang;
        ServiceDefTarget endPoint = (ServiceDefTarget)this.languageService;
        endPoint.setServiceEntryPoint(RPCService.LanguageService);
        this.languageService.getFrontEndTranslations(lang, new AsyncCallback<Map<String, String>>(){

            public void onSuccess(Map<String, String> result) {
                Main.this.hI18n = result;
                Main.this.fireEvent(HasLanguageEvent.LANGUAGE_CHANGED);
                Main.this.mainPanel.desktop.navigator.langRefresh();
                Main.this.mainPanel.topPanel.langRefresh();
                Main.this.mainPanel.desktop.browser.langRefresh();
                Main.this.mainPanel.search.historySearch.langRefresh();
                Main.this.mainPanel.search.searchBrowser.langRefresh();
                Main.this.mainPanel.bottomPanel.langRefresh();
                Main.this.mainPanel.dashboard.langRefresh();
                Main.this.fileUpload.langRefresh();
                Main.this.logoutPopup.langRefresh();
                Main.this.securityPopup.langRefresh();
                Main.this.aboutPopup.langRefresh();
                Main.this.userPopup.langRefresh();
                Main.this.confirmPopup.langRefresh();
                Main.this.msgPopup.langRefresh();
                Main.this.errorPopup.langRefresh();
                Main.this.errorPopupLogout.langRefresh();
                Main.this.externalURLPopup.langRefresh();
                Main.this.propertyGroupPopup.langRefresh();
                Main.this.workflowPopup.langRefresh();
                Main.this.notifyPopup.langRefresh();
                Main.this.debugConsolePopup.langRefresh();
                Main.this.findFolderSelectPopup.langRefresh();
                Main.this.wizardPopup.langRefresh();
                Main.this.wizardPopup.langRefresh();
                Main.this.reportPopup.langRefresh();
                Main.this.onlineUsersPopup.langRefresh();
                Main.this.mainPanel.desktop.navigator.taxonomyTree.langRefresh();
                Main.this.mainPanel.desktop.navigator.thesaurusTree.langRefresh();
                Main.this.mainPanel.desktop.navigator.personalTree.langRefresh();
                Main.this.mainPanel.desktop.navigator.templateTree.langRefresh();
                Main.this.mainPanel.desktop.navigator.trashTree.langRefresh();
                Main.this.mainPanel.desktop.navigator.thesaurusTree.thesaurusSelectPopup.langRefresh();
                Main.this.mainPanel.topPanel.toolBar.executeRefresh();
            }

            public void onFailure(Throwable caught) {
                Main.get().showError("getFrontEndTranslations", caught);
            }
        });
    }

    public void setLangMap(Map<String, String> hI18n) {
        this.hI18n = hI18n;
    }

    public String getLang() {
        return this.lang;
    }

    public void showError(String callback, Throwable caught) {
        this.startUp.recoverFromError();
        if (caught instanceof OKMException) {
            OKMException okme = (OKMException)caught;
            Log.error((String)("OKMException(" + callback + "): " + okme.getCode()));
            this.errorPopup.show(okme.getCode() + "(" + callback + "): " + Main.i18n(okme.getCode()) + "<br><br>" + okme.getMessage());
        } else if (caught instanceof InvocationException) {
            InvocationException ie = (InvocationException)caught;
            Log.error((String)("InvocationException(" + callback + "): " + ie));
            if (!Main.get().windowClosing) {
                this.errorPopup.show(Main.i18n("error.invocation") + " (" + callback + ")");
            }
        } else if (caught instanceof StatusCodeException) {
            StatusCodeException ie = (StatusCodeException)caught;
            Log.error((String)("StatusCodeException(" + callback + "): " + ie + " <br>HTTP status code error:" + ie.getStatusCode()));
            this.mainPanel.bottomPanel.setStatus("status.network.error.detected", true, ie.getStatusCode());
        } else {
            Log.error((String)("UnknownException(" + callback + "): " + caught.getMessage()));
            this.errorPopup.show(callback + ": " + caught.getMessage());
        }
    }

    public static String i18n(String property) {
        String ret = Main.get().hI18n.get("frontend." + property);
        if (ret == null) {
            ret = property;
        }
        return ret;
    }

    public String i18nExtension(String property) {
        String ret = Main.get().hI18n.get("extension." + property);
        if (ret == null) {
            ret = property;
        }
        return ret;
    }

    public List<String> getExtensionUuidList() {
        return this.extensionUuidList;
    }

    public void setExtensionUuidList(List<String> extensionUuidList) {
        this.extensionUuidList = extensionUuidList;
    }

    public String getUserName(String user) {
        String userName = user;
        if (this.workspaceUserProperties.getWorkspace() != null) {
            String un = this.workspaceUserProperties.getWorkspace().getUserNames().get(user);
            userName = un != null && !un.contentEquals("") ? un : user;
        }
        return userName;
    }

    @Override
    public void addLanguageHandlerExtension(LanguageHandlerExtension handlerExtension) {
        this.langHandlerExtensionList.add(handlerExtension);
    }

    @Override
    public void fireEvent(HasLanguageEvent.LanguageEventConstant event) {
        Iterator<LanguageHandlerExtension> it = this.langHandlerExtensionList.iterator();
        while (it.hasNext()) {
            it.next().onChange(event);
        }
    }

    native void initJavaScriptApi();
}

