/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.extension;

import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.extension.event.handler.DashboardHandlerExtension;
import com.openkm.frontend.client.extension.event.handler.DocumentHandlerExtension;
import com.openkm.frontend.client.extension.event.handler.FolderHandlerExtension;
import com.openkm.frontend.client.extension.event.handler.LanguageHandlerExtension;
import com.openkm.frontend.client.extension.event.handler.MailHandlerExtension;
import com.openkm.frontend.client.extension.event.handler.NavigatorHandlerExtension;
import com.openkm.frontend.client.extension.event.handler.PropertyGroupHandlerExtension;
import com.openkm.frontend.client.extension.event.handler.ToolBarHandlerExtension;
import com.openkm.frontend.client.extension.event.handler.WorkspaceHandlerExtension;
import com.openkm.frontend.client.extension.widget.menu.MenuItemExtension;
import com.openkm.frontend.client.extension.widget.preview.PreviewExtension;
import com.openkm.frontend.client.extension.widget.tabdocument.TabDocumentExtension;
import com.openkm.frontend.client.extension.widget.tabfolder.TabFolderExtension;
import com.openkm.frontend.client.extension.widget.tabmail.TabMailExtension;
import com.openkm.frontend.client.extension.widget.tabworkspace.TabWorkspaceExtension;
import com.openkm.frontend.client.extension.widget.toolbar.ToolBarBoxExtension;
import com.openkm.frontend.client.extension.widget.toolbar.ToolBarButtonExtension;
import com.openkm.frontend.client.extension.widget.userinfo.UserInfoExtension;
import java.util.List;

public class ExtensionManager {
    public static void start(List<Object> extensions) {
        for (Object obj : extensions) {
            if (obj instanceof TabDocumentExtension) {
                ExtensionManager.addTabDocumentExtension((TabDocumentExtension)obj);
            } else if (obj instanceof TabFolderExtension) {
                ExtensionManager.addTabFolderExtension((TabFolderExtension)obj);
            } else if (obj instanceof TabMailExtension) {
                ExtensionManager.addTabMailExtension((TabMailExtension)obj);
            } else if (obj instanceof ToolBarButtonExtension) {
                ExtensionManager.addToolBarButtonExtension((ToolBarButtonExtension)obj);
            } else if (obj instanceof MenuItemExtension) {
                ExtensionManager.addMenuExtension((MenuItemExtension)((Object)obj));
            } else if (obj instanceof TabWorkspaceExtension) {
                ExtensionManager.addWorkspaceExtension((TabWorkspaceExtension)obj);
            } else if (obj instanceof ToolBarBoxExtension) {
                ExtensionManager.addToolBarBoxExtension((ToolBarBoxExtension)obj);
            } else if (obj instanceof PreviewExtension) {
                ExtensionManager.addPreviewExtension((PreviewExtension)obj);
            } else if (obj instanceof UserInfoExtension) {
                ExtensionManager.addUserInfoExtension((UserInfoExtension)obj);
            }
            if (obj instanceof DocumentHandlerExtension) {
                ExtensionManager.addDocumentHandlerExtension((DocumentHandlerExtension)obj);
            }
            if (obj instanceof FolderHandlerExtension) {
                ExtensionManager.addFolderHandlerExtension((FolderHandlerExtension)obj);
            }
            if (obj instanceof MailHandlerExtension) {
                ExtensionManager.addMailHandlerExtension((MailHandlerExtension)obj);
            }
            if (obj instanceof ToolBarHandlerExtension) {
                ExtensionManager.addToolBarHandlerExtension((ToolBarHandlerExtension)obj);
            }
            if (obj instanceof LanguageHandlerExtension) {
                ExtensionManager.addLanguageHandlerExtension((LanguageHandlerExtension)obj);
            }
            if (obj instanceof NavigatorHandlerExtension) {
                ExtensionManager.addNavigatorHandlerExtension((NavigatorHandlerExtension)obj);
            }
            if (obj instanceof WorkspaceHandlerExtension) {
                ExtensionManager.addWorkspaceHandlerExtension((WorkspaceHandlerExtension)obj);
            }
            if (obj instanceof PropertyGroupHandlerExtension) {
                ExtensionManager.addPropertyGroupHandlerExtension((PropertyGroupHandlerExtension)obj);
            }
            if (!(obj instanceof DashboardHandlerExtension)) continue;
            ExtensionManager.addDashboardHandlerExtension((DashboardHandlerExtension)obj);
        }
    }

    private static void addTabDocumentExtension(TabDocumentExtension extension) {
        Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.addDocumentExtension(extension);
    }

    private static void addTabFolderExtension(TabFolderExtension extension) {
        Main.get().mainPanel.desktop.browser.tabMultiple.tabFolder.addFolderExtension(extension);
    }

    private static void addTabMailExtension(TabMailExtension extension) {
        Main.get().mainPanel.desktop.browser.tabMultiple.tabMail.addMailExtension(extension);
    }

    private static void addMenuExtension(MenuItemExtension extension) {
        switch (extension.getMenuLocation()) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                Main.get().mainPanel.topPanel.mainMenu.addMenuExtension(extension);
            }
        }
    }

    private static void addToolBarButtonExtension(ToolBarButtonExtension extension) {
        Main.get().mainPanel.topPanel.toolBar.addToolBarButtonExtension(extension);
    }

    private static void addWorkspaceExtension(TabWorkspaceExtension extension) {
        Main.get().mainPanel.topPanel.tabWorkspace.addWorkspaceExtension(extension);
    }

    private static void addToolBarBoxExtension(ToolBarBoxExtension extension) {
        Main.get().mainPanel.dashboard.addToolBarBoxExtension(extension);
    }

    private static void addPreviewExtension(PreviewExtension extension) {
        Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.addPreviewExtension(extension);
    }

    private static void addUserInfoExtension(UserInfoExtension extension) {
        Main.get().mainPanel.bottomPanel.userInfo.addUserInfoExtension(extension);
    }

    private static void addDocumentHandlerExtension(DocumentHandlerExtension handlerExtension) {
        Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.addDocumentHandlerExtension(handlerExtension);
        Main.get().mainPanel.desktop.browser.fileBrowser.addDocumentHandlerExtension(handlerExtension);
    }

    private static void addFolderHandlerExtension(FolderHandlerExtension handlerExtension) {
        Main.get().mainPanel.desktop.browser.tabMultiple.tabFolder.addFolderHandlerExtension(handlerExtension);
        Main.get().mainPanel.desktop.browser.fileBrowser.addFolderHandlerExtension(handlerExtension);
    }

    private static void addMailHandlerExtension(MailHandlerExtension handlerExtension) {
        Main.get().mainPanel.desktop.browser.tabMultiple.tabMail.addMailHandlerExtension(handlerExtension);
        Main.get().mainPanel.desktop.browser.fileBrowser.addMailHandlerExtension(handlerExtension);
    }

    private static void addToolBarHandlerExtension(ToolBarHandlerExtension handlerExtension) {
        Main.get().mainPanel.topPanel.toolBar.addToolBarHandlerExtension(handlerExtension);
    }

    private static void addLanguageHandlerExtension(LanguageHandlerExtension handlerExtension) {
        Main.get().addLanguageHandlerExtension(handlerExtension);
    }

    private static void addNavigatorHandlerExtension(NavigatorHandlerExtension handlerExtension) {
        Main.get().mainPanel.desktop.navigator.stackPanel.addNavigatorHandlerExtension(handlerExtension);
    }

    private static void addWorkspaceHandlerExtension(WorkspaceHandlerExtension handlerExtension) {
        Main.get().mainPanel.topPanel.tabWorkspace.addWorkspaceHandlerExtension(handlerExtension);
    }

    private static void addPropertyGroupHandlerExtension(PropertyGroupHandlerExtension handlerExtension) {
        Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.addPropertyGroupHandlerExtension(handlerExtension);
        Main.get().mainPanel.desktop.browser.tabMultiple.tabFolder.addPropertyGroupHandlerExtension(handlerExtension);
    }

    private static void addDashboardHandlerExtension(DashboardHandlerExtension handlerExtension) {
        Main.get().mainPanel.dashboard.addDashboardHandlerExtension(handlerExtension);
    }
}

