/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.panel.bottom;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.widget.UserInfo;
import java.util.Date;

public class BottomPanel
extends Composite {
    public static final int PANEL_HEIGHT = 25;
    private HorizontalPanel panel;
    private Label statusMsg;
    private SimplePanel spLeft;
    private SimplePanel spRight;
    public UserInfo userInfo = new UserInfo();
    private String key = "";
    private Timer removeStatus;
    private String aditionalErrorMsg = "";

    public BottomPanel() {
        this.panel = new HorizontalPanel();
        this.spLeft = new SimplePanel();
        this.spRight = new SimplePanel();
        this.statusMsg = new Label("");
        this.statusMsg.setStyleName("okm-Input");
        this.statusMsg.setSize("340", "15");
        this.statusMsg.setHorizontalAlignment(HasAlignment.ALIGN_LEFT);
        this.spLeft.setWidth("10");
        this.spRight.setWidth("10");
        this.panel.add((Widget)this.spLeft);
        this.panel.add((Widget)this.userInfo);
        this.panel.add((Widget)this.statusMsg);
        this.panel.add((Widget)this.spRight);
        this.panel.setCellWidth((Widget)this.spLeft, "10");
        this.panel.setCellWidth((Widget)this.spRight, "10");
        this.panel.setCellHorizontalAlignment((Widget)this.userInfo, HasAlignment.ALIGN_LEFT);
        this.panel.setCellHorizontalAlignment((Widget)this.statusMsg, HasAlignment.ALIGN_RIGHT);
        this.panel.setCellHorizontalAlignment((Widget)this.spRight, HasAlignment.ALIGN_RIGHT);
        this.panel.setCellVerticalAlignment((Widget)this.userInfo, HasAlignment.ALIGN_MIDDLE);
        this.panel.setCellVerticalAlignment((Widget)this.statusMsg, HasAlignment.ALIGN_MIDDLE);
        this.panel.setStyleName("okm-bottomPanel");
        this.panel.addStyleName("okm-DisableSelect");
        this.panel.setHorizontalAlignment(VerticalPanel.ALIGN_LEFT);
        this.panel.setSize("100%", "100%");
        this.initWidget((Widget)this.panel);
    }

    public void setSize(int width, int height) {
        this.panel.setSize("" + width, "" + height);
    }

    public void setStatus(String msg) {
        this.aditionalErrorMsg = "";
        if (this.removeStatus != null) {
            this.removeStatus.cancel();
            this.removeStatus = null;
        }
        this.statusMsg.removeStyleName("okm-Input-Error");
        this.statusMsg.setText(msg);
    }

    public void setStatus(String key, boolean error) {
        this.key = key;
        this.aditionalErrorMsg = "";
        if (this.removeStatus != null) {
            this.removeStatus.cancel();
            this.removeStatus = null;
        }
        if (error) {
            this.statusMsg.addStyleName("okm-Input-Error");
            DateTimeFormat dtf = DateTimeFormat.getFormat((String)Main.i18n("general.hour.pattern"));
            this.aditionalErrorMsg = " - " + dtf.format(new Date());
            this.removeStatus = new Timer(){

                public void run() {
                    BottomPanel.this.resetStatus();
                }
            };
            this.removeStatus.schedule(120000);
        } else {
            this.statusMsg.removeStyleName("okm-Input-Error");
        }
        this.statusMsg.setText(" " + Main.i18n(key) + this.aditionalErrorMsg);
    }

    public void setStatus(String key, boolean error, int errorCode) {
        this.key = key;
        this.aditionalErrorMsg = "";
        if (this.removeStatus != null) {
            this.removeStatus.cancel();
            this.removeStatus = null;
        }
        if (error) {
            this.statusMsg.addStyleName("okm-Input-Error");
            DateTimeFormat dtf = DateTimeFormat.getFormat((String)Main.i18n("general.hour.pattern"));
            this.aditionalErrorMsg = " (" + errorCode + ") - " + dtf.format(new Date());
            this.removeStatus = new Timer(){

                public void run() {
                    BottomPanel.this.resetStatus();
                }
            };
            this.removeStatus.schedule(120000);
        } else {
            this.statusMsg.removeStyleName("okm-Input-Error");
        }
        this.statusMsg.setText(" " + Main.i18n(key) + this.aditionalErrorMsg);
    }

    public void resetStatus() {
        this.statusMsg.setText("");
        this.statusMsg.removeStyleName("okm-Input-Error");
    }

    public void langRefresh() {
        this.statusMsg.setText(" " + Main.i18n(this.key) + this.aditionalErrorMsg);
        this.userInfo.langRefresh();
    }
}

