/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.panel.center;

import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.panel.center.VerticalSplitPanelExtended;
import com.openkm.frontend.client.util.Util;
import com.openkm.frontend.client.widget.filebrowser.FileBrowser;
import com.openkm.frontend.client.widget.properties.TabMultiple;

public class Browser
extends Composite {
    private static final int IE_SIZE_RECTIFICATION = Util.getUserAgent().startsWith("ie") ? 2 : 0;
    private static final int SPLITTER_HEIGHT = 10;
    private VerticalSplitPanelExtended verticalSplitPanel = new VerticalSplitPanelExtended();
    private VerticalPanel tabPropertiesPanel;
    public FileBrowser fileBrowser = new FileBrowser();
    public TabMultiple tabMultiple;
    private boolean isResizeInProgress = false;
    public int width = 0;
    public int height = 0;
    public int topHeight = 0;
    public int bottomHeight = 0;

    public Browser() {
        this.tabPropertiesPanel = new VerticalPanel();
        this.tabMultiple = new TabMultiple();
        this.tabPropertiesPanel.add((Widget)this.tabMultiple);
        this.tabPropertiesPanel.setStyleName("okm-Properties-Tab");
        this.verticalSplitPanel.getSplitPanel().setTopWidget((Widget)this.fileBrowser);
        this.verticalSplitPanel.getSplitPanel().setBottomWidget((Widget)this.tabPropertiesPanel);
        this.verticalSplitPanel.addMouseMoveHandler(new MouseMoveHandler(){

            public void onMouseMove(MouseMoveEvent event) {
                if (Browser.this.verticalSplitPanel.getSplitPanel().isResizing() && !Browser.this.isResizeInProgress) {
                    Browser.this.isResizeInProgress = true;
                    Browser.this.onSplitResize();
                }
            }
        });
        this.verticalSplitPanel.addMouseUpHandler(new MouseUpHandler(){

            public void onMouseUp(MouseUpEvent event) {
                if (Browser.this.isResizeInProgress) {
                    Browser.this.isResizeInProgress = false;
                }
            }
        });
        this.initWidget((Widget)this.verticalSplitPanel);
    }

    public void onSplitResize() {
        int resizeUpdatePeriod = 20;
        if (this.isResizeInProgress) {
            new Timer(){

                public void run() {
                    Browser.this.resizePanels();
                    if (Browser.this.isResizeInProgress) {
                        Browser.this.onSplitResize();
                    } else if (Util.getUserAgent().equals("chrome")) {
                        new Timer(){

                            public void run() {
                                Browser.this.resizePanels();
                            }
                        }.schedule(250);
                    }
                }
            }.schedule(20);
        }
    }

    public void langRefresh() {
        this.fileBrowser.langRefresh();
        this.tabMultiple.langRefresh();
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.topHeight = (height - 10) / 2;
        this.bottomHeight = height - (this.topHeight + 10);
        this.verticalSplitPanel.setPixelSize(width, height);
        this.verticalSplitPanel.getSplitPanel().setSplitPosition("" + this.topHeight);
        this.resize();
    }

    private void resize() {
        this.verticalSplitPanel.setWidth("" + this.width);
        this.fileBrowser.setPixelSize(this.width, this.topHeight);
        this.fileBrowser.table.setPixelSize(this.width - 2 + IE_SIZE_RECTIFICATION, this.topHeight - 2 - 26 + IE_SIZE_RECTIFICATION);
        this.fileBrowser.table.fillWidth();
        this.tabMultiple.setPixelSize(this.width - 2, this.bottomHeight - 2);
        this.tabPropertiesPanel.setPixelSize(this.width, this.bottomHeight);
    }

    public void setWidth(int width) {
        this.width = width;
        if (Util.getUserAgent().equals("chrome") && this.topHeight - 15 > 0 && this.bottomHeight - 15 > 0 && this.width - 15 > 0) {
            this.topHeight -= 15;
            this.bottomHeight -= 15;
            this.width -= 15;
            this.resize();
            this.topHeight += 15;
            this.bottomHeight += 15;
            this.width += 15;
        }
        this.resize();
    }

    private void resizePanels() {
        int total = this.verticalSplitPanel.getOffsetHeight();
        String value = DOM.getStyleAttribute((Element)DOM.getChild((Element)DOM.getChild((Element)this.verticalSplitPanel.getSplitPanel().getElement(), (int)0), (int)0), (String)"height");
        if (value.contains("px")) {
            value = value.substring(0, value.indexOf("px"));
        }
        this.topHeight = Integer.parseInt(value);
        value = DOM.getStyleAttribute((Element)DOM.getChild((Element)DOM.getChild((Element)this.verticalSplitPanel.getSplitPanel().getElement(), (int)0), (int)2), (String)"top");
        if (value.contains("px")) {
            value = value.substring(0, value.indexOf("px"));
        }
        this.bottomHeight = total - Integer.parseInt(value);
        if (Util.getUserAgent().equals("chrome") && this.topHeight - 15 > 0 && this.bottomHeight - 15 > 0 && this.width - 15 > 0) {
            this.topHeight -= 15;
            this.bottomHeight -= 15;
            this.width -= 15;
            this.resize();
            this.topHeight += 15;
            this.bottomHeight += 15;
            this.width += 15;
        }
        this.resize();
    }

    public void refreshSpliterAfterAdded() {
        this.verticalSplitPanel.getSplitPanel().setSplitPosition("" + this.topHeight);
        if (Util.getUserAgent().equals("chrome")) {
            new Timer(){

                public void run() {
                    Browser.this.resizePanels();
                }
            }.schedule(250);
        }
    }
}

