/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.panel.center;

import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.extension.event.HasDashboardEvent;
import com.openkm.frontend.client.extension.event.handler.DashboardHandlerExtension;
import com.openkm.frontend.client.extension.event.hashandler.HasDashboardHandlerExtension;
import com.openkm.frontend.client.extension.widget.toolbar.ToolBarBoxExtension;
import com.openkm.frontend.client.widget.dashboard.GeneralDashboard;
import com.openkm.frontend.client.widget.dashboard.HorizontalToolBar;
import com.openkm.frontend.client.widget.dashboard.MailDashboard;
import com.openkm.frontend.client.widget.dashboard.NewsDashboard;
import com.openkm.frontend.client.widget.dashboard.UserDashboard;
import com.openkm.frontend.client.widget.dashboard.keymap.KeyMapDashboard;
import com.openkm.frontend.client.widget.dashboard.workflow.WorkflowDashboard;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Dashboard
extends Composite
implements HasDashboardHandlerExtension,
HasDashboardEvent {
    private boolean userVisible = false;
    private boolean mailVisible = false;
    private boolean newsVisible = false;
    private boolean generalVisible = false;
    private boolean workflowVisible = false;
    private boolean keywordsVisible = false;
    public static final int DASHBOARD_NONE = -1;
    public static final int DASHBOARD_USER = 1;
    public static final int DASHBOARD_MAIL = 2;
    public static final int DASHBOARD_NEWS = 3;
    public static final int DASHBOARD_GENERAL = 4;
    public static final int DASHBOARD_WORKFLOW = 5;
    public static final int DASHBOARD_KEYMAP = 6;
    public static final int DASHBOARD_EXTENSION = 7;
    private VerticalPanel panel;
    private SimplePanel sp;
    private ScrollPanel scrollPanel;
    public HorizontalToolBar horizontalToolBar;
    public UserDashboard userDashboard;
    public MailDashboard mailDashboard;
    public NewsDashboard newsDashboard;
    public GeneralDashboard generalDashboard;
    public WorkflowDashboard workflowDashboard;
    public KeyMapDashboard keyMapDashboard;
    private Widget actualWidgetExtension;
    private int actualView = -1;
    Timer dashboardRefreshing;
    List<ToolBarBoxExtension> toolBarBoxExtensionList = new ArrayList<ToolBarBoxExtension>();
    List<DashboardHandlerExtension> dashboardHandlerExtensionList = new ArrayList<DashboardHandlerExtension>();
    private int width = 0;
    private int height = 0;

    public Dashboard() {
        this.panel = new VerticalPanel();
        this.sp = new SimplePanel();
        this.userDashboard = new UserDashboard();
        this.mailDashboard = new MailDashboard();
        this.scrollPanel = new ScrollPanel();
        this.horizontalToolBar = new HorizontalToolBar();
        this.newsDashboard = new NewsDashboard();
        this.generalDashboard = new GeneralDashboard();
        this.workflowDashboard = new WorkflowDashboard();
        this.keyMapDashboard = new KeyMapDashboard();
        this.sp.add((Widget)this.scrollPanel);
        this.panel.add((Widget)this.horizontalToolBar);
        this.panel.add((Widget)this.sp);
        this.sp.setStyleName("okm-Input");
        this.initWidget((Widget)this.panel);
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.panel.setPixelSize(width - 2, height - 2);
        this.panel.setCellHeight((Widget)this.sp, "" + (height - 60 - 2));
        this.panel.setCellHeight((Widget)this.horizontalToolBar, "60");
        this.sp.setPixelSize(width - 2, height - 60 - 2);
        this.scrollPanel.setPixelSize(width - 2, height - 62);
        this.userDashboard.setWidth(width - 2);
        this.mailDashboard.setWidth(width - 2);
        this.newsDashboard.setWidth(width - 2);
        this.generalDashboard.setWidth(width - 2);
        this.workflowDashboard.setWidth(width - 2);
        this.keyMapDashboard.setSize("" + (width - 2), "" + (height - 62));
        this.horizontalToolBar.setHeight("60");
        this.horizontalToolBar.setWidth("100%");
        Iterator<ToolBarBoxExtension> it = this.toolBarBoxExtensionList.iterator();
        while (it.hasNext()) {
            it.next().getWidget().setPixelSize(width - 2, height - 62);
        }
        this.newsDashboard.getUserSearchs(true);
    }

    public void langRefresh() {
        this.userDashboard.langRefresh();
        this.mailDashboard.langRefresh();
        this.horizontalToolBar.langRefresh();
        this.generalDashboard.langRefresh();
        this.newsDashboard.langRefresh();
        this.workflowDashboard.langRefresh();
        this.keyMapDashboard.langRefresh();
    }

    public void changeView(int view) {
        switch (this.actualView) {
            case 1: {
                this.scrollPanel.remove((Widget)this.userDashboard);
                break;
            }
            case 2: {
                this.scrollPanel.remove((Widget)this.mailDashboard);
                break;
            }
            case 3: {
                this.scrollPanel.remove((Widget)this.newsDashboard);
                break;
            }
            case 4: {
                this.scrollPanel.remove((Widget)this.generalDashboard);
                break;
            }
            case 5: {
                this.scrollPanel.remove((Widget)this.workflowDashboard);
                break;
            }
            case 6: {
                this.scrollPanel.remove((Widget)this.keyMapDashboard);
                break;
            }
            case 7: {
                this.scrollPanel.remove(this.actualWidgetExtension);
            }
        }
        switch (view) {
            case 1: {
                this.scrollPanel.add((Widget)this.userDashboard);
                break;
            }
            case 2: {
                this.scrollPanel.add((Widget)this.mailDashboard);
                break;
            }
            case 3: {
                this.scrollPanel.add((Widget)this.newsDashboard);
                break;
            }
            case 4: {
                this.scrollPanel.add((Widget)this.generalDashboard);
                break;
            }
            case 5: {
                this.scrollPanel.add((Widget)this.workflowDashboard);
                break;
            }
            case 6: {
                this.scrollPanel.add((Widget)this.keyMapDashboard);
                break;
            }
            case 7: {
                this.actualWidgetExtension = this.toolBarBoxExtensionList.get(this.horizontalToolBar.getSelectedExtension()).getWidget();
                this.scrollPanel.add(this.actualWidgetExtension);
            }
        }
        this.actualView = view;
        this.fireEvent(HasDashboardEvent.TOOLBOX_CHANGED);
    }

    public boolean isWidgetExtensionVisible(Widget widget) {
        return this.actualView == 7 && this.actualWidgetExtension.equals(widget);
    }

    public void refreshAll() {
        this.userDashboard.refreshAll();
        this.mailDashboard.refreshAll();
        this.newsDashboard.refreshAllSearchs();
        this.generalDashboard.refreshAll();
        this.workflowDashboard.refreshAll();
        this.keyMapDashboard.refreshAll();
        this.fireEvent(HasDashboardEvent.DASHBOARD_REFRESH);
    }

    public void startRefreshingDashboard(double scheduleTime) {
        this.dashboardRefreshing = new Timer(){

            public void run() {
                Dashboard.this.refreshAll();
            }
        };
        this.dashboardRefreshing.scheduleRepeating(new Double(scheduleTime).intValue());
    }

    public void showUser() {
        this.userVisible = true;
        this.horizontalToolBar.showUser();
    }

    public void showMail() {
        this.mailVisible = true;
        this.horizontalToolBar.showMail();
    }

    public void showNews() {
        this.newsVisible = true;
        this.horizontalToolBar.showNews();
    }

    public void showGeneral() {
        this.generalVisible = true;
        this.horizontalToolBar.showGeneral();
    }

    public void showWorkflow() {
        this.workflowVisible = true;
        this.horizontalToolBar.showWorkflow();
    }

    public void showKeywords() {
        this.keywordsVisible = true;
        this.horizontalToolBar.showKeywords();
    }

    public void init() {
        if (this.userVisible) {
            this.changeView(1);
        } else if (this.mailVisible) {
            this.changeView(2);
        } else if (this.newsVisible) {
            this.changeView(3);
        } else if (this.generalVisible) {
            this.changeView(4);
        } else if (this.workflowVisible) {
            this.changeView(5);
        } else if (this.keywordsVisible) {
            this.changeView(6);
        } else if (!this.toolBarBoxExtensionList.isEmpty()) {
            this.changeView(7);
        }
        this.horizontalToolBar.init();
    }

    public void addToolBarBoxExtension(ToolBarBoxExtension extension) {
        this.toolBarBoxExtensionList.add(extension);
        this.horizontalToolBar.addToolBarBoxExtension(extension);
        extension.getWidget().setPixelSize(this.width - 2, this.height - 62);
    }

    @Override
    public void addDashboardHandlerExtension(DashboardHandlerExtension handlerExtension) {
        this.dashboardHandlerExtensionList.add(handlerExtension);
    }

    @Override
    public void fireEvent(HasDashboardEvent.DashboardEventConstant event) {
        for (DashboardHandlerExtension handlerExtension : this.dashboardHandlerExtensionList) {
            handlerExtension.onChange(event);
        }
    }
}

