/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.panel.center;

import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.panel.center.HorizontalSplitPanelExtended;
import com.openkm.frontend.client.panel.center.SearchBrowser;
import com.openkm.frontend.client.panel.left.HistorySearch;
import com.openkm.frontend.client.util.Util;

public class Search
extends Composite {
    private static final int PANEL_LEFT_WIDTH = 225;
    public static final int SPLITTER_WIDTH = 10;
    private HorizontalSplitPanelExtended horizontalSplitPanel = new HorizontalSplitPanelExtended();
    public HistorySearch historySearch = new HistorySearch();
    public SearchBrowser searchBrowser = new SearchBrowser();
    private boolean isResizeInProgress = false;
    private int width = 0;
    private int height = 0;
    private int left = 225;
    private int right = 0;

    public Search() {
        this.horizontalSplitPanel.getSplitPanel().setLeftWidget((Widget)this.historySearch);
        this.horizontalSplitPanel.getSplitPanel().setRightWidget((Widget)this.searchBrowser);
        this.horizontalSplitPanel.getSplitPanel().setSplitPosition("225");
        this.horizontalSplitPanel.addMouseMoveHandler(new MouseMoveHandler(){

            public void onMouseMove(MouseMoveEvent event) {
                if (Search.this.horizontalSplitPanel.getSplitPanel().isResizing() && !Search.this.isResizeInProgress) {
                    Search.this.isResizeInProgress = true;
                    Search.this.onSplitResize();
                }
            }
        });
        this.horizontalSplitPanel.addMouseUpHandler(new MouseUpHandler(){

            public void onMouseUp(MouseUpEvent event) {
                if (Search.this.isResizeInProgress) {
                    Search.this.isResizeInProgress = false;
                }
            }
        });
        this.initWidget((Widget)this.horizontalSplitPanel);
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.left = (int)((double)width * 0.2);
        this.left = this.left < 225 ? 225 : this.left;
        this.right = width - (this.left + 10);
        this.horizontalSplitPanel.setPixelSize(width, height);
        this.historySearch.setSize(this.left, height);
        this.searchBrowser.setSize(this.right, height);
        this.horizontalSplitPanel.getSplitPanel().setSplitPosition("" + this.left);
    }

    public void onSplitResize() {
        int resizeUpdatePeriod = 20;
        if (this.isResizeInProgress) {
            new Timer(){

                public void run() {
                    Search.this.resizePanels();
                    if (Search.this.isResizeInProgress) {
                        Search.this.onSplitResize();
                    } else if (Util.getUserAgent().equals("chrome")) {
                        new Timer(){

                            public void run() {
                                Search.this.resizePanels();
                            }
                        }.schedule(250);
                    }
                }
            }.schedule(20);
        }
    }

    private void resizePanels() {
        int total = 0;
        this.left = 0;
        this.right = 0;
        String value = DOM.getStyleAttribute((Element)this.horizontalSplitPanel.getSplitPanel().getElement(), (String)"width");
        if (value.contains("px")) {
            value = value.substring(0, value.indexOf("px"));
        }
        total = Integer.parseInt(value);
        value = DOM.getStyleAttribute((Element)DOM.getChild((Element)DOM.getChild((Element)this.horizontalSplitPanel.getSplitPanel().getElement(), (int)0), (int)0), (String)"width");
        if (value.contains("px")) {
            value = value.substring(0, value.indexOf("px"));
        }
        this.left = Integer.parseInt(value);
        value = DOM.getStyleAttribute((Element)DOM.getChild((Element)DOM.getChild((Element)this.horizontalSplitPanel.getSplitPanel().getElement(), (int)0), (int)2), (String)"left");
        if (value.contains("px")) {
            value = value.substring(0, value.indexOf("px"));
        }
        this.right = total - Integer.parseInt(value);
        if (Util.getUserAgent().equals("chrome") && this.left - 15 > 0 && this.height - 15 > 0 && this.right - 15 > 0) {
            this.historySearch.setSize(this.left - 15, this.height - 15);
            this.searchBrowser.setWidth(this.right - 15);
        }
        this.historySearch.setSize(this.left, this.height);
        this.searchBrowser.setWidth(this.right);
    }

    public void refreshSpliterAfterAdded() {
        this.horizontalSplitPanel.getSplitPanel().setSplitPosition("" + this.left);
        this.searchBrowser.refreshSpliterAfterAdded();
        if (Util.getUserAgent().equals("chrome")) {
            new Timer(){

                public void run() {
                    Search.this.resizePanels();
                }
            }.schedule(250);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLeft() {
        return this.left;
    }

    public int getRight() {
        return this.right;
    }
}

