/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.panel.center;

import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.panel.center.VerticalSplitPanelExtended;
import com.openkm.frontend.client.util.Util;
import com.openkm.frontend.client.widget.searchin.SearchIn;
import com.openkm.frontend.client.widget.searchresult.SearchResult;

public class SearchBrowser
extends Composite {
    private static final int PANEL_TOP_HEIGHT = 210;
    public static final int SPLITTER_HEIGHT = 10;
    private VerticalSplitPanelExtended verticalSplitPanel = new VerticalSplitPanelExtended();
    public SearchIn searchIn = new SearchIn();
    public SearchResult searchResult = new SearchResult();
    private boolean isResizeInProgress = false;
    public int width = 0;
    public int height = 0;
    public int topHeight = 0;
    public int bottomHeight = 0;

    public SearchBrowser() {
        this.verticalSplitPanel.getSplitPanel().setTopWidget((Widget)this.searchIn);
        this.verticalSplitPanel.getSplitPanel().setBottomWidget((Widget)this.searchResult);
        this.verticalSplitPanel.addMouseMoveHandler(new MouseMoveHandler(){

            public void onMouseMove(MouseMoveEvent event) {
                if (SearchBrowser.this.verticalSplitPanel.getSplitPanel().isResizing() && !SearchBrowser.this.isResizeInProgress) {
                    SearchBrowser.this.isResizeInProgress = true;
                    SearchBrowser.this.onSplitResize();
                }
            }
        });
        this.verticalSplitPanel.addMouseUpHandler(new MouseUpHandler(){

            public void onMouseUp(MouseUpEvent event) {
                if (SearchBrowser.this.isResizeInProgress) {
                    SearchBrowser.this.isResizeInProgress = false;
                }
            }
        });
        this.searchIn.setStyleName("okm-Input");
        this.initWidget((Widget)this.verticalSplitPanel);
    }

    public void onSplitResize() {
        int resizeUpdatePeriod = 20;
        if (this.isResizeInProgress) {
            new Timer(){

                public void run() {
                    SearchBrowser.this.resizePanels();
                    if (SearchBrowser.this.isResizeInProgress) {
                        SearchBrowser.this.onSplitResize();
                    } else if (Util.getUserAgent().equals("chrome")) {
                        new Timer(){

                            public void run() {
                                SearchBrowser.this.resizePanels();
                            }
                        }.schedule(250);
                    }
                }
            }.schedule(20);
        }
    }

    public void langRefresh() {
        this.searchIn.langRefresh();
        this.searchResult.langRefresh();
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.topHeight = 210;
        this.bottomHeight = height - (this.topHeight + 10);
        this.verticalSplitPanel.setSize("" + width, "" + height);
        this.verticalSplitPanel.getSplitPanel().setSplitPosition("" + this.topHeight);
        this.resize();
    }

    private void resize() {
        this.verticalSplitPanel.setWidth("" + this.width);
        this.searchIn.setSize(this.width, this.topHeight);
        this.searchResult.setPixelSize(this.width - 2, this.bottomHeight - 2);
    }

    private void resizePanels() {
        int total = this.verticalSplitPanel.getOffsetHeight();
        String value = DOM.getStyleAttribute((Element)DOM.getChild((Element)DOM.getChild((Element)this.verticalSplitPanel.getSplitPanel().getElement(), (int)0), (int)0), (String)"height");
        if (value.contains("px")) {
            value = value.substring(0, value.indexOf("px"));
        }
        this.topHeight = Integer.parseInt(value);
        value = DOM.getStyleAttribute((Element)DOM.getChild((Element)DOM.getChild((Element)this.verticalSplitPanel.getSplitPanel().getElement(), (int)0), (int)2), (String)"top");
        if (value.contains("px")) {
            value = value.substring(0, value.indexOf("px"));
        }
        this.bottomHeight = total - Integer.parseInt(value);
        if (Util.getUserAgent().equals("chrome") && this.topHeight - 15 > 0 && this.bottomHeight - 15 > 0 && this.width - 15 > 0) {
            this.topHeight -= 15;
            this.bottomHeight -= 15;
            this.width -= 15;
            this.resize();
            this.topHeight += 15;
            this.bottomHeight += 15;
            this.width += 15;
        }
        this.resize();
    }

    public void setWidth(int width) {
        this.width = width;
        if (Util.getUserAgent().equals("chrome") && this.topHeight - 15 > 0 && this.bottomHeight - 15 > 0 && this.width - 15 > 0) {
            this.topHeight -= 15;
            this.bottomHeight -= 15;
            this.width -= 15;
            this.resize();
            this.topHeight += 15;
            this.bottomHeight += 15;
            this.width += 15;
        }
        this.resize();
    }

    public void refreshSpliterAfterAdded() {
        this.verticalSplitPanel.getSplitPanel().setSplitPosition("" + this.topHeight);
        if (Util.getUserAgent().equals("chrome")) {
            new Timer(){

                public void run() {
                    SearchBrowser.this.resizePanels();
                }
            }.schedule(250);
        }
    }
}

