/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.util;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTWorkspace;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMRepositoryService;
import com.openkm.frontend.client.service.OKMRepositoryServiceAsync;
import com.openkm.frontend.client.service.OKMWorkspaceService;
import com.openkm.frontend.client.service.OKMWorkspaceServiceAsync;
import com.openkm.frontend.client.util.Util;

public class WorkspaceUserProperties {
    private final OKMRepositoryServiceAsync repositoryService = (OKMRepositoryServiceAsync)GWT.create(OKMRepositoryService.class);
    private final OKMWorkspaceServiceAsync workspaceService = (OKMWorkspaceServiceAsync)GWT.create(OKMWorkspaceService.class);
    private GWTWorkspace workspace;
    private String user = "";
    private String applicationURL = "";
    private String msg = "";
    final AsyncCallback<String> callbackGetUpdateMessage = new AsyncCallback<String>(){

        public void onSuccess(String result) {
            WorkspaceUserProperties.this.msg = result;
            Main.get().mainPanel.bottomPanel.userInfo.setUpdateMessage(WorkspaceUserProperties.this.msg);
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("RemoteUser", caught);
        }
    };
    final AsyncCallback<GWTWorkspace> callbackGetUserWorkspace = new AsyncCallback<GWTWorkspace>(){

        public void onSuccess(GWTWorkspace result) {
            WorkspaceUserProperties.this.workspace = result;
            WorkspaceUserProperties.this.user = result.getUser();
            WorkspaceUserProperties.this.applicationURL = result.getApplicationURL();
            Util.changeCss(WorkspaceUserProperties.this.workspace.getWebSkin());
            Main.get().mainPanel.bottomPanel.userInfo.setUser(WorkspaceUserProperties.this.user, result.isTabAdminVisible());
            if (result.isChatEnabled()) {
                Main.get().mainPanel.bottomPanel.userInfo.enableChat();
                if (result.isChatAutoLogin()) {
                    Main.get().mainPanel.bottomPanel.userInfo.loginChat(true);
                }
            }
            if (result.isUserQuotaEnabled() && result.getUserQuotaLimit() > 0L) {
                Main.get().mainPanel.bottomPanel.userInfo.enableUserQuota(WorkspaceUserProperties.this.workspace.getUserQuotaLimit());
            }
            Main.get().mainPanel.bottomPanel.userInfo.showExtensions();
            Main.get().aboutPopup.setAppVersion(result.getAppVersion());
            WorkspaceUserProperties.this.getUserDocumentsSize();
            Main.get().startUp.startKeepAlive(WorkspaceUserProperties.this.workspace.getKeepAliveSchedule());
            Main.get().mainPanel.dashboard.startRefreshingDashboard(WorkspaceUserProperties.this.workspace.getDashboardSchedule());
            if (WorkspaceUserProperties.this.workspace.isAdvancedFilters()) {
                Main.get().securityPopup.enableAdvancedFilter();
                Main.get().fileUpload.enableAdvancedFilter();
                Main.get().notifyPopup.enableAdvancedFilter();
            }
            Main.get().mainPanel.topPanel.mainMenu.setFileMenuVisible(WorkspaceUserProperties.this.workspace.isMenuFileVisible());
            Main.get().mainPanel.topPanel.mainMenu.setEditMenuVisible(WorkspaceUserProperties.this.workspace.isMenuEditVisible());
            Main.get().mainPanel.topPanel.mainMenu.setToolsMenuVisible(WorkspaceUserProperties.this.workspace.isMenuToolsVisible());
            Main.get().mainPanel.topPanel.mainMenu.setBookmarkMenuVisible(WorkspaceUserProperties.this.workspace.isMenuBookmarksVisible());
            Main.get().mainPanel.topPanel.mainMenu.setHelpMenuVisible(WorkspaceUserProperties.this.workspace.isMenuHelpVisible());
            Main.get().mainPanel.topPanel.mainMenu.initAvailableLanguage(WorkspaceUserProperties.this.workspace.getLangs());
            Main.get().mainPanel.topPanel.toolBar.setAvailableOption(WorkspaceUserProperties.this.workspace.getProfileToolbar());
            boolean refreshTab = false;
            if (WorkspaceUserProperties.this.workspace.isTabDesktopVisible()) {
                Main.get().mainPanel.topPanel.tabWorkspace.showDesktop();
                refreshTab = true;
            }
            if (WorkspaceUserProperties.this.workspace.isTabSearchVisible()) {
                Main.get().mainPanel.topPanel.tabWorkspace.showSearh();
                refreshTab = true;
            }
            if (WorkspaceUserProperties.this.workspace.isTabDashboardVisible()) {
                Main.get().mainPanel.topPanel.tabWorkspace.showDashboard();
                refreshTab = true;
            }
            if (result.isTabAdminVisible()) {
                Main.get().mainPanel.topPanel.mainMenu.administration.setVisible(true);
                Main.get().mainPanel.topPanel.tabWorkspace.showAdministration();
                refreshTab = true;
            }
            boolean bl = refreshTab = Main.get().mainPanel.topPanel.tabWorkspace.showExtensionTabs() || refreshTab;
            if (refreshTab) {
                Main.get().mainPanel.topPanel.tabWorkspace.init();
            }
            boolean refreshStack = false;
            if (WorkspaceUserProperties.this.workspace.isStackTaxonomy()) {
                Main.get().mainPanel.desktop.navigator.showTaxonomy();
                refreshStack = true;
            }
            if (WorkspaceUserProperties.this.workspace.isStackCategoriesVisible()) {
                Main.get().mainPanel.desktop.navigator.showCategories();
                refreshStack = true;
            }
            if (WorkspaceUserProperties.this.workspace.isStackThesaurusVisible()) {
                Main.get().mainPanel.desktop.navigator.showThesaurus();
                refreshStack = true;
            }
            if (WorkspaceUserProperties.this.workspace.isStackTemplatesVisible()) {
                Main.get().mainPanel.desktop.navigator.showTemplates();
                Main.get().mainPanel.desktop.navigator.taxonomyTree.folderSelectPopup.showTemplates();
                Main.get().mainPanel.desktop.navigator.categoriesTree.folderSelectPopup.showTemplates();
                Main.get().mainPanel.desktop.navigator.thesaurusTree.folderSelectPopup.showTemplates();
                Main.get().mainPanel.desktop.navigator.personalTree.folderSelectPopup.showTemplates();
                Main.get().mainPanel.desktop.navigator.templateTree.folderSelectPopup.showTemplates();
                Main.get().mainPanel.desktop.navigator.mailTree.folderSelectPopup.showTemplates();
                Main.get().mainPanel.desktop.navigator.trashTree.folderSelectPopup.showTemplates();
                Main.get().mainPanel.dashboard.keyMapDashboard.showTemplates();
                Main.get().mainPanel.search.searchBrowser.searchIn.showTemplates();
                refreshStack = true;
            }
            if (WorkspaceUserProperties.this.workspace.isStackPersonalVisible()) {
                Main.get().mainPanel.desktop.navigator.showPersonal();
                Main.get().mainPanel.desktop.navigator.taxonomyTree.folderSelectPopup.showPersonal();
                Main.get().mainPanel.desktop.navigator.categoriesTree.folderSelectPopup.showPersonal();
                Main.get().mainPanel.desktop.navigator.thesaurusTree.folderSelectPopup.showPersonal();
                Main.get().mainPanel.desktop.navigator.personalTree.folderSelectPopup.showPersonal();
                Main.get().mainPanel.desktop.navigator.templateTree.folderSelectPopup.showPersonal();
                Main.get().mainPanel.desktop.navigator.mailTree.folderSelectPopup.showPersonal();
                Main.get().mainPanel.desktop.navigator.trashTree.folderSelectPopup.showPersonal();
                Main.get().mainPanel.dashboard.keyMapDashboard.showPersonal();
                Main.get().mainPanel.search.searchBrowser.searchIn.showPersonal();
                refreshStack = true;
            }
            if (WorkspaceUserProperties.this.workspace.isStackMailVisible()) {
                Main.get().mainPanel.desktop.navigator.showMail();
                Main.get().mainPanel.desktop.navigator.taxonomyTree.folderSelectPopup.showMail();
                Main.get().mainPanel.desktop.navigator.categoriesTree.folderSelectPopup.showMail();
                Main.get().mainPanel.desktop.navigator.thesaurusTree.folderSelectPopup.showMail();
                Main.get().mainPanel.desktop.navigator.personalTree.folderSelectPopup.showMail();
                Main.get().mainPanel.desktop.navigator.templateTree.folderSelectPopup.showMail();
                Main.get().mainPanel.desktop.navigator.mailTree.folderSelectPopup.showMail();
                Main.get().mainPanel.desktop.navigator.trashTree.folderSelectPopup.showMail();
                Main.get().mainPanel.dashboard.keyMapDashboard.showMail();
                Main.get().mainPanel.search.searchBrowser.searchIn.showMail();
                refreshStack = true;
            }
            if (WorkspaceUserProperties.this.workspace.isStackTrashVisible()) {
                Main.get().mainPanel.desktop.navigator.showTrash();
                Main.get().mainPanel.dashboard.keyMapDashboard.showTrash();
                Main.get().mainPanel.search.searchBrowser.searchIn.showTrash();
                refreshStack = true;
            }
            if (refreshStack) {
                Main.get().mainPanel.desktop.navigator.refreshView();
            }
            if (WorkspaceUserProperties.this.workspace.isTabDocumentPropertiesVisible()) {
                Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.showDocument();
            }
            if (WorkspaceUserProperties.this.workspace.isTabDocumentNotesVisible()) {
                Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.showNotes();
            }
            if (WorkspaceUserProperties.this.workspace.isTabDocumentSecurityVisible()) {
                Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.showSecurity();
            }
            if (WorkspaceUserProperties.this.workspace.isTabDocumentVersionVisible()) {
                Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.showVersion();
            }
            if (WorkspaceUserProperties.this.workspace.isTabDocumentPreviewVisible()) {
                Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.showPreview();
            }
            if (WorkspaceUserProperties.this.workspace.isTabDocumentPropertyGroupsVisible()) {
                Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.showPropertyGroups();
                Main.get().mainPanel.desktop.browser.tabMultiple.tabFolder.showPropertyGroups();
                Main.get().mainPanel.desktop.browser.tabMultiple.tabMail.showPropertyGroups();
            }
            Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.setKeywordEnabled(WorkspaceUserProperties.this.workspace.isKeywordEnabled());
            Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.showExtensions();
            Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.init();
            if (WorkspaceUserProperties.this.workspace.isTabFolderPropertiesVisible()) {
                Main.get().mainPanel.desktop.browser.tabMultiple.tabFolder.showProperties();
            }
            if (WorkspaceUserProperties.this.workspace.isTabFolderNotesVisible()) {
                Main.get().mainPanel.desktop.browser.tabMultiple.tabFolder.showNotes();
            }
            if (WorkspaceUserProperties.this.workspace.isTabFolderSecurityVisible()) {
                Main.get().mainPanel.desktop.browser.tabMultiple.tabFolder.showSecurity();
            }
            Main.get().mainPanel.desktop.browser.tabMultiple.tabFolder.showExtensions();
            Main.get().mainPanel.desktop.browser.tabMultiple.tabFolder.init();
            if (WorkspaceUserProperties.this.workspace.isTabMailPropertiesVisible()) {
                Main.get().mainPanel.desktop.browser.tabMultiple.tabMail.showProperties();
            }
            if (WorkspaceUserProperties.this.workspace.isTabMailSecurityVisible()) {
                Main.get().mainPanel.desktop.browser.tabMultiple.tabMail.showSecurity();
            }
            Main.get().mainPanel.desktop.browser.tabMultiple.tabMail.showExtensions();
            Main.get().mainPanel.desktop.browser.tabMultiple.tabMail.init();
            if (WorkspaceUserProperties.this.workspace.isDashboardUserVisible()) {
                Main.get().mainPanel.dashboard.showUser();
                Main.get().mainPanel.bottomPanel.userInfo.showDashboardUserIcons();
            }
            if (WorkspaceUserProperties.this.workspace.isDashboardMailVisible()) {
                Main.get().mainPanel.dashboard.showMail();
            }
            if (WorkspaceUserProperties.this.workspace.isDashboardNewsVisible()) {
                Main.get().mainPanel.dashboard.showNews();
                Main.get().mainPanel.bottomPanel.userInfo.showDashboardNewsIcons();
            }
            if (WorkspaceUserProperties.this.workspace.isDashboardGeneralVisible()) {
                Main.get().mainPanel.dashboard.showGeneral();
            }
            if (WorkspaceUserProperties.this.workspace.isDashboardWorkflowVisible()) {
                Main.get().mainPanel.dashboard.showWorkflow();
                Main.get().mainPanel.bottomPanel.userInfo.showDashboardWorkflowIcons();
            }
            if (WorkspaceUserProperties.this.workspace.isDashboardKeywordsVisible()) {
                Main.get().mainPanel.dashboard.showKeywords();
            }
            Main.get().fileUpload.setUploadNotifyUsers(WorkspaceUserProperties.this.workspace.isUploadNotifyUsers());
            Main.get().mainPanel.dashboard.init();
            Main.get().startUp.nextStatus(2);
            WorkspaceUserProperties.this.getUpdateMessage();
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("getUserWorkspace", caught);
        }
    };
    final AsyncCallback<Double> callbackGetUserDocumentsSize = new AsyncCallback<Double>(){

        public void onSuccess(Double result) {
            Main.get().mainPanel.bottomPanel.userInfo.setUserRepositorySize(result.longValue());
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("getUserDocumentsSize", caught);
        }
    };

    public void init() {
        this.getUserWorkspace();
    }

    private void getUpdateMessage() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.repositoryService;
        endPoint.setServiceEntryPoint(RPCService.RepositoryService);
        this.repositoryService.getUpdateMessage(this.callbackGetUpdateMessage);
    }

    public void getUserWorkspace() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.workspaceService;
        endPoint.setServiceEntryPoint(RPCService.WorkspaceService);
        this.workspaceService.getUserWorkspace(this.callbackGetUserWorkspace);
    }

    public void refreshUserWorkspace() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.workspaceService;
        endPoint.setServiceEntryPoint(RPCService.WorkspaceService);
        this.workspaceService.getUserWorkspace(new AsyncCallback<GWTWorkspace>(){

            public void onSuccess(GWTWorkspace result) {
                WorkspaceUserProperties.this.workspace = result;
            }

            public void onFailure(Throwable caught) {
                Main.get().showError("getUserWorkspace", caught);
            }
        });
    }

    public void getUserDocumentsSize() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.workspaceService;
        endPoint.setServiceEntryPoint(RPCService.WorkspaceService);
        this.workspaceService.getUserDocumentsSize(this.callbackGetUserDocumentsSize);
    }

    public String getUser() {
        return this.user;
    }

    public String getApplicationURL() {
        return this.applicationURL;
    }

    public GWTWorkspace getWorkspace() {
        return this.workspace;
    }

    public void setAvailableAction() {
        Main.get().mainPanel.desktop.navigator.taxonomyTree.menuPopup.menu.setAvailableOption(this.workspace.getAvailableOption());
        Main.get().mainPanel.desktop.navigator.categoriesTree.menuPopup.menu.setAvailableOption(this.workspace.getAvailableOption());
        Main.get().mainPanel.desktop.navigator.thesaurusTree.menuPopup.menu.setAvailableOption(this.workspace.getAvailableOption());
        Main.get().mainPanel.desktop.navigator.templateTree.menuPopup.menu.setAvailableOption(this.workspace.getAvailableOption());
        Main.get().mainPanel.desktop.navigator.personalTree.menuPopup.menu.setAvailableOption(this.workspace.getAvailableOption());
        Main.get().mainPanel.desktop.navigator.mailTree.menuPopup.menu.setAvailableOption(this.workspace.getAvailableOption());
        Main.get().mainPanel.desktop.navigator.trashTree.menuPopup.menu.setAvailableOption(this.workspace.getAvailableOption());
        Main.get().mainPanel.desktop.browser.fileBrowser.taxonomyMenuPopup.menu.setAvailableOption(this.workspace.getAvailableOption());
        Main.get().mainPanel.desktop.browser.fileBrowser.categoriesMenuPopup.menu.setAvailableOption(this.workspace.getAvailableOption());
        Main.get().mainPanel.desktop.browser.fileBrowser.thesaurusMenuPopup.menu.setAvailableOption(this.workspace.getAvailableOption());
        Main.get().mainPanel.desktop.browser.fileBrowser.templatesMenuPopup.menu.setAvailableOption(this.workspace.getAvailableOption());
        Main.get().mainPanel.desktop.browser.fileBrowser.personalMenuPopup.menu.setAvailableOption(this.workspace.getAvailableOption());
        Main.get().mainPanel.desktop.browser.fileBrowser.mailMenuPopup.menu.setAvailableOption(this.workspace.getAvailableOption());
        Main.get().mainPanel.desktop.browser.fileBrowser.trashMenuPopup.menu.setAvailableOption(this.workspace.getAvailableOption());
        Main.get().mainPanel.search.searchBrowser.searchResult.searchCompactResult.menuPopup.menu.setAvailableOption(this.workspace.getAvailableOption());
        Main.get().mainPanel.topPanel.mainMenu.setAvailableOption(this.workspace);
    }
}

