/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.util.metadata;

import com.openkm.frontend.client.util.ISO8601;
import java.util.Date;

public class DatabaseMetadataMap {
    public static final String MV_NAME_TABLE = "table";
    public static final String MV_NAME_ID = "id";
    public static final String BOOLEAN_TRUE = "T";
    public static final String BOOLEAN_FALSE = "F";

    public static Double getDoubleValue(String value) {
        return value != null ? new Double(value) : null;
    }

    public static String mapDoubleValue(Double value) {
        return value != null ? String.valueOf(value) : null;
    }

    public static Integer getIntegerValue(String value) {
        return value != null ? new Integer(value) : null;
    }

    public static String mapIntegerValue(Integer value) {
        return value != null ? String.valueOf(value) : null;
    }

    public static Boolean getBooleanValue(String value) {
        if (value == null) {
            return null;
        }
        if (value.toUpperCase().equals(BOOLEAN_TRUE)) {
            return true;
        }
        return false;
    }

    public static String mapBooleanValue(Boolean value) {
        if (value == null) {
            return null;
        }
        if (value.booleanValue()) {
            return BOOLEAN_TRUE;
        }
        return BOOLEAN_FALSE;
    }

    public static Date getDateValue(String value) {
        return ISO8601.parseBasic(value);
    }

    public static String mapDateValue(Date value) {
        return ISO8601.formatBasic(value);
    }
}

