/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.util.validator;

import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.TextBoxBase;
import com.openkm.frontend.client.Main;
import eu.maydu.gwt.validation.client.ValidationAction;
import eu.maydu.gwt.validation.client.ValidationResult;
import eu.maydu.gwt.validation.client.Validator;
import eu.maydu.gwt.validation.client.i18n.ValidationMessages;

public class DecimalValidator
extends Validator<DecimalValidator> {
    private TextBoxBase textBox = null;
    private SuggestBox suggestBox = null;

    public DecimalValidator(TextBoxBase text) {
        this.textBox = text;
    }

    public DecimalValidator(SuggestBox suggest) {
        this.suggestBox = suggest;
    }

    public void invokeActions(ValidationResult result) {
        if (this.textBox != null) {
            for (ValidationAction va : this.getFailureActions()) {
                va.invoke(result, (Object)this.textBox);
            }
        } else {
            for (ValidationAction va : this.getFailureActions()) {
                va.invoke(result, (Object)this.suggestBox);
            }
        }
    }

    public <V extends ValidationMessages> ValidationResult validate(V messages) {
        String text = this.suggestBox != null ? this.suggestBox.getText() : this.textBox.getText();
        if (text.equals("") && !this.isRequired()) {
            return null;
        }
        String numberPattern = Main.i18n("general.decimal.pattern");
        String[] number = text.split(numberPattern);
        if (number.length != 2) {
            return new ValidationResult(messages.getStandardMessages().notADouble());
        }
        numberPattern = "[0-9]*";
        if (!number[0].matches(numberPattern) || !number[1].matches(numberPattern)) {
            return new ValidationResult(messages.getStandardMessages().notADouble());
        }
        return null;
    }
}

