/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.util.validator;

import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.TextBoxBase;
import eu.maydu.gwt.validation.client.ValidationAction;
import eu.maydu.gwt.validation.client.ValidationResult;
import eu.maydu.gwt.validation.client.Validator;
import eu.maydu.gwt.validation.client.i18n.StandardValidationMessages;
import eu.maydu.gwt.validation.client.i18n.ValidationMessages;

public class IntegerMinValidator
extends Validator<IntegerMinValidator> {
    private TextBoxBase text;
    private SuggestBox suggest;
    private int min;

    public IntegerMinValidator(TextBoxBase text) {
        this(text, null);
    }

    public IntegerMinValidator(TextBoxBase text, String customMsgKey) {
        this(text, false);
    }

    public IntegerMinValidator(TextBoxBase text, int min) {
        this.text = text;
        this.min = min;
    }

    public IntegerMinValidator(TextBoxBase text, int min, String customMsgKey) {
        this.text = text;
        this.min = min;
        this.setCustomMsgKey(customMsgKey);
    }

    public IntegerMinValidator(TextBoxBase text, boolean preventsPropagationOfValidationChain) {
        this(text, preventsPropagationOfValidationChain, null);
    }

    public IntegerMinValidator(TextBoxBase text, boolean preventsPropagationOfValidationChain, String customMsgKey) {
        this.setPreventsPropagationOfValidationChain(preventsPropagationOfValidationChain);
        if (text == null) {
            throw new RuntimeException("text must not be null");
        }
        this.text = text;
        this.setCustomMsgKey(customMsgKey);
    }

    public IntegerMinValidator(SuggestBox suggest) {
        this(suggest, null);
    }

    public IntegerMinValidator(SuggestBox suggest, String customMsgKey) {
        this(suggest, false);
        this.setCustomMsgKey(customMsgKey);
    }

    public IntegerMinValidator(SuggestBox suggest, int min) {
        this(suggest, min, false);
    }

    public IntegerMinValidator(SuggestBox suggest, boolean preventsPropagationOfValidationChain) {
        this(suggest, preventsPropagationOfValidationChain, null);
    }

    public IntegerMinValidator(SuggestBox suggest, boolean preventsPropagationOfValidationChain, String customMsgKey) {
        this.setPreventsPropagationOfValidationChain(preventsPropagationOfValidationChain);
        if (suggest == null) {
            throw new RuntimeException("suggest must not be null");
        }
        this.suggest = suggest;
        this.setCustomMsgKey(customMsgKey);
    }

    public IntegerMinValidator(SuggestBox suggest, int min, boolean preventsPropagationOfValidationChain) {
        this(suggest, min, preventsPropagationOfValidationChain, null);
    }

    public IntegerMinValidator(SuggestBox suggest, int min, boolean preventsPropagationOfValidationChain, String customMsgKey) {
        this.setPreventsPropagationOfValidationChain(preventsPropagationOfValidationChain);
        if (suggest == null) {
            throw new RuntimeException("suggest must not be null");
        }
        this.suggest = suggest;
        this.min = min;
        this.setCustomMsgKey(customMsgKey);
    }

    public ValidationResult validate(ValidationMessages allMessages) {
        StandardValidationMessages messages = allMessages.getStandardMessages();
        String str = this.text != null ? this.text.getText() : this.suggest.getText();
        if (!this.isRequired() && str.equals("")) {
            return null;
        }
        if ((str = str.trim()).equals("")) {
            return new ValidationResult(this.getErrorMessage(allMessages, messages.notAnInteger(), new Object[0]));
        }
        try {
            long value = Long.parseLong(str);
            if (value < (long)this.min) {
                return new ValidationResult(this.getErrorMessage(allMessages, messages.validator_min(), new Object[0]));
            }
        }
        catch (NumberFormatException ex) {
            return new ValidationResult(this.getErrorMessage(allMessages, messages.notAnInteger(), new Object[0]));
        }
        return null;
    }

    public void invokeActions(ValidationResult result) {
        if (this.text != null) {
            for (ValidationAction action : this.getFailureActions()) {
                action.invoke(result, (Object)this.text);
            }
        } else {
            for (ValidationAction action : this.getFailureActions()) {
                action.invoke(result, (Object)this.suggest);
            }
        }
    }
}

