/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.util.validator;

import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.TextBoxBase;
import eu.maydu.gwt.validation.client.ValidationAction;
import eu.maydu.gwt.validation.client.ValidationResult;
import eu.maydu.gwt.validation.client.Validator;
import eu.maydu.gwt.validation.client.i18n.ValidationMessages;

public class URLValidator
extends Validator<URLValidator> {
    private TextBoxBase textBox = null;
    private SuggestBox suggestBox = null;

    public URLValidator(TextBoxBase text) {
        this.textBox = text;
        this.setCustomMsgKey(null);
    }

    public URLValidator(SuggestBox suggest) {
        this.suggestBox = suggest;
        this.setCustomMsgKey(null);
    }

    public void invokeActions(ValidationResult result) {
        if (this.textBox != null) {
            for (ValidationAction va : this.getFailureActions()) {
                va.invoke(result, (Object)this.textBox);
            }
        } else {
            for (ValidationAction va : this.getFailureActions()) {
                va.invoke(result, (Object)this.suggestBox);
            }
        }
    }

    public <V extends ValidationMessages> ValidationResult validate(V messages) {
        String text = this.suggestBox != null ? this.suggestBox.getText() : this.textBox.getText();
        if (text.equals("") && !this.isRequired()) {
            return null;
        }
        String regexPattern = "\\b(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
        try {
            if (!text.matches(regexPattern)) {
                return new ValidationResult(messages.getStandardMessages().notEqual());
            }
        }
        catch (IllegalArgumentException ex) {
            return new ValidationResult(messages.getStandardMessages().notARegEx());
        }
        return null;
    }
}

