/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTDocument;
import com.openkm.frontend.client.bean.GWTFolder;
import com.openkm.frontend.client.bean.GWTMail;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMDocumentService;
import com.openkm.frontend.client.service.OKMDocumentServiceAsync;
import com.openkm.frontend.client.service.OKMFolderService;
import com.openkm.frontend.client.service.OKMFolderServiceAsync;
import com.openkm.frontend.client.service.OKMMailService;
import com.openkm.frontend.client.service.OKMMailServiceAsync;
import com.openkm.frontend.client.widget.OriginPanel;
import java.util.Iterator;

public class Dragable
extends Composite
implements OriginPanel {
    private final OKMFolderServiceAsync folderService = (OKMFolderServiceAsync)GWT.create(OKMFolderService.class);
    private final OKMDocumentServiceAsync documentService = (OKMDocumentServiceAsync)GWT.create(OKMDocumentService.class);
    private final OKMMailServiceAsync mailService = (OKMMailServiceAsync)GWT.create(OKMMailService.class);
    private boolean dragged = false;
    private HTML floater = new HTML();
    private int originPanel = -1;
    private TreeItem selectedTreeItem;
    private TreeItem lastSelectedTreeItem;
    private Element selectedElement;
    private Element lastSelectElement;
    final AsyncCallback<Object> callbackMove = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("Move", caught);
        }
    };

    public Dragable() {
        this.floater = new HTML("");
        this.floater.setVisible(false);
        this.floater.sinkEvents(124);
        this.floater.setVisible(false);
        this.floater.setWordWrap(false);
        this.floater.setStyleName("okm-Draggable");
        this.floater.addMouseUpHandler(new MouseUpHandler(){

            public void onMouseUp(MouseUpEvent event) {
                DOM.releaseCapture((Element)Dragable.this.floater.getElement());
                Dragable.this.floater.setHTML("");
                Dragable.this.floater.setVisible(false);
                if (Dragable.this.dragged && event.getNativeButton() != 1 && Dragable.this.lastSelectElement != null) {
                    DOM.setElementProperty((Element)Dragable.this.lastSelectElement, (String)"className", (String)"gwt-TreeItem");
                } else if (Dragable.this.dragged && event.getNativeButton() == 1) {
                    switch (Dragable.this.originPanel) {
                        case 1: {
                            TreeItem clickedTreeItem = Main.get().activeFolderTree.elementClicked(DOM.eventGetTarget((Event)((Event)event.getNativeEvent())));
                            if (clickedTreeItem == null || (((GWTFolder)clickedTreeItem.getUserObject()).getPermissions() & 2) != 2) break;
                            final TreeItem draggedTreeItem = Main.get().activeFolderTree.getActualItem();
                            boolean isChild = DOM.isOrHasChild((Element)draggedTreeItem.getElement(), (Element)clickedTreeItem.getElement());
                            if (draggedTreeItem == clickedTreeItem || isChild) break;
                            String fldPath = ((GWTFolder)draggedTreeItem.getUserObject()).getPath();
                            final String dstPath = ((GWTFolder)clickedTreeItem.getUserObject()).getPath();
                            TreeItem parentItem = draggedTreeItem.getParentItem();
                            draggedTreeItem.remove();
                            if (parentItem.getChildCount() == 0) {
                                ((GWTFolder)parentItem.getUserObject()).setHasChilds(false);
                            }
                            clickedTreeItem.addItem(draggedTreeItem);
                            ((GWTFolder)clickedTreeItem.getUserObject()).setHasChilds(true);
                            clickedTreeItem.setState(true);
                            draggedTreeItem.setSelected(true);
                            Main.get().activeFolderTree.evaluesFolderIcon(parentItem);
                            Main.get().activeFolderTree.evaluesFolderIcon(clickedTreeItem);
                            ServiceDefTarget endPoint = (ServiceDefTarget)Dragable.this.folderService;
                            endPoint.setServiceEntryPoint(RPCService.FolderService);
                            Dragable.this.folderService.move(fldPath, dstPath, new AsyncCallback<Object>(){

                                public void onSuccess(Object result) {
                                    GWTFolder draggedFolder = (GWTFolder)draggedTreeItem.getUserObject();
                                    String oldPath = draggedFolder.getPath();
                                    String newPath = dstPath + "/" + draggedFolder.getName();
                                    Dragable.this.preventFolderInconsitences(draggedTreeItem, oldPath, newPath, dstPath);
                                    draggedTreeItem.setState(false);
                                    Main.get().activeFolderTree.openAllPathFolder(newPath, null);
                                }

                                public void onFailure(Throwable caught) {
                                    draggedTreeItem.setState(false);
                                    Main.get().showError("Move", caught);
                                }
                            });
                            break;
                        }
                        case 2: {
                            String dstPath;
                            TreeItem clickedTreeItem = Main.get().activeFolderTree.elementClicked(DOM.eventGetTarget((Event)((Event)event.getNativeEvent())));
                            TreeItem actualTreeItem = Main.get().activeFolderTree.getActualItem();
                            if (clickedTreeItem == null || !Main.get().mainPanel.desktop.browser.fileBrowser.isSelectedRow() || (((GWTFolder)clickedTreeItem.getUserObject()).getPermissions() & 2) != 2 || (dstPath = ((GWTFolder)clickedTreeItem.getUserObject()).getPath()).equals(((GWTFolder)actualTreeItem.getUserObject()).getPath())) break;
                            if (Dragable.this.lastSelectElement != null) {
                                DOM.setElementProperty((Element)Dragable.this.lastSelectElement, (String)"className", (String)"gwt-TreeItem");
                            }
                            if (Main.get().mainPanel.desktop.browser.fileBrowser.isFolderSelected()) {
                                final GWTFolder gwtFolder = Main.get().mainPanel.desktop.browser.fileBrowser.getFolder();
                                String fldPath = gwtFolder.getPath();
                                if (dstPath.startsWith(fldPath)) break;
                                final TreeItem movedTreeItem = Main.get().activeFolderTree.getChildFolder(fldPath);
                                movedTreeItem.remove();
                                if (actualTreeItem.getChildCount() == 0) {
                                    ((GWTFolder)actualTreeItem.getUserObject()).setHasChilds(false);
                                }
                                clickedTreeItem.addItem(movedTreeItem);
                                ((GWTFolder)clickedTreeItem.getUserObject()).setHasChilds(true);
                                clickedTreeItem.setState(true);
                                Main.get().activeFolderTree.removeDeleted(fldPath);
                                Main.get().activeFolderTree.evaluesFolderIcon(clickedTreeItem);
                                ServiceDefTarget endPoint = (ServiceDefTarget)Dragable.this.folderService;
                                endPoint.setServiceEntryPoint(RPCService.FolderService);
                                Dragable.this.folderService.move(fldPath, dstPath, new AsyncCallback<Object>(){

                                    public void onSuccess(Object result) {
                                        movedTreeItem.setUserObject((Object)gwtFolder);
                                        String oldPath = gwtFolder.getPath();
                                        String newPath = dstPath + "/" + gwtFolder.getName();
                                        Dragable.this.preventFolderInconsitences(movedTreeItem, oldPath, newPath, dstPath);
                                        movedTreeItem.setState(false);
                                        Main.get().mainPanel.desktop.browser.fileBrowser.deleteMovedOrMoved();
                                    }

                                    public void onFailure(Throwable caught) {
                                        movedTreeItem.setState(false);
                                        Main.get().showError("Move", caught);
                                    }
                                });
                                break;
                            }
                            if (Main.get().mainPanel.desktop.browser.fileBrowser.isDocumentSelected()) {
                                GWTDocument gwtDocument = Main.get().mainPanel.desktop.browser.fileBrowser.getDocument();
                                ServiceDefTarget endPoint = (ServiceDefTarget)Dragable.this.documentService;
                                endPoint.setServiceEntryPoint(RPCService.DocumentService);
                                Dragable.this.documentService.move(gwtDocument.getPath(), dstPath, Dragable.this.callbackMove);
                                Main.get().mainPanel.desktop.browser.fileBrowser.deleteMovedOrMoved();
                                break;
                            }
                            if (!Main.get().mainPanel.desktop.browser.fileBrowser.isMailSelected()) break;
                            GWTMail gwtMail = Main.get().mainPanel.desktop.browser.fileBrowser.getMail();
                            ServiceDefTarget endPoint = (ServiceDefTarget)Dragable.this.mailService;
                            endPoint.setServiceEntryPoint(RPCService.MailService);
                            Dragable.this.mailService.move(gwtMail.getPath(), dstPath, Dragable.this.callbackMove);
                            Main.get().mainPanel.desktop.browser.fileBrowser.deleteMovedOrMoved();
                        }
                    }
                }
                Dragable.this.dragged = false;
                Main.get().mainPanel.desktop.navigator.scrollTaxonomyPanel.destroyTimer();
            }
        });
        this.floater.addMouseMoveHandler(new MouseMoveHandler(){

            public void onMouseMove(MouseMoveEvent event) {
                if (Dragable.this.dragged && event != null) {
                    Dragable.this.floater.setVisible(true);
                    int posX = event.getClientX();
                    int posY = event.getClientY();
                    RootPanel.get().setWidgetPosition((Widget)Main.get().dragable, posX + 1, posY);
                    Dragable.this.selectedTreeItem = Main.get().activeFolderTree.elementClicked(DOM.eventGetTarget((Event)((Event)event.getNativeEvent())));
                    TreeItem actualItem = Main.get().activeFolderTree.getActualItem();
                    if (Dragable.this.lastSelectedTreeItem != null && !actualItem.equals(Dragable.this.lastSelectedTreeItem) && Dragable.this.lastSelectElement != null) {
                        DOM.setElementProperty((Element)Dragable.this.lastSelectElement, (String)"className", (String)"gwt-TreeItem");
                        Dragable.this.lastSelectedTreeItem = null;
                    }
                    if (Dragable.this.selectedTreeItem != null) {
                        Dragable.this.selectedElement = Dragable.getSelectedElement(Dragable.this.selectedTreeItem.getElement());
                        if (Dragable.this.selectedElement == null) {
                            Window.alert((String)("Problem: '" + Dragable.this.selectedTreeItem.getElement().getInnerHTML() + "'"));
                        }
                        DOM.setElementProperty((Element)Dragable.this.selectedElement, (String)"className", (String)"gwt-TreeItem gwt-TreeItem-selected");
                        if (Dragable.this.lastSelectedTreeItem != null && !Dragable.this.selectedTreeItem.equals(Dragable.this.lastSelectedTreeItem) && !actualItem.equals(Dragable.this.lastSelectedTreeItem) && Dragable.this.lastSelectElement != null) {
                            DOM.setElementProperty((Element)Dragable.this.lastSelectElement, (String)"className", (String)"gwt-TreeItem");
                        }
                        Dragable.this.lastSelectedTreeItem = Dragable.this.selectedTreeItem;
                        Dragable.this.lastSelectElement = Dragable.this.selectedElement;
                    }
                    Main.get().mainPanel.desktop.navigator.scrollTaxonomyPanel.ScrollOnDragDrop(posX + 1, posY);
                }
            }
        });
        this.initWidget((Widget)this.floater);
    }

    public void show(String html, int originPanel) {
        this.originPanel = originPanel;
        DOM.setCapture((Element)this.floater.getElement());
        this.floater.setHTML(html);
        this.dragged = true;
        this.selectedTreeItem = null;
        this.lastSelectedTreeItem = null;
    }

    public static Element getSelectedElement(Element element) {
        if (DOM.getFirstChild((Element)element).getClassName().contains("gwt-TreeItem")) {
            return DOM.getFirstChild((Element)element);
        }
        return DOM.getChild((Element)DOM.getChild((Element)DOM.getChild((Element)DOM.getChild((Element)DOM.getChild((Element)element, (int)0), (int)0), (int)0), (int)1), (int)0);
    }

    public void preventFolderInconsitences(TreeItem item, String oldPath, String newPath, String parentPath) {
        GWTFolder folderItem = (GWTFolder)item.getUserObject();
        folderItem.setPath(folderItem.getPath().replaceFirst(oldPath, newPath));
        folderItem.setParentPath(parentPath);
        for (int i = 0; i < item.getChildCount(); ++i) {
            this.preventFolderInconsitences(item.getChild(i), oldPath, newPath, folderItem.getPath());
        }
    }

    public void add(Widget w) {
    }

    public void clear() {
        DOM.releaseCapture((Element)this.floater.getElement());
        this.floater.setHTML("");
        this.floater.setVisible(false);
        this.dragged = false;
        Main.get().mainPanel.desktop.navigator.scrollTaxonomyPanel.destroyTimer();
    }

    public Iterator<Widget> iterator() {
        return null;
    }

    public boolean remove(Widget w) {
        return true;
    }
}

