/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMAuthService;
import com.openkm.frontend.client.service.OKMAuthServiceAsync;
import com.openkm.frontend.client.service.OKMChatService;
import com.openkm.frontend.client.service.OKMChatServiceAsync;
import com.openkm.frontend.client.widget.chat.ChatRoomDialogBox;

public class LogoutPopup
extends DialogBox
implements ClickHandler {
    private VerticalPanel vPanel;
    private HTML text;
    private Button button;
    private final OKMAuthServiceAsync authService = (OKMAuthServiceAsync)GWT.create(OKMAuthService.class);
    private final OKMChatServiceAsync chatService = (OKMChatServiceAsync)GWT.create(OKMChatService.class);
    final AsyncCallback<Object> callbackLogout = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            LogoutPopup.this.text.setText(Main.i18n("logout.closed"));
            LogoutPopup.this.button.setEnabled(true);
        }

        public void onFailure(Throwable caught) {
            Log.debug((String)("callbackLogout.onFailure(" + caught + ")"));
            Main.get().showError("Logout", caught);
        }
    };

    public LogoutPopup() {
        super(false, true);
        this.vPanel = new VerticalPanel();
        this.text = new HTML(Main.i18n("logout.logout"));
        this.button = new Button(Main.i18n("button.close"), (ClickHandler)this);
        this.vPanel.setWidth("250");
        this.vPanel.setHeight("100");
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.add((Widget)this.text);
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.add((Widget)this.button);
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.setCellHorizontalAlignment((Widget)this.text, VerticalPanel.ALIGN_CENTER);
        this.vPanel.setCellHorizontalAlignment((Widget)this.button, VerticalPanel.ALIGN_CENTER);
        this.button.setStyleName("okm-Button");
        super.hide();
        this.setWidget((Widget)this.vPanel);
    }

    public void onClick(ClickEvent event) {
        super.hide();
        Window.open((String)"index.jsp", (String)"_self", null);
    }

    public void langRefresh() {
        this.setText(Main.i18n("logout.label"));
        this.text.setText(Main.i18n("Logout.Logout"));
        this.button.setText(Main.i18n("button.close"));
    }

    public void logout() {
        this.button.setEnabled(false);
        int left = (Window.getClientWidth() - 300) / 2;
        int top = (Window.getClientHeight() - 200) / 2;
        this.setPopupPosition(left, top);
        this.setText(Main.i18n("logout.label"));
        this.show();
        Log.debug((String)"Logout()");
        if (Main.get().mainPanel.bottomPanel.userInfo.isConnectedToChat()) {
            this.disconnectChat();
        } else {
            ServiceDefTarget endPoint = (ServiceDefTarget)this.authService;
            endPoint.setServiceEntryPoint(RPCService.AuthService);
            this.authService.logout(this.callbackLogout);
            Log.debug((String)"Logout: void");
        }
    }

    private void disconnectChat() {
        Main.get().mainPanel.bottomPanel.userInfo.disconnectChat();
        if (Main.get().mainPanel.bottomPanel.userInfo.getChatRoomList().size() > 0) {
            final ChatRoomDialogBox chatRoom = Main.get().mainPanel.bottomPanel.userInfo.getChatRoomList().get(0);
            chatRoom.setChatRoomActive(false);
            ServiceDefTarget endPoint = (ServiceDefTarget)this.chatService;
            endPoint.setServiceEntryPoint(RPCService.ChatService);
            this.chatService.closeRoom(chatRoom.getRoom(), new AsyncCallback<Object>(){

                public void onSuccess(Object arg0) {
                    Main.get().mainPanel.bottomPanel.userInfo.removeChatRoom(chatRoom);
                    LogoutPopup.this.disconnectChat();
                }

                public void onFailure(Throwable caught) {
                    Main.get().showError("CloseRoom", caught);
                    Main.get().mainPanel.bottomPanel.userInfo.removeChatRoom(chatRoom);
                    LogoutPopup.this.disconnectChat();
                }
            });
        } else {
            Main.get().mainPanel.bottomPanel.userInfo.disconnectChat();
            ServiceDefTarget endPoint = (ServiceDefTarget)this.chatService;
            endPoint.setServiceEntryPoint(RPCService.ChatService);
            this.chatService.logout(new AsyncCallback<Object>(){

                public void onSuccess(Object result) {
                    LogoutPopup.this.logoutAfterChat();
                    Log.debug((String)"Logout: void");
                }

                public void onFailure(Throwable caught) {
                    Main.get().showError("GetLogoutChat", caught);
                    LogoutPopup.this.logoutAfterChat();
                    Log.debug((String)"Logout: void");
                }
            });
        }
    }

    private void logoutAfterChat() {
        Timer timer = new Timer(){

            public void run() {
                ServiceDefTarget endPoint = (ServiceDefTarget)LogoutPopup.this.authService;
                endPoint.setServiceEntryPoint(RPCService.AuthService);
                LogoutPopup.this.authService.logout(LogoutPopup.this.callbackLogout);
            }
        };
        timer.schedule(1100);
        Log.debug((String)"Logout: void");
    }
}

