/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTDocument;
import com.openkm.frontend.client.bean.GWTFolder;
import com.openkm.frontend.client.bean.GWTMail;
import com.openkm.frontend.client.bean.GWTPropertyGroup;
import com.openkm.frontend.client.service.OKMPropertyGroupService;
import com.openkm.frontend.client.service.OKMPropertyGroupServiceAsync;
import java.util.List;

public class PropertyGroupPopup
extends DialogBox {
    private final OKMPropertyGroupServiceAsync propertyGroupService = (OKMPropertyGroupServiceAsync)GWT.create(OKMPropertyGroupService.class);
    private VerticalPanel vPanel;
    private HorizontalPanel hPanel;
    private Button button;
    private Button addButton;
    private ListBox listBox;
    private String path;
    final AsyncCallback<List<GWTPropertyGroup>> callbackGetAllGroups = new AsyncCallback<List<GWTPropertyGroup>>(){

        public void onSuccess(List<GWTPropertyGroup> result) {
            PropertyGroupPopup.this.listBox.clear();
            PropertyGroupPopup.this.listBox.addItem("", "");
            for (GWTPropertyGroup group : result) {
                PropertyGroupPopup.this.listBox.addItem(group.getLabel(), group.getName());
            }
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("GetAllGroups", caught);
        }
    };
    final AsyncCallback<Object> callbackAddGroup = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            Object node = Main.get().mainPanel.topPanel.toolBar.getActualNode();
            if (node != null) {
                if (Main.get().mainPanel.topPanel.toolBar.isNodeDocument()) {
                    GWTDocument doc = (GWTDocument)Main.get().mainPanel.topPanel.toolBar.getActualNode();
                    Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.setProperties(doc);
                } else if (Main.get().mainPanel.topPanel.toolBar.isNodeFolder()) {
                    GWTFolder folder = (GWTFolder)Main.get().mainPanel.topPanel.toolBar.getActualNode();
                    Main.get().mainPanel.desktop.browser.tabMultiple.tabFolder.setProperties(folder);
                } else if (Main.get().mainPanel.topPanel.toolBar.isNodeMail()) {
                    GWTMail mail = (GWTMail)Main.get().mainPanel.topPanel.toolBar.getActualNode();
                    Main.get().mainPanel.desktop.browser.tabMultiple.tabMail.setProperties(mail);
                }
                if (PropertyGroupPopup.this.listBox.getItemCount() == 2) {
                    Main.get().mainPanel.topPanel.toolBar.disableAddPropertyGroup();
                }
            }
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("AddGroup", caught);
        }
    };

    public PropertyGroupPopup() {
        super(false, true);
        this.vPanel = new VerticalPanel();
        this.hPanel = new HorizontalPanel();
        this.button = new Button(Main.i18n("button.close"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                PropertyGroupPopup.this.hide();
            }
        });
        this.addButton = new Button(Main.i18n("button.add"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                PropertyGroupPopup.this.addGroup();
                PropertyGroupPopup.this.hide();
            }
        });
        this.listBox = new ListBox();
        this.listBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent arg0) {
                if (PropertyGroupPopup.this.listBox.getSelectedIndex() > 0) {
                    PropertyGroupPopup.this.addButton.setEnabled(true);
                } else {
                    PropertyGroupPopup.this.addButton.setEnabled(false);
                }
            }
        });
        this.listBox.setStyleName("okm-Select");
        this.vPanel.setWidth("300px");
        this.vPanel.setHeight("50px");
        this.button.setStyleName("okm-Button");
        this.addButton.setStyleName("okm-Button");
        this.addButton.setEnabled(false);
        this.hPanel.add((Widget)this.button);
        this.hPanel.add((Widget)new HTML("&nbsp;&nbsp;"));
        this.hPanel.add((Widget)this.addButton);
        this.hPanel.setCellHorizontalAlignment((Widget)this.button, VerticalPanel.ALIGN_CENTER);
        this.hPanel.setCellHorizontalAlignment((Widget)this.addButton, VerticalPanel.ALIGN_CENTER);
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.add((Widget)this.listBox);
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.add((Widget)this.hPanel);
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.setCellHorizontalAlignment((Widget)this.listBox, VerticalPanel.ALIGN_CENTER);
        this.vPanel.setCellHorizontalAlignment((Widget)this.hPanel, VerticalPanel.ALIGN_CENTER);
        super.hide();
        this.setWidget((Widget)this.vPanel);
    }

    public void enableClose() {
        this.button.setEnabled(true);
        Main.get().mainPanel.setVisible(true);
    }

    public void langRefresh() {
        this.setText(Main.i18n("group.label"));
        this.button.setText(Main.i18n("button.close"));
        this.addButton.setText(Main.i18n("button.add"));
    }

    public void show() {
        this.setText(Main.i18n("group.label"));
        this.getAllGroups();
        this.addButton.setEnabled(false);
        int left = (Window.getClientWidth() - 300) / 2;
        int top = (Window.getClientHeight() - 100) / 2;
        this.setPopupPosition(left, top);
        super.show();
    }

    private void getAllGroups() {
        this.path = Main.get().mainPanel.topPanel.toolBar.getActualNodePath();
        if (!this.path.equals("")) {
            this.propertyGroupService.getAllGroups(this.path, this.callbackGetAllGroups);
        }
    }

    private void addGroup() {
        if (this.listBox.getSelectedIndex() > 0) {
            String grpName = this.listBox.getValue(this.listBox.getSelectedIndex());
            if (this.path != null && !this.path.equals("")) {
                this.propertyGroupService.addGroup(this.path, grpName, this.callbackAddGroup);
            }
        }
    }
}

