/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTReport;
import com.openkm.frontend.client.util.Util;
import com.openkm.frontend.client.widget.form.FormManager;
import java.util.Map;

public class ReportPopup
extends DialogBox {
    private VerticalPanel vPanel;
    private Button cancelbutton;
    private Button executeButton;
    private GWTReport report;
    private FormManager manager;

    public ReportPopup() {
        super(false, true);
        this.setText(Main.i18n("report.parameters"));
        this.vPanel = new VerticalPanel();
        this.manager = new FormManager();
        this.cancelbutton = new Button(Main.i18n("button.cancel"));
        this.cancelbutton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ReportPopup.this.report = null;
                ReportPopup.this.hide();
            }
        });
        this.cancelbutton.setStyleName("okm-Button");
        this.executeButton = new Button(Main.i18n("button.execute"));
        this.executeButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ReportPopup.this.manager.getValidationProcessor().validate(new String[0])) {
                    ReportPopup.this.manager.updateFormElementsValuesWithNewer();
                    Map<String, String> parameters = ReportPopup.this.manager.getStringMapValues();
                    parameters.put("format", String.valueOf(Main.get().mainPanel.topPanel.mainMenu.getReportOutput()));
                    Util.executeReport(ReportPopup.this.report.getId(), parameters);
                    ReportPopup.this.hide();
                }
            }
        });
        this.executeButton.setStyleName("okm-Button");
        HorizontalPanel hPanel = new HorizontalPanel();
        hPanel.add((Widget)this.cancelbutton);
        hPanel.add((Widget)Util.hSpace("5"));
        hPanel.add((Widget)this.executeButton);
        this.vPanel.add((Widget)this.manager.getTable());
        this.vPanel.add((Widget)Util.vSpace("5"));
        this.vPanel.add((Widget)hPanel);
        this.vPanel.add((Widget)Util.vSpace("5"));
        this.vPanel.setCellHorizontalAlignment((Widget)hPanel, HasAlignment.ALIGN_CENTER);
        this.vPanel.setSize("100%", "20");
        super.hide();
        this.setWidget((Widget)this.vPanel);
    }

    public void setReport(GWTReport report) {
        this.report = report;
        this.manager.setFormElements(report.getFormElements());
        this.manager.edit();
    }

    public void langRefresh() {
        this.setText(Main.i18n("report.parameters"));
        this.cancelbutton.setHTML(Main.i18n("button.cancel"));
        this.executeButton.setHTML(Main.i18n("button.execute"));
    }
}

