/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget;

import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.TabBar;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.extension.event.HasWorkspaceEvent;
import com.openkm.frontend.client.extension.event.handler.WorkspaceHandlerExtension;
import com.openkm.frontend.client.extension.event.hashandler.HasWorkspaceHandlerExtension;
import com.openkm.frontend.client.extension.widget.tabworkspace.TabWorkspaceExtension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TabWorkspace
extends Composite
implements HasWorkspaceEvent,
HasWorkspaceHandlerExtension {
    private static final int NUMBER_OF_TABS = 4;
    public TabBar tabBar;
    private boolean desktopVisible = false;
    private boolean searchVisible = false;
    private boolean dashboardVisible = false;
    private boolean adminitrationVisible = false;
    private List<TabWorkspaceExtension> widgetExtensionList = new ArrayList<TabWorkspaceExtension>();
    private List<WorkspaceHandlerExtension> workHandlerExtensionList = new ArrayList<WorkspaceHandlerExtension>();

    public TabWorkspace() {
        this.tabBar = new TabBar();
        this.tabBar.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                int index = TabWorkspace.this.indexCorrectedChangeViewIndex((Integer)event.getSelectedItem());
                switch (index) {
                    case 0: {
                        Main.get().mainPanel.setView(0);
                        Main.get().activeFolderTree.centerActulItemOnScroll();
                        break;
                    }
                    case 1: {
                        Main.get().mainPanel.setView(1);
                        break;
                    }
                    case 2: {
                        Main.get().mainPanel.setView(2);
                        break;
                    }
                    case 3: {
                        Main.get().mainPanel.setView(3);
                        break;
                    }
                    default: {
                        Main.get().mainPanel.setView(index);
                    }
                }
                TabWorkspace.this.fireEvent(HasWorkspaceEvent.STACK_CHANGED);
            }
        });
        this.initWidget((Widget)this.tabBar);
    }

    public void langRefresh() {
        int selected = this.tabBar.getSelectedTab();
        while (this.tabBar.getTabCount() > 0) {
            this.tabBar.selectTab(0);
            this.tabBar.removeTab(0);
        }
        if (this.desktopVisible) {
            this.tabBar.addTab(Main.i18n("tab.workspace.desktop"));
        }
        if (this.searchVisible) {
            this.tabBar.addTab(Main.i18n("tab.workspace.search"));
        }
        if (this.dashboardVisible) {
            this.tabBar.addTab(Main.i18n("tab.workspace.dashboard"));
        }
        if (this.adminitrationVisible) {
            this.tabBar.addTab(Main.i18n("tab.workspace.administration"));
        }
        Iterator<TabWorkspaceExtension> it = this.widgetExtensionList.iterator();
        while (it.hasNext()) {
            this.tabBar.addTab(it.next().getTabText());
        }
        this.tabBar.selectTab(selected);
    }

    public int getSelectedWorkspace() {
        return this.indexCorrectedChangeViewIndex(this.tabBar.getSelectedTab());
    }

    public void changeSelectedTab(int tabIndex) {
        switch (tabIndex) {
            case 0: {
                this.tabBar.selectTab(0);
                Main.get().mainPanel.setView(0);
                break;
            }
            case 1: {
                this.tabBar.selectTab(1);
                Main.get().mainPanel.setView(1);
                break;
            }
            case 2: {
                this.tabBar.selectTab(2);
                Main.get().mainPanel.setView(2);
                break;
            }
            case 3: {
                this.tabBar.selectTab(3);
                Main.get().mainPanel.setView(3);
            }
        }
    }

    public int indexCorrectedChangeViewIndex(int index) {
        int corrected = index;
        if (!this.desktopVisible && corrected >= 0) {
            ++corrected;
        }
        if (!this.searchVisible && corrected >= 1) {
            ++corrected;
        }
        if (!this.dashboardVisible && corrected >= 2) {
            ++corrected;
        }
        if (!this.adminitrationVisible && corrected >= 3) {
            ++corrected;
        }
        return corrected;
    }

    public void showDesktop() {
        this.tabBar.addTab(Main.i18n("tab.workspace.desktop"));
        this.desktopVisible = true;
    }

    public void showSearh() {
        this.tabBar.addTab(Main.i18n("tab.workspace.search"));
        this.searchVisible = true;
    }

    public void showDashboard() {
        this.tabBar.addTab(Main.i18n("tab.workspace.dashboard"));
        this.dashboardVisible = true;
    }

    public void showAdministration() {
        this.tabBar.addTab(Main.i18n("tab.workspace.administration"));
        this.adminitrationVisible = true;
    }

    public boolean showExtensionTabs() {
        for (TabWorkspaceExtension tabExtension : this.widgetExtensionList) {
            this.tabBar.addTab(tabExtension.getTabText());
        }
        return !this.widgetExtensionList.isEmpty();
    }

    public int getTabExtensionIndex(TabWorkspaceExtension widget) {
        int count = 0;
        for (TabWorkspaceExtension tabExtension : this.widgetExtensionList) {
            if (tabExtension.equals(widget)) {
                return 4 + count;
            }
            ++count;
        }
        return -1;
    }

    public boolean isDesktopVisible() {
        return this.desktopVisible;
    }

    public void init() {
        if (this.tabBar.getTabCount() > 0) {
            this.tabBar.selectTab(0);
        }
    }

    public int getSelectedTab() {
        return this.tabBar.getSelectedTab();
    }

    public void addWorkspaceExtension(TabWorkspaceExtension extension) {
        this.widgetExtensionList.add(extension);
        extension.setPixelSize(Main.get().mainPanel.getCenterWidth(), Main.get().mainPanel.getCenterHeight());
    }

    public Widget getWidgetExtensionByIndex(int index) {
        return (Widget)this.widgetExtensionList.get(index - 4);
    }

    @Override
    public void addWorkspaceHandlerExtension(WorkspaceHandlerExtension handlerExtension) {
        this.workHandlerExtensionList.add(handlerExtension);
    }

    @Override
    public void fireEvent(HasWorkspaceEvent.WorkspaceEventConstant event) {
        Iterator<WorkspaceHandlerExtension> it = this.workHandlerExtensionList.iterator();
        while (it.hasNext()) {
            it.next().onChange(event);
        }
    }
}

