/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.extension.widget.userinfo.UserInfoExtension;
import com.openkm.frontend.client.service.OKMChatService;
import com.openkm.frontend.client.service.OKMChatServiceAsync;
import com.openkm.frontend.client.util.OKMBundleResources;
import com.openkm.frontend.client.util.Util;
import com.openkm.frontend.client.widget.chat.ChatRoomDialogBox;
import com.openkm.frontend.client.widget.chat.ChatRoomPopup;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UserInfo
extends Composite {
    private final OKMChatServiceAsync chatService = (OKMChatServiceAsync)GWT.create(OKMChatService.class);
    public static final int USERS_IN_ROOM_REFRESHING_TIME = 1000;
    private static final int NEW_ROOM_REFRESHING_TIME = 200;
    private HorizontalPanel panel;
    private Image advertisement;
    private HTML user;
    private String msg = "";
    private Image img;
    private HTML userRepositorySize;
    private Image imgRepositorySize;
    private HTML lockedDocuments;
    private Image imgLockedDocuments;
    private HTML checkoutDocuments;
    private Image imgCheckoutDocuments;
    private HTML subscriptions;
    private Image imgSubscriptions;
    private HTML newDocuments;
    private Image imgNewsDocuments;
    private HTML newWorkflowTasks;
    private Image imgWorkflowTasks;
    private HTML newWorkflowPooledTasks;
    private Image imgWorkflowPooledTasks;
    private Image imgChat;
    private Image imgNewChatRoom;
    private Image imgChatSeparator;
    private boolean chatConnected = false;
    private HTML usersConnected;
    private List<String> connectUsersList;
    private List<ChatRoomDialogBox> chatRoomList;
    private Image imgUserQuota;
    private boolean userQuota = false;
    private long quotaLimit = 0L;
    private boolean quotaExceeded = false;
    private HTML quotaUsed;
    private int percent = 0;
    private List<UserInfoExtension> widgetExtensionList = new ArrayList<UserInfoExtension>();

    public UserInfo() {
        this.connectUsersList = new ArrayList<String>();
        this.chatRoomList = new ArrayList<ChatRoomDialogBox>();
        this.img = new Image(OKMBundleResources.INSTANCE.openkmConnected());
        this.panel = new HorizontalPanel();
        this.panel.setHorizontalAlignment(HorizontalPanel.ALIGN_CENTER);
        this.panel.setVerticalAlignment(HorizontalPanel.ALIGN_MIDDLE);
        this.user = new HTML("");
        this.userRepositorySize = new HTML("");
        this.usersConnected = new HTML("");
        this.lockedDocuments = new HTML("");
        this.checkoutDocuments = new HTML("");
        this.subscriptions = new HTML("");
        this.newDocuments = new HTML("");
        this.newWorkflowTasks = new HTML("");
        this.newWorkflowPooledTasks = new HTML("");
        this.quotaUsed = new HTML("");
        this.quotaUsed.setVisible(false);
        this.lockedDocuments.setVisible(false);
        this.checkoutDocuments.setVisible(false);
        this.subscriptions.setVisible(false);
        this.newDocuments.setVisible(false);
        this.newWorkflowTasks.setVisible(false);
        this.newWorkflowPooledTasks.setVisible(false);
        this.imgRepositorySize = new Image(OKMBundleResources.INSTANCE.repositorySize());
        this.imgUserQuota = new Image(OKMBundleResources.INSTANCE.quota1());
        this.imgChat = new Image(OKMBundleResources.INSTANCE.chatDisconnected());
        this.imgChatSeparator = new Image(OKMBundleResources.INSTANCE.separator());
        this.imgNewChatRoom = new Image(OKMBundleResources.INSTANCE.newChatRoom());
        this.imgLockedDocuments = new Image(OKMBundleResources.INSTANCE.lock());
        this.imgCheckoutDocuments = new Image(OKMBundleResources.INSTANCE.checkout());
        this.imgSubscriptions = new Image(OKMBundleResources.INSTANCE.subscribed());
        this.imgNewsDocuments = new Image(OKMBundleResources.INSTANCE.news());
        this.imgWorkflowTasks = new Image(OKMBundleResources.INSTANCE.workflowTasks());
        this.imgWorkflowPooledTasks = new Image(OKMBundleResources.INSTANCE.workflowPooledTasks());
        this.imgRepositorySize.setVisible(false);
        this.imgUserQuota.setVisible(false);
        this.imgChat.setVisible(false);
        this.imgChatSeparator.setVisible(false);
        this.usersConnected.setVisible(false);
        this.imgNewChatRoom.setVisible(false);
        this.imgLockedDocuments.setVisible(false);
        this.imgCheckoutDocuments.setVisible(false);
        this.imgSubscriptions.setVisible(false);
        this.imgNewsDocuments.setVisible(false);
        this.imgWorkflowTasks.setVisible(false);
        this.imgWorkflowPooledTasks.setVisible(false);
        this.imgChat.setTitle(Main.i18n("user.info.chat.connect"));
        this.imgUserQuota.setTitle(Main.i18n("user.info.user.quota"));
        this.imgNewChatRoom.setTitle(Main.i18n("user.info.chat.new.room"));
        this.imgLockedDocuments.setTitle(Main.i18n("user.info.locked.actual"));
        this.imgCheckoutDocuments.setTitle(Main.i18n("user.info.checkout.actual"));
        this.imgSubscriptions.setTitle(Main.i18n("user.info.subscription.actual"));
        this.imgNewsDocuments.setTitle(Main.i18n("user.info.news.new"));
        this.imgWorkflowTasks.setTitle(Main.i18n("user.info.workflow.pending.tasks"));
        this.imgWorkflowPooledTasks.setTitle(Main.i18n("user.info.workflow.pending.pooled.tasks"));
        this.imgLockedDocuments.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Main.get().mainPanel.topPanel.tabWorkspace.changeSelectedTab(2);
                Main.get().mainPanel.dashboard.horizontalToolBar.showUserView();
            }
        });
        this.imgCheckoutDocuments.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Main.get().mainPanel.topPanel.tabWorkspace.changeSelectedTab(2);
                Main.get().mainPanel.dashboard.horizontalToolBar.showUserView();
            }
        });
        this.imgSubscriptions.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Main.get().mainPanel.topPanel.tabWorkspace.changeSelectedTab(2);
                Main.get().mainPanel.dashboard.horizontalToolBar.showUserView();
            }
        });
        this.imgNewsDocuments.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Main.get().mainPanel.topPanel.tabWorkspace.changeSelectedTab(2);
                Main.get().mainPanel.dashboard.horizontalToolBar.showNewsView();
            }
        });
        this.imgWorkflowTasks.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Main.get().mainPanel.topPanel.tabWorkspace.changeSelectedTab(2);
                Main.get().mainPanel.dashboard.horizontalToolBar.showWorkflowView();
            }
        });
        this.imgWorkflowPooledTasks.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Main.get().mainPanel.topPanel.tabWorkspace.changeSelectedTab(2);
                Main.get().mainPanel.dashboard.horizontalToolBar.showWorkflowView();
            }
        });
        this.imgChat.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!UserInfo.this.chatConnected) {
                    UserInfo.this.loginChat(false);
                } else {
                    UserInfo.this.chatConnected = false;
                    UserInfo.this.logoutChat();
                }
            }
        });
        this.imgNewChatRoom.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Main.get().onlineUsersPopup.setAction(0);
                Main.get().onlineUsersPopup.center();
                Main.get().onlineUsersPopup.refreshOnlineUsers();
            }
        });
        this.advertisement = new Image(OKMBundleResources.INSTANCE.warning());
        this.advertisement.setVisible(false);
        this.advertisement.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Main.get().msgPopup.show("openkm.update.available", UserInfo.this.msg, 400, 200);
            }
        });
        this.panel.add((Widget)this.advertisement);
        this.panel.add((Widget)new HTML("&nbsp;"));
        this.panel.add((Widget)this.img);
        this.panel.add((Widget)new HTML("&nbsp;"));
        this.panel.add((Widget)this.user);
        this.panel.add((Widget)new Image(OKMBundleResources.INSTANCE.separator()));
        this.panel.add((Widget)new HTML("&nbsp;"));
        this.panel.add((Widget)this.imgRepositorySize);
        this.panel.add((Widget)new HTML("&nbsp;"));
        this.panel.add((Widget)this.userRepositorySize);
        this.panel.add((Widget)new HTML("&nbsp;"));
        this.panel.add((Widget)this.imgUserQuota);
        this.panel.add((Widget)new HTML("&nbsp;"));
        this.panel.add((Widget)this.quotaUsed);
        this.panel.add((Widget)new HTML("&nbsp;"));
        this.panel.add((Widget)new Image(OKMBundleResources.INSTANCE.separator()));
        this.panel.add((Widget)new HTML("&nbsp;"));
        this.panel.add((Widget)this.imgChat);
        this.panel.add((Widget)new HTML("&nbsp;"));
        this.panel.add((Widget)this.imgNewChatRoom);
        this.panel.add((Widget)new HTML("&nbsp;"));
        this.panel.add((Widget)this.usersConnected);
        this.panel.add((Widget)new HTML("&nbsp;"));
        this.panel.add((Widget)this.imgChatSeparator);
        this.panel.add((Widget)new HTML("&nbsp;"));
        this.panel.add((Widget)this.imgLockedDocuments);
        this.panel.add((Widget)new HTML("&nbsp;"));
        this.panel.add((Widget)this.lockedDocuments);
        this.panel.add((Widget)new HTML("&nbsp;"));
        this.panel.add((Widget)this.imgCheckoutDocuments);
        this.panel.add((Widget)new HTML("&nbsp;"));
        this.panel.add((Widget)this.checkoutDocuments);
        this.panel.add((Widget)new HTML("&nbsp;"));
        this.panel.add((Widget)this.imgSubscriptions);
        this.panel.add((Widget)new HTML("&nbsp;"));
        this.panel.add((Widget)this.subscriptions);
        this.panel.add((Widget)new HTML("&nbsp;"));
        this.panel.add((Widget)this.imgNewsDocuments);
        this.panel.add((Widget)this.newDocuments);
        this.panel.add((Widget)new HTML("&nbsp;"));
        this.panel.add((Widget)this.imgWorkflowTasks);
        this.panel.add((Widget)this.newWorkflowTasks);
        this.panel.add((Widget)new HTML("&nbsp;"));
        this.panel.add((Widget)this.imgWorkflowPooledTasks);
        this.panel.add((Widget)this.newWorkflowPooledTasks);
        this.panel.add((Widget)new HTML("&nbsp;"));
        this.imgLockedDocuments.setStyleName("okm-Hyperlink");
        this.imgCheckoutDocuments.setStyleName("okm-Hyperlink");
        this.imgSubscriptions.setStyleName("okm-Hyperlink");
        this.imgNewsDocuments.setStyleName("okm-Hyperlink");
        this.imgWorkflowTasks.setStyleName("okm-Hyperlink");
        this.imgWorkflowPooledTasks.setStyleName("okm-Hyperlink");
        this.imgChat.setStyleName("okm-Hyperlink");
        this.imgNewChatRoom.setStyleName("okm-Hyperlink");
        this.initWidget((Widget)this.panel);
    }

    public void setUser(String user, boolean isAdmin) {
        this.user.setHTML("&nbsp;" + Main.i18n("general.connected") + " " + Main.get().getUserName(user) + "&nbsp;");
        if (isAdmin) {
            this.user.addStyleName("okm-Input-System");
        }
    }

    public void setUserRepositorySize(double size) {
        this.imgRepositorySize.setVisible(true);
        this.userRepositorySize.setHTML("&nbsp;" + Util.formatSize(size) + "&nbsp;");
        if (this.userQuota) {
            if (size > 0.0) {
                if (size >= (double)this.quotaLimit) {
                    this.quotaExceeded = true;
                    this.percent = 100;
                    this.imgUserQuota.setResource(OKMBundleResources.INSTANCE.quota6());
                } else {
                    this.percent = new Double(size * 100.0 / (double)this.quotaLimit).intValue();
                    if (this.percent == 0) {
                        this.percent = 1;
                    } else if (this.percent > 100) {
                        this.percent = 100;
                    }
                    if (this.percent <= 20) {
                        this.imgUserQuota.setResource(OKMBundleResources.INSTANCE.quota1());
                    } else if (this.percent <= 40) {
                        this.imgUserQuota.setResource(OKMBundleResources.INSTANCE.quota2());
                    } else if (this.percent <= 60) {
                        this.imgUserQuota.setResource(OKMBundleResources.INSTANCE.quota3());
                    } else if (this.percent <= 80) {
                        this.imgUserQuota.setResource(OKMBundleResources.INSTANCE.quota4());
                    } else {
                        this.imgUserQuota.setResource(OKMBundleResources.INSTANCE.quota5());
                    }
                }
            } else {
                this.quotaExceeded = false;
                this.imgUserQuota.setResource(OKMBundleResources.INSTANCE.quota1());
            }
            this.quotaUsed.setHTML(this.percent + "%");
        }
    }

    public void setLockedDocuments(int value) {
        this.lockedDocuments.setHTML("&nbsp;" + value + "&nbsp;");
    }

    public void setCheckoutDocuments(int value) {
        this.checkoutDocuments.setHTML("&nbsp;" + value + "&nbsp;");
    }

    public void setSubscriptions(int value) {
        this.subscriptions.setHTML("&nbsp;" + value + "&nbsp;");
    }

    public void setNewsDocuments(int value) {
        this.newDocuments.setHTML("&nbsp;" + value + "&nbsp;");
        if (value > 0) {
            this.imgNewsDocuments.setResource(OKMBundleResources.INSTANCE.newsAlert());
        } else {
            this.imgNewsDocuments.setResource(OKMBundleResources.INSTANCE.news());
        }
    }

    public void setNewsWorkflows(int value) {
        this.newWorkflowTasks.setHTML("&nbsp;" + value + "&nbsp;");
        if (value > 0) {
            this.imgWorkflowTasks.setResource(OKMBundleResources.INSTANCE.workflowTasksAlert());
        } else {
            this.imgWorkflowTasks.setResource(OKMBundleResources.INSTANCE.workflowTasks());
        }
    }

    public void setPooledTaskInstances(int value) {
        this.newWorkflowPooledTasks.setHTML("&nbsp;" + value + "&nbsp;");
        if (value > 0) {
            this.imgWorkflowPooledTasks.setResource(OKMBundleResources.INSTANCE.workflowPooledTasksAlert());
        } else {
            this.imgWorkflowPooledTasks.setResource(OKMBundleResources.INSTANCE.workflowPooledTasks());
        }
    }

    public void setUpdateMessage(String msg) {
        if (msg != null && !msg.equals("")) {
            this.advertisement.setVisible(true);
            this.msg = msg;
        }
    }

    public void langRefresh() {
        this.user.setHTML("&nbsp;" + Main.i18n("general.connected") + " " + Main.get().getUserName(Main.get().workspaceUserProperties.getUser()) + "&nbsp;");
        if (this.chatConnected) {
            this.imgChat.setTitle(Main.i18n("user.info.chat.disconnect"));
            this.usersConnected.setHTML(this.connectUsersList.size() + "");
        } else {
            this.imgChat.setTitle(Main.i18n("user.info.chat.connect"));
            this.usersConnected.setHTML("");
        }
        this.imgUserQuota.setTitle(Main.i18n("user.info.user.quota"));
        this.imgNewChatRoom.setTitle(Main.i18n("user.info.chat.new.room"));
        this.imgLockedDocuments.setTitle(Main.i18n("user.info.locked.actual"));
        this.imgCheckoutDocuments.setTitle(Main.i18n("user.info.checkout.actual"));
        this.imgSubscriptions.setTitle(Main.i18n("user.info.subscription.actual"));
        this.imgNewsDocuments.setTitle(Main.i18n("user.info.news.new"));
        this.imgWorkflowTasks.setTitle(Main.i18n("user.info.workflow.pending.tasks"));
        this.imgWorkflowPooledTasks.setTitle(Main.i18n("user.info.workflow.pending.pooled.tasks"));
        this.quotaUsed.setHTML(this.percent + "%");
        Iterator<ChatRoomDialogBox> it = this.chatRoomList.iterator();
        while (it.hasNext()) {
            it.next().langRefresh();
        }
    }

    private void refreshConnectedUsers() {
        if (this.chatConnected) {
            ServiceDefTarget endPoint = (ServiceDefTarget)this.chatService;
            endPoint.setServiceEntryPoint(RPCService.ChatService);
            this.chatService.getLoggedUsers(new AsyncCallback<List<String>>(){

                public void onSuccess(List<String> result) {
                    UserInfo.this.connectUsersList = result;
                    UserInfo.this.usersConnected.setHTML(UserInfo.this.connectUsersList.size() + "");
                    Timer timer = new Timer(){

                        public void run() {
                            UserInfo.this.refreshConnectedUsers();
                        }
                    };
                    timer.schedule(1000);
                }

                public void onFailure(Throwable caught) {
                    Main.get().showError("GetLoggedUsers", caught);
                }
            });
        }
    }

    private void getPendingChatRoomUser() {
        if (this.chatConnected) {
            ServiceDefTarget endPoint = (ServiceDefTarget)this.chatService;
            endPoint.setServiceEntryPoint(RPCService.ChatService);
            this.chatService.getPendingChatRoomUser(new AsyncCallback<List<String>>(){

                public void onSuccess(List<String> result) {
                    for (String room : result) {
                        ChatRoomPopup chatRoomPopup = new ChatRoomPopup("", room);
                        chatRoomPopup.center();
                        chatRoomPopup.getPendingMessage(room);
                        UserInfo.this.addChatRoom(chatRoomPopup);
                    }
                    Timer timer = new Timer(){

                        public void run() {
                            UserInfo.this.getPendingChatRoomUser();
                        }
                    };
                    timer.schedule(200);
                }

                public void onFailure(Throwable caught) {
                    Main.get().showError("GetLoggedUsers", caught);
                }
            });
        }
    }

    public List<String> getConnectedUserList() {
        return this.connectUsersList;
    }

    public void addChatRoom(ChatRoomDialogBox chatRoom) {
        if (!this.chatRoomList.contains(chatRoom)) {
            this.chatRoomList.add(chatRoom);
        }
    }

    public void removeChatRoom(ChatRoomDialogBox chatRoom) {
        if (this.chatRoomList.contains(chatRoom)) {
            this.chatRoomList.remove(chatRoom);
        }
    }

    public boolean isConnectedToChat() {
        return this.chatConnected;
    }

    public List<ChatRoomDialogBox> getChatRoomList() {
        return this.chatRoomList;
    }

    public void disconnectChat() {
        this.chatConnected = false;
        this.usersConnected.setVisible(false);
        this.imgNewChatRoom.setVisible(false);
        this.usersConnected.setHTML("");
        this.imgChat.setResource(OKMBundleResources.INSTANCE.chatDisconnected());
    }

    public void logoutChat() {
        if (this.getChatRoomList().size() > 0) {
            final ChatRoomDialogBox chatRoom = this.getChatRoomList().get(0);
            chatRoom.setChatRoomActive(false);
            ServiceDefTarget endPoint = (ServiceDefTarget)this.chatService;
            endPoint.setServiceEntryPoint(RPCService.ChatService);
            this.chatService.closeRoom(chatRoom.getRoom(), new AsyncCallback<Object>(){

                public void onSuccess(Object arg0) {
                    UserInfo.this.removeChatRoom(chatRoom);
                    UserInfo.this.logoutChat();
                }

                public void onFailure(Throwable caught) {
                    Main.get().showError("CloseRoom", caught);
                    UserInfo.this.removeChatRoom(chatRoom);
                    UserInfo.this.logoutChat();
                }
            });
        } else {
            this.disconnectChat();
            ServiceDefTarget endPoint = (ServiceDefTarget)this.chatService;
            endPoint.setServiceEntryPoint(RPCService.ChatService);
            this.chatService.logout(new AsyncCallback<Object>(){

                public void onSuccess(Object result) {
                }

                public void onFailure(Throwable caught) {
                    Main.get().showError("GetLogoutChat", caught);
                }
            });
        }
    }

    public void enableChat() {
        this.imgChat.setVisible(true);
        this.imgChatSeparator.setVisible(true);
    }

    public void enableUserQuota(long quotaLimit) {
        this.quotaLimit = quotaLimit;
        this.imgUserQuota.setVisible(true);
        this.quotaUsed.setVisible(true);
        this.userQuota = true;
    }

    public void loginChat(final boolean autologin) {
        this.chatService.getLoggedUsers(new AsyncCallback<List<String>>(){

            public void onSuccess(List<String> result) {
                if (result.contains(Main.get().workspaceUserProperties.getUser())) {
                    if (!autologin) {
                        Main.get().showError("GetLoginChat", new Throwable(Main.i18n("user.info.chat.user.yet.logged")));
                    }
                } else {
                    UserInfo.this.chatService.login(new AsyncCallback<Object>(){

                        public void onSuccess(Object result) {
                            UserInfo.this.chatConnected = true;
                            UserInfo.this.imgChat.setResource(OKMBundleResources.INSTANCE.chatConnected());
                            UserInfo.this.imgChat.setTitle(Main.i18n("user.info.chat.disconnect"));
                            UserInfo.this.usersConnected.setVisible(true);
                            UserInfo.this.imgNewChatRoom.setVisible(true);
                            UserInfo.this.refreshConnectedUsers();
                            UserInfo.this.getPendingChatRoomUser();
                        }

                        public void onFailure(Throwable caught) {
                            Main.get().showError("GetLoginChat", caught);
                        }
                    });
                }
            }

            public void onFailure(Throwable caught) {
                Main.get().showError("getLoggedUsers", caught);
            }
        });
    }

    public boolean isQuotaExceed() {
        return this.quotaExceeded;
    }

    public void showDashboardUserIcons() {
        this.imgLockedDocuments.setVisible(true);
        this.imgCheckoutDocuments.setVisible(true);
        this.imgSubscriptions.setVisible(true);
        this.lockedDocuments.setVisible(true);
        this.checkoutDocuments.setVisible(true);
        this.subscriptions.setVisible(true);
    }

    public void showDashboardNewsIcons() {
        this.imgNewsDocuments.setVisible(true);
        this.newDocuments.setVisible(true);
    }

    public void showDashboardWorkflowIcons() {
        this.imgWorkflowTasks.setVisible(true);
        this.imgWorkflowPooledTasks.setVisible(true);
        this.newWorkflowTasks.setVisible(true);
        this.newWorkflowPooledTasks.setVisible(true);
    }

    public void showExtensions() {
        if (this.widgetExtensionList.size() > 0) {
            this.panel.add((Widget)new Image(OKMBundleResources.INSTANCE.separator()));
            this.panel.add((Widget)new HTML("&nbsp;"));
            for (UserInfoExtension extension : this.widgetExtensionList) {
                this.panel.add((Widget)extension);
                this.panel.add((Widget)new HTML("&nbsp;"));
            }
        }
    }

    public void addUserInfoExtension(UserInfoExtension extension) {
        this.widgetExtensionList.add(extension);
    }
}

