/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTProcessDefinition;
import com.openkm.frontend.client.service.OKMWorkflowService;
import com.openkm.frontend.client.service.OKMWorkflowServiceAsync;
import com.openkm.frontend.client.widget.wizard.WorkflowWidget;
import com.openkm.frontend.client.widget.wizard.WorkflowWidgetToFire;
import java.util.HashMap;
import java.util.List;

public class WorkflowPopup
extends DialogBox
implements WorkflowWidgetToFire {
    private final OKMWorkflowServiceAsync workflowService = (OKMWorkflowServiceAsync)GWT.create(OKMWorkflowService.class);
    private VerticalPanel vPanel;
    private HorizontalPanel hPanel;
    private Button button;
    private Button addButton;
    private ListBox listBox;
    private SimplePanel sp;
    private WorkflowWidget workflowWidget = null;
    private String uuid = "";
    final AsyncCallback<List<GWTProcessDefinition>> callbackFindLatestProcessDefinitions = new AsyncCallback<List<GWTProcessDefinition>>(){

        public void onSuccess(List<GWTProcessDefinition> result) {
            WorkflowPopup.this.listBox.clear();
            WorkflowPopup.this.listBox.addItem("", "");
            for (GWTProcessDefinition processDefinition : result) {
                if (!Main.get().workspaceUserProperties.getWorkspace().getMiscWorkflowList().contains(processDefinition.getName())) continue;
                WorkflowPopup.this.listBox.addItem(processDefinition.getName(), processDefinition.getName());
            }
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("callbackFindLatestProcessDefinitions", caught);
        }
    };
    final AsyncCallback<Object> callbackRunProcessDefinition = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            Main.get().mainPanel.dashboard.workflowDashboard.findUserTaskInstances();
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("callbackRunProcessDefinition", caught);
        }
    };

    public WorkflowPopup() {
        super(false, true);
        this.vPanel = new VerticalPanel();
        this.hPanel = new HorizontalPanel();
        this.sp = new SimplePanel();
        this.button = new Button(Main.i18n("button.close"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                WorkflowPopup.this.hide();
            }
        });
        this.addButton = new Button(Main.i18n("button.start"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                WorkflowPopup.this.addButton.setEnabled(false);
                WorkflowPopup.this.runProcessDefinition();
            }
        });
        this.listBox = new ListBox();
        this.listBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if (WorkflowPopup.this.listBox.getSelectedIndex() > 0) {
                    WorkflowPopup.this.addButton.setEnabled(true);
                } else {
                    WorkflowPopup.this.addButton.setEnabled(false);
                }
                WorkflowPopup.this.sp.setVisible(false);
                WorkflowPopup.this.sp.clear();
            }
        });
        this.listBox.setStyleName("okm-Select");
        this.vPanel.setWidth("300px");
        this.vPanel.setHeight("50px");
        this.button.setStyleName("okm-Button");
        this.addButton.setStyleName("okm-Button");
        this.addButton.setEnabled(false);
        this.hPanel.add((Widget)this.button);
        this.hPanel.add((Widget)new HTML("&nbsp;&nbsp;"));
        this.hPanel.add((Widget)this.addButton);
        this.hPanel.setCellHorizontalAlignment((Widget)this.button, VerticalPanel.ALIGN_CENTER);
        this.hPanel.setCellHorizontalAlignment((Widget)this.addButton, VerticalPanel.ALIGN_CENTER);
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.add((Widget)this.listBox);
        this.vPanel.add((Widget)this.sp);
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.add((Widget)this.hPanel);
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.setCellHorizontalAlignment((Widget)this.listBox, VerticalPanel.ALIGN_CENTER);
        this.vPanel.setCellHorizontalAlignment((Widget)this.hPanel, VerticalPanel.ALIGN_CENTER);
        super.hide();
        this.setWidget((Widget)this.vPanel);
    }

    public void enableClose() {
        this.button.setEnabled(true);
        Main.get().mainPanel.setVisible(true);
    }

    public void langRefresh() {
        this.setText(Main.i18n("workflow.label"));
        this.button.setText(Main.i18n("button.close"));
        this.addButton.setText(Main.i18n("button.start"));
    }

    public void show() {
        this.setText(Main.i18n("workflow.label"));
        this.findLatestProcessDefinitions();
        this.listBox.setVisible(true);
        this.addButton.setEnabled(false);
        this.workflowWidget = null;
        this.listBox.setVisible(true);
        this.sp.setVisible(false);
        this.sp.clear();
        int left = (Window.getClientWidth() - 300) / 2;
        int top = (Window.getClientHeight() - 100) / 2;
        this.setPopupPosition(left, top);
        super.show();
    }

    private void findLatestProcessDefinitions() {
        this.workflowService.findLatestProcessDefinitions(this.callbackFindLatestProcessDefinitions);
    }

    private void runProcessDefinition() {
        if (this.workflowWidget != null) {
            this.workflowWidget.runProcessDefinition();
        } else if (this.listBox.getSelectedIndex() > 0) {
            if (Main.get().activeFolderTree.isPanelSelected()) {
                this.uuid = Main.get().activeFolderTree.getFolder().getUuid();
            } else if (Main.get().mainPanel.desktop.browser.fileBrowser.isDocumentSelected()) {
                this.uuid = Main.get().mainPanel.desktop.browser.fileBrowser.getDocument().getUuid();
            } else if (Main.get().mainPanel.desktop.browser.fileBrowser.isFolderSelected()) {
                this.uuid = Main.get().mainPanel.desktop.browser.fileBrowser.getFolder().getUuid();
            } else if (Main.get().mainPanel.desktop.browser.fileBrowser.isMailSelected()) {
                this.uuid = Main.get().mainPanel.desktop.browser.fileBrowser.getMail().getUuid();
            }
            this.workflowWidget = new WorkflowWidget(this.listBox.getValue(this.listBox.getSelectedIndex()), this.uuid, this, new HashMap<String, Object>());
            this.listBox.setVisible(false);
            this.sp.add((Widget)this.workflowWidget);
            this.workflowWidget.runProcessDefinition();
        }
    }

    @Override
    public void finishedRunProcessDefinition() {
        this.workflowWidget = null;
        this.hide();
    }

    @Override
    public void hasPendingProcessDefinitionForms() {
        this.sp.setVisible(true);
        this.addButton.setEnabled(true);
    }
}

